/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.cli;

import net.ripe.rpki.validator.cli.CommandLineOptions;
import net.ripe.rpki.validator.commands.BottomUpValidationCommand;
import net.ripe.rpki.validator.commands.PrintCertificateRepositoryObjectCommand;
import net.ripe.rpki.validator.commands.PrintVersionCommand;
import net.ripe.rpki.validator.commands.TopDownValidationCommand;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public final class Main {
    private CommandLineOptions options;

    private static Logger getLogger() {
        return Logger.getLogger(Main.class);
    }

    private Main() {
    }

    public static void main(String[] args) {
        try {
            Main.setUpLogging();
            new Main().run(args);
            System.exit(0);
        }
        catch (Exception e) {
            Main.getLogger().error((Object)e.getMessage());
            System.exit(1);
        }
    }

    private static void setUpLogging() {
        ConsoleAppender console = new ConsoleAppender((Layout)new PatternLayout("%d{ABSOLUTE} %-5p %m%n"));
        Logger ripeNet = Logger.getLogger((String)"net.ripe");
        ripeNet.setLevel(Level.INFO);
        Logger.getRootLogger().addAppender((Appender)console);
    }

    private void run(String[] args) {
        this.parseOptions(args);
        this.execute();
    }

    private void execute() {
        if (this.options.isPrintVersionMode()) {
            new PrintVersionCommand().execute();
        } else if (this.options.isPrintHelpMode()) {
            this.options.printHelp();
        } else if (this.options.isPrintObjectMode()) {
            new PrintCertificateRepositoryObjectCommand(this.options).execute();
        } else if (this.options.isValidationMode()) {
            this.setVerbosity();
            if (this.options.isTopDownValidationEnabled()) {
                new TopDownValidationCommand(this.options).execute();
            } else {
                new BottomUpValidationCommand(this.options).execute();
            }
        }
    }

    private void parseOptions(String[] args) {
        this.options = new CommandLineOptions();
        try {
            this.options.parse(args);
        }
        catch (ParseException e) {
            Main.getLogger().fatal((Object)e.getMessage());
            System.exit(1);
        }
    }

    private void setVerbosity() {
        if (this.options.isVerboseEnabled()) {
            Logger ripeNet = Logger.getLogger((String)"net.ripe");
            ripeNet.setLevel(Level.DEBUG);
        }
    }
}

