/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import java.sql.SQLException;

public abstract class SchemaObject {
    protected final JdbcTemplate jdbcTemplate;
    protected final DbSupport dbSupport;
    protected final Schema schema;
    protected final String name;

    public SchemaObject(JdbcTemplate jdbcTemplate, DbSupport dbSupport, Schema schema, String name) {
        this.name = name;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.schema = schema;
    }

    public final Schema getSchema() {
        return this.schema;
    }

    public final String getName() {
        return this.name;
    }

    public final void drop() {
        try {
            this.doDrop();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to drop " + this, e);
        }
    }

    protected abstract void doDrop() throws SQLException;

    public String toString() {
        return this.dbSupport.quote(this.schema.getName(), this.name);
    }
}

