/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;

public final class ApplicationOptions$ {
    public static final ApplicationOptions$ MODULE$;
    private Logger logger;
    private final Config config;
    private final FiniteDuration net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval;
    private FiniteDuration validationInterval;
    private volatile byte bitmap$0;

    static {
        new ApplicationOptions$();
    }

    private Logger logger$lzycompute() {
        ApplicationOptions$ applicationOptions$ = this;
        synchronized (applicationOptions$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ApplicationOptions$.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    private FiniteDuration validationInterval$lzycompute() {
        ApplicationOptions$ applicationOptions$ = this;
        synchronized (applicationOptions$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                FiniteDuration finiteDuration;
                FiniteDuration interval = FiniteDuration$.MODULE$.apply(this.config().getDuration("validation.interval", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                if (interval.$less((Object)this.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval())) {
                    this.logger().warn((Function0)new Serializable(interval){
                        public static final long serialVersionUID = 0L;
                        private final FiniteDuration interval$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validation interval ", " is too short; using ", " instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.interval$1, ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval()}));
                        }
                        {
                            this.interval$1 = interval$1;
                        }
                    });
                    finiteDuration = this.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval();
                } else {
                    finiteDuration = interval;
                }
                this.validationInterval = finiteDuration;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.validationInterval;
        }
    }

    private Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private Config config() {
        return this.config;
    }

    public FiniteDuration net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval() {
        return this.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval;
    }

    public int httpPort() {
        return this.config().getInt("ui.http.port");
    }

    public boolean httpKioskEnabled() {
        return this.config().getBoolean("ui.kiosk.enable");
    }

    public String httpKioskUser() {
        return this.config().getString("ui.kiosk.user");
    }

    public String httpKioskPass() {
        return this.config().getString("ui.kiosk.pass");
    }

    public FiniteDuration validationInterval() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.validationInterval$lzycompute() : this.validationInterval;
    }

    public int rtrPort() {
        return this.config().getInt("rtr.port");
    }

    public boolean rtrCloseOnError() {
        return this.config().getBoolean("rtr.close-on-error");
    }

    public boolean rtrSendNotify() {
        return this.config().getBoolean("rtr.send-notify");
    }

    private File resolveFile(String path, String fileName) {
        return new File(new StringBuilder().append((Object)path).append((Object)File.separator).append((Object)fileName).toString());
    }

    public File dataFileLocation() {
        return this.resolveFile(this.config().getString("locations.datadir"), "data.json");
    }

    public File talDirLocation() {
        return new File(this.config().getString("locations.taldir"));
    }

    public File workDirLocation() {
        return new File(this.config().getString("locations.workdir"));
    }

    public String applicationLogFileName() {
        return this.config().getString("logging.application.file");
    }

    public String rtrLogFileName() {
        return this.config().getString("logging.rtr.file");
    }

    public String accessLogFileName() {
        return this.config().getString("logging.access.file");
    }

    public boolean enableLooseValidation() {
        return this.config().getBoolean("validation.loose");
    }

    private ApplicationOptions$() {
        MODULE$ = this;
        this.config = ConfigFactory.load();
        this.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval = new package.DurationInt(package$.MODULE$.DurationInt(10)).minutes();
    }
}

