/*
 * Decompiled with CFR 0.152.
 */
package org.scalatra.validation;

import java.net.URI;
import java.util.Locale;
import mojolly.inflector.InflectorImports$;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.scalatra.validation.Validators;
import org.scalatra.validation.Validators$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;
import scala.util.matching.Regex;

public final class Validators$ {
    public static final Validators$ MODULE$;

    static {
        new Validators$();
    }

    public <TValue> Validators.PredicateValidator<TValue> validate(String fieldName, String message, Function1<TValue, Object> validate2) {
        return new Validators.PredicateValidator<TValue>(fieldName, validate2, message);
    }

    public <TValue> String validate$default$2() {
        return "%s is invalid.";
    }

    public Validators.Validator<String> nonEmptyString(String fieldName, String message) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String s) {
                return s != null && new StringOps(Predef$.MODULE$.augmentString(s.trim())).nonEmpty();
            }
        }, message);
    }

    public String nonEmptyString$default$2() {
        return "%s must be present.";
    }

    public Validators.Validator<Object> notNull(String fieldName, String message) {
        return new Validators.PredicateValidator<Object>(fieldName, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object s) {
                return s != null;
            }
        }, message);
    }

    public String notNull$default$2() {
        return "%s must be present.";
    }

    public <TResult extends Traversable<Object>> Validators.Validator<TResult> nonEmptyCollection(String fieldName, String message) {
        return new Validators.PredicateValidator(fieldName, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TResult x$1) {
                return x$1.nonEmpty();
            }
        }, message);
    }

    public <TResult extends Traversable<Object>> String nonEmptyCollection$default$2() {
        return "%s must not be empty.";
    }

    public Validators.Validator<String> validEmail(String fieldName, String message) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return EmailValidator.getInstance().isValid(x$2);
            }
        }, message);
    }

    public String validEmail$default$2() {
        return "%s must be a valid email.";
    }

    public Validators.Validator<String> validAbsoluteUrl(String fieldName, boolean allowLocalHost, Seq<String> schemes) {
        return this.buildUrlValidator(fieldName, true, allowLocalHost, schemes);
    }

    public Validators.Validator<String> validUrl(String fieldName, boolean allowLocalHost, Seq<String> schemes) {
        return this.buildUrlValidator(fieldName, false, allowLocalHost, schemes);
    }

    public Validators.Validator<String> validFormat(String fieldName, Regex regex, String messageFormat) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(regex){
            public static final long serialVersionUID = 0L;
            private final Regex regex$1;

            public final boolean apply(String x$3) {
                return this.regex$1.findFirstIn((CharSequence)x$3).isDefined();
            }
            {
                this.regex$1 = regex$1;
            }
        }, messageFormat);
    }

    public String validFormat$default$3() {
        return "%s is invalid.";
    }

    public Validators.Validator<String> validConfirmation(String fieldName, String confirmationFieldName, Function0<String> confirmationValue) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(confirmationValue){
            public static final long serialVersionUID = 0L;
            private final Function0 confirmationValue$1;

            public final boolean apply(String x$4) {
                String string = x$4;
                Object object = this.confirmationValue$1.apply();
                return !(string != null ? !string.equals(object) : object != null);
            }
            {
                this.confirmationValue$1 = confirmationValue$1;
            }
        }, new StringBuilder().append((Object)"%s must match ").append((Object)InflectorImports$.MODULE$.string2InflectorString(InflectorImports$.MODULE$.string2InflectorString(confirmationFieldName).underscore()).humanize().toLowerCase(Locale.ENGLISH)).append((Object)".").toString());
    }

    public <T> Validators.Validator<T> greaterThan(String fieldName, T min, Function1<T, Ordered<T>> evidence$1) {
        return new Validators.PredicateValidator(fieldName, new Serializable(min, evidence$1){
            public static final long serialVersionUID = 0L;
            private final Object min$1;
            private final Function1 evidence$1$1;

            public final boolean apply(T x$5) {
                return ((Ordered)this.evidence$1$1.apply(x$5)).$greater(this.min$1);
            }
            {
                this.min$1 = min$1;
                this.evidence$1$1 = evidence$1$1;
            }
        }, new StringBuilder().append((Object)"%s must be greater than ").append((Object)min.toString()).toString());
    }

    public <T> Validators.Validator<T> lessThan(String fieldName, T max, Function1<T, Ordered<T>> evidence$2) {
        return new Validators.PredicateValidator(fieldName, new Serializable(max, evidence$2){
            public static final long serialVersionUID = 0L;
            private final Object max$1;
            private final Function1 evidence$2$1;

            public final boolean apply(T x$6) {
                return ((Ordered)this.evidence$2$1.apply(x$6)).$less(this.max$1);
            }
            {
                this.max$1 = max$1;
                this.evidence$2$1 = evidence$2$1;
            }
        }, new StringBuilder().append((Object)"%s must be less than ").append((Object)max.toString()).toString());
    }

    public <T> Validators.Validator<T> greaterThanOrEqualTo(String fieldName, T min, Function1<T, Ordered<T>> evidence$3) {
        return new Validators.PredicateValidator(fieldName, new Serializable(min, evidence$3){
            public static final long serialVersionUID = 0L;
            private final Object min$2;
            private final Function1 evidence$3$1;

            public final boolean apply(T x$7) {
                return ((Ordered)this.evidence$3$1.apply(x$7)).$greater$eq(this.min$2);
            }
            {
                this.min$2 = min$2;
                this.evidence$3$1 = evidence$3$1;
            }
        }, new StringBuilder().append((Object)"%s must be greater than or equal to ").append((Object)min.toString()).toString());
    }

    public <T> Validators.Validator<T> lessThanOrEqualTo(String fieldName, T max, Function1<T, Ordered<T>> evidence$4) {
        return new Validators.PredicateValidator(fieldName, new Serializable(max, evidence$4){
            public static final long serialVersionUID = 0L;
            private final Object max$2;
            private final Function1 evidence$4$1;

            public final boolean apply(T x$8) {
                return ((Ordered)this.evidence$4$1.apply(x$8)).$less$eq(this.max$2);
            }
            {
                this.max$2 = max$2;
                this.evidence$4$1 = evidence$4$1;
            }
        }, new StringBuilder().append((Object)"%s must be less than or equal to ").append((Object)max.toString()).toString());
    }

    public Validators.Validator<String> minLength(String fieldName, int min) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(min){
            public static final long serialVersionUID = 0L;
            private final int min$3;

            public final boolean apply(String x$9) {
                return new StringOps(Predef$.MODULE$.augmentString(x$9)).size() >= this.min$3;
            }
            {
                this.min$3 = min$3;
            }
        }, new StringBuilder().append((Object)"%s must be at least ").append((Object)((Object)BoxesRunTime.boxToInteger((int)min)).toString()).append((Object)" characters long.").toString());
    }

    public <TResult> Validators.Validator<TResult> oneOf(String fieldName, Seq<TResult> expected) {
        return new Validators.PredicateValidator(fieldName, new Serializable(expected){
            public static final long serialVersionUID = 0L;
            private final Seq expected$1;

            public final boolean apply(Object elem) {
                return this.expected$1.contains(elem);
            }
            {
                this.expected$1 = expected$1;
            }
        }, new StringBuilder().append((Object)"%s must be one of ").append((Object)expected.mkString("[", ", ", "]")).toString());
    }

    public Validators.Validator<String> enumValue(String fieldName, Enumeration enumeration) {
        return this.oneOf(fieldName, ((SetLike)enumeration.values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Enumeration.Value x$10) {
                return x$10.toString();
            }
        }, SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).toSeq());
    }

    private Validators.Validator<String> buildUrlValidator(String fieldName, boolean absolute, boolean allowLocalHost, Seq<String> schemes) {
        Serializable validator = new Serializable(absolute, allowLocalHost){
            public static final long serialVersionUID = 0L;
            public final boolean absolute$1;
            private final boolean allowLocalHost$1;

            public final boolean apply(String url) {
                return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(this, url){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final String url$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        URI u = URI.create(this.url$1).normalize();
                        return !this.$outer.absolute$1 || u.isAbsolute();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.url$1 = url$1;
                    }
                }).isDefined() && (this.allowLocalHost$1 || UrlValidator.getInstance().isValid(url));
            }
            {
                this.absolute$1 = absolute$1;
                this.allowLocalHost$1 = allowLocalHost$1;
            }
        };
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)validator, "%s must be a valid url.");
    }

    private Validators$() {
        MODULE$ = this;
    }
}

