/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceRange;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import org.apache.commons.lang3.Validate;

public class IpResourceSet
implements Iterable<IpResource>,
Serializable {
    public static final IpResourceSet IP_PRIVATE_USE_RESOURCES = IpResourceSet.parse("10.0.0.0/8,172.16.0.0/12,192.168.0.0/16,fc00::/7");
    public static final IpResourceSet ASN_PRIVATE_USE_RESOURCES = IpResourceSet.parse("AS64512-AS65534");
    public static final IpResourceSet ALL_PRIVATE_USE_RESOURCES = IpResourceSet.parse("AS64512-AS65534,10.0.0.0/8,172.16.0.0/12,192.168.0.0/16,fc00::/7");
    private static final long serialVersionUID = 1L;
    private NavigableMap<IpResource, IpResource> resourcesByEndPoint;

    public IpResourceSet() {
        this.resourcesByEndPoint = new TreeMap<IpResource, IpResource>();
    }

    public IpResourceSet(IpResourceSet resources) {
        this.resourcesByEndPoint = new TreeMap<IpResource, IpResource>((SortedMap<IpResource, IpResource>)resources.resourcesByEndPoint);
    }

    public IpResourceSet(IpResource ... resources) {
        this();
        for (IpResource resource : resources) {
            this.add(resource);
        }
    }

    public IpResourceSet(Collection<? extends IpResource> resources) {
        this();
        for (IpResource ipResource : resources) {
            this.add(ipResource);
        }
    }

    public void addAll(IpResourceSet ipResourceSet) {
        for (IpResource ipResource : ipResourceSet.resourcesByEndPoint.values()) {
            this.add(ipResource);
        }
    }

    public void add(IpResource resource) {
        IpResource potentialMatch;
        Validate.notNull((Object)resource, (String)"resource is null", (Object[])new Object[0]);
        UniqueIpResource start = resource.getStart();
        if (!start.equals(start.getType().getMinimum())) {
            start = start.predecessor();
        }
        IpResource resourceToAdd = this.normalize(resource);
        Iterator iterator = this.resourcesByEndPoint.tailMap(start, true).values().iterator();
        while (iterator.hasNext() && resourceToAdd.isMergeable(potentialMatch = (IpResource)iterator.next())) {
            iterator.remove();
            resourceToAdd = resourceToAdd.merge(potentialMatch);
        }
        IpResource normalized = this.normalize(resourceToAdd);
        this.resourcesByEndPoint.put(normalized.getEnd(), normalized);
    }

    public boolean isEmpty() {
        return this.resourcesByEndPoint.isEmpty();
    }

    public boolean contains(IpResource resource) {
        Map.Entry<IpResource, IpResource> potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
        return potentialMatch != null && potentialMatch.getValue().contains(resource);
    }

    public boolean contains(IpResourceSet other) {
        for (IpResource resource : other) {
            if (this.contains(resource)) continue;
            return false;
        }
        return true;
    }

    public boolean containsType(IpResourceType type) {
        for (IpResource resource : this.resourcesByEndPoint.values()) {
            if (type != resource.getType()) continue;
            return true;
        }
        return false;
    }

    public static IpResourceSet parse(String s) {
        String[] resources = s.split(",");
        IpResourceSet result = new IpResourceSet();
        for (String r : resources) {
            String trimmed = r.trim();
            if (trimmed.isEmpty()) continue;
            result.add(IpResource.parse(trimmed));
        }
        return result;
    }

    @Override
    public Iterator<IpResource> iterator() {
        return this.resourcesByEndPoint.values().iterator();
    }

    public boolean remove(IpResource resource) {
        boolean removed = false;
        Map.Entry<IpResource, IpResource> potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
        while (potentialMatch != null && potentialMatch.getValue().overlaps(resource)) {
            this.resourcesByEndPoint.remove(potentialMatch.getKey());
            removed = true;
            for (IpResourceRange remains : potentialMatch.getValue().subtract(resource)) {
                this.add(remains);
            }
            potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
        }
        return removed;
    }

    public void removeAll(IpResourceSet other) {
        for (IpResource resource : other) {
            this.remove(resource);
        }
    }

    public void retainAll(IpResourceSet other) {
        if (this.isEmpty()) {
            return;
        }
        if (other.isEmpty()) {
            this.resourcesByEndPoint.clear();
            return;
        }
        TreeMap<IpResource, IpResource> temp = new TreeMap<IpResource, IpResource>();
        Iterator<IpResource> thisIterator = this.iterator();
        Iterator<IpResource> thatIterator = other.iterator();
        IpResource thisResource = thisIterator.next();
        IpResource thatResource = thatIterator.next();
        while (thisResource != null && thatResource != null) {
            int compareTo;
            IpResource intersect = thisResource.intersect(thatResource);
            if (intersect != null) {
                temp.put(intersect.getEnd(), intersect);
            }
            if ((compareTo = thisResource.getEnd().compareTo(thatResource.getEnd())) <= 0) {
                IpResource ipResource = thisResource = thisIterator.hasNext() ? thisIterator.next() : null;
            }
            if (compareTo < 0) continue;
            thatResource = thatIterator.hasNext() ? thatIterator.next() : null;
        }
        this.resourcesByEndPoint = temp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IpResourceSet)) {
            return false;
        }
        IpResourceSet other = (IpResourceSet)obj;
        return this.resourcesByEndPoint.equals(other.resourcesByEndPoint);
    }

    public int hashCode() {
        return this.resourcesByEndPoint.hashCode();
    }

    public String toString() {
        String s = this.resourcesByEndPoint.values().toString();
        return s.substring(1, s.length() - 1);
    }

    private IpResource normalize(IpResource resource) {
        return resource.isUnique() ? resource.unique() : resource;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        if (!gf.defaulted("resourcesByEndPoint")) {
            this.resourcesByEndPoint = (NavigableMap)gf.get("resourcesByEndPoint", null);
        } else {
            SortedSet resources = (SortedSet)gf.get("resources", null);
            this.resourcesByEndPoint = new TreeMap<IpResource, IpResource>();
            for (IpResource resource : resources) {
                this.resourcesByEndPoint.put(resource.getEnd(), resource);
            }
        }
    }
}

