/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.lib;

import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.lib.Validation;
import net.ripe.rpki.validator.lib.Validation$;
import net.ripe.rpki.validator.lib.Validation$ErrorMessage$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scalaz.FailProjection;
import scalaz.Functor$;
import scalaz.NonEmptyList;
import scalaz.Scalaz$;
import scalaz.Validation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Validation$ {
    public static final Validation$ MODULE$;

    static {
        new Validation$();
    }

    public <A> List<A> NonEmptyListToSeq(NonEmptyList<A> nel) {
        return nel.list();
    }

    public <A> Validation<NonEmptyList<Validation.FeedbackMessage>, A> liftFailErrorMessage(Validation<String, A> validation, Option<String> fieldName) {
        return ((FailProjection)Scalaz$.MODULE$.ValidationFailureMA(validation.fail()).map((Function1)new Serializable(fieldName){
            public static final long serialVersionUID = 0L;
            private final Option fieldName$1;

            public final Validation.FeedbackMessage apply(String message) {
                return Validation$ErrorMessage$.MODULE$.apply(message, (Option<String>)this.fieldName$1);
            }
            {
                this.fieldName$1 = fieldName$1;
            }
        }, Functor$.MODULE$.ValidationFailureFunctor())).liftNel();
    }

    public <A> Option<String> liftFailErrorMessage$default$2() {
        return None$.MODULE$;
    }

    public <A, E, B> Function1<Option<A>, Validation<E, B>> required(Function1<A, Validation<E, B>> validator, E error) {
        return new Serializable(validator, error){
            public static final long serialVersionUID = 0L;
            private final Function1 validator$1;
            public final Object error$1;

            public final Validation<E, B> apply(Option<A> x0$1) {
                Option<A> option;
                block4: {
                    Validation validation;
                    block3: {
                        block2: {
                            option = x0$1;
                            None$ none$ = None$.MODULE$;
                            Option<A> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.required.1 $outer;

                                public final E apply() {
                                    return (E)this.$outer.error$1;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }).fail();
                            break block3;
                        }
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        Object value = some.x();
                        validation = (Validation)this.validator$1.apply(value);
                    }
                    return validation;
                }
                throw new MatchError(option);
            }
            {
                this.validator$1 = validator$1;
                this.error$1 = error$1;
            }
        };
    }

    public <A, E, B> String required$default$2() {
        return "required";
    }

    public <A, E, B> Function1<Option<A>, Validation<E, Option<B>>> optional(Function1<A, Validation<E, B>> validator) {
        return new Serializable(validator){
            public static final long serialVersionUID = 0L;
            private final Function1 validator$2;

            public final Validation<E, Option<B>> apply(Option<A> x0$2) {
                Option<A> option;
                block4: {
                    Validation validation;
                    block3: {
                        block2: {
                            option = x0$2;
                            None$ none$ = None$.MODULE$;
                            Option<A> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Option<Nothing$> apply() {
                                    return Scalaz$.MODULE$.none();
                                }
                            }).success();
                            break block3;
                        }
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        Object value = some.x();
                        validation = ((Validation)this.validator$2.apply(value)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<B> apply(B a) {
                                return Scalaz$.MODULE$.some(a);
                            }
                        });
                    }
                    return validation;
                }
                throw new MatchError(option);
            }
            {
                this.validator$2 = validator$2;
            }
        };
    }

    public <A, E, B> Function1<Option<A>, Validation<E, B>> default(Function1<A, Validation<E, B>> validator, B b) {
        return new Serializable(validator, b){
            public static final long serialVersionUID = 0L;
            private final Function1 validator$3;
            public final Object default$1;

            public final Validation<E, B> apply(Option<A> x0$3) {
                Option<A> option;
                block4: {
                    Validation validation;
                    block3: {
                        block2: {
                            option = x0$3;
                            None$ none$ = None$.MODULE$;
                            Option<A> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.default.1 $outer;

                                public final B apply() {
                                    return (B)this.$outer.default$1;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }).success();
                            break block3;
                        }
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        Object value = some.x();
                        validation = (Validation)this.validator$3.apply(value);
                    }
                    return validation;
                }
                throw new MatchError(option);
            }
            {
                this.validator$3 = validator$3;
                this.default$1 = default$1;
            }
        };
    }

    public Validation<Nothing$, String> collapseWhitespace(String s) {
        return Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
            public static final long serialVersionUID = 0L;
            private final String s$5;

            public final String apply() {
                return this.s$5.replaceAll("\\s+", " ").trim();
            }
            {
                this.s$5 = s$5;
            }
        }).success();
    }

    public String net$ripe$rpki$validator$lib$Validation$$quote(String s) {
        return new StringBuilder().append((Object)"'").append((Object)s).append((Object)"'").toString();
    }

    public Validation<String, Asn> parseAsn(String s) {
        Validation validation;
        try {
            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
                public static final long serialVersionUID = 0L;
                private final String s$1;

                public final Asn apply() {
                    return Asn.parse((String)this.s$1);
                }
                {
                    this.s$1 = s$1;
                }
            }).success();
        }
        catch (Exception exception) {
            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
                public static final long serialVersionUID = 0L;
                private final String s$1;

                public final String apply() {
                    return new StringBuilder().append((Object)Validation$.MODULE$.net$ripe$rpki$validator$lib$Validation$$quote(this.s$1)).append((Object)" is not a valid ASN").toString();
                }
                {
                    this.s$1 = s$1;
                }
            }).fail();
        }
        return validation;
    }

    public Validation<String, IpRange> parseIpRange(String s) {
        Validation validation;
        try {
            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
                public static final long serialVersionUID = 0L;
                private final String s$6;

                public final IpRange apply() {
                    return IpRange.parse((String)this.s$6);
                }
                {
                    this.s$6 = s$6;
                }
            }).success();
        }
        catch (Exception exception) {
            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
                public static final long serialVersionUID = 0L;
                private final String s$6;

                public final String apply() {
                    return new StringBuilder().append((Object)Validation$.MODULE$.net$ripe$rpki$validator$lib$Validation$$quote(this.s$6)).append((Object)" is not a valid IPv4 or IPv6 range or prefix").toString();
                }
                {
                    this.s$6 = s$6;
                }
            }).fail();
        }
        return validation;
    }

    public Validation<String, IpRange> parseIpPrefix(String s) {
        Validation validation;
        try {
            IpRange rangeOrPrefix = IpRange.parse((String)s);
            validation = rangeOrPrefix.isLegalPrefix() ? Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(rangeOrPrefix){
                public static final long serialVersionUID = 0L;
                private final IpRange rangeOrPrefix$1;

                public final IpRange apply() {
                    return this.rangeOrPrefix$1;
                }
                {
                    this.rangeOrPrefix$1 = rangeOrPrefix$1;
                }
            }).success() : Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
                public static final long serialVersionUID = 0L;
                private final String s$2;

                public final String apply() {
                    return new StringBuilder().append((Object)Validation$.MODULE$.net$ripe$rpki$validator$lib$Validation$$quote(this.s$2)).append((Object)" is not a valid IPv4 or IPv6 prefix").toString();
                }
                {
                    this.s$2 = s$2;
                }
            }).fail();
        }
        catch (Exception exception) {
            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
                public static final long serialVersionUID = 0L;
                private final String s$2;

                public final String apply() {
                    return new StringBuilder().append((Object)Validation$.MODULE$.net$ripe$rpki$validator$lib$Validation$$quote(this.s$2)).append((Object)" is not a valid IPv4 or IPv6 prefix").toString();
                }
                {
                    this.s$2 = s$2;
                }
            }).fail();
        }
        return validation;
    }

    public Validation<String, Object> parseNonNegativeInt(String s) {
        return this.parseInt(s).flatMap((Function1)new Serializable(s){
            public static final long serialVersionUID = 0L;
            public final String s$3;

            public final Validation<String, Object> apply(int x) {
                return x >= 0 ? Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final int x$1;

                    public final int apply() {
                        return this.x$1;
                    }
                    {
                        this.x$1 = x$1;
                    }
                }).success() : Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parseNonNegativeInt.1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)Validation$.MODULE$.net$ripe$rpki$validator$lib$Validation$$quote(this.$outer.s$3)).append((Object)" must be zero or positive").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).fail();
            }
            {
                this.s$3 = s$3;
            }
        });
    }

    public Validation<String, Object> parseInt(String s) {
        Validation validation;
        try {
            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
                public static final long serialVersionUID = 0L;
                private final String s$4;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return new StringOps(Predef$.MODULE$.augmentString(this.s$4)).toInt();
                }
                {
                    this.s$4 = s$4;
                }
            }).success();
        }
        catch (NumberFormatException numberFormatException) {
            validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(s){
                public static final long serialVersionUID = 0L;
                private final String s$4;

                public final String apply() {
                    return new StringBuilder().append((Object)Validation$.MODULE$.net$ripe$rpki$validator$lib$Validation$$quote(this.s$4)).append((Object)" is not a number").toString();
                }
                {
                    this.s$4 = s$4;
                }
            }).fail();
        }
        return validation;
    }

    public Validation<String, Object> parseCheckBoxValue(Option<String> s) {
        Option<String> option;
        block4: {
            Validation validation;
            block3: {
                block2: {
                    option = s;
                    if (!(option instanceof Some)) break block2;
                    validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return true;
                        }
                    }).success();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                validation = Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }).success();
            }
            return validation;
        }
        throw new MatchError(option);
    }

    public Function1<Object, Validation<String, Object>> containedIn(Range range) {
        return new Serializable(range){
            public static final long serialVersionUID = 0L;
            public final Range range$1;

            public final Validation<String, Object> apply(int value) {
                return this.range$1.contains(value) ? Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(this, value){
                    public static final long serialVersionUID = 0L;
                    private final int value$1;

                    public final int apply() {
                        return this.value$1;
                    }
                    {
                        this.value$1 = value$1;
                    }
                }).success() : Scalaz$.MODULE$.mkIdentity((Function0)new Serializable(this, value){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.containedIn.1 $outer;
                    private final int value$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("must be between %d and %d, was %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.range$1.start()), BoxesRunTime.boxToInteger((int)this.$outer.range$1.end()), BoxesRunTime.boxToInteger((int)this.value$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.value$1 = value$1;
                    }
                }).fail();
            }
            {
                this.range$1 = range$1;
            }
        };
    }

    private Validation$() {
        MODULE$ = this;
    }
}

