/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.codahale.metrics.servlets.HealthCheckServlet;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.api.RestApi;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncement;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementValidator;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump$;
import net.ripe.rpki.validator.bgp.preview.BgpRisDumpDownloader;
import net.ripe.rpki.validator.bgp.preview.BgpValidatedAnnouncement;
import net.ripe.rpki.validator.config.ApplicationOptions$;
import net.ripe.rpki.validator.config.Main$;
import net.ripe.rpki.validator.config.Main$$anon$1$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1$;
import net.ripe.rpki.validator.config.MemoryImage;
import net.ripe.rpki.validator.config.MemoryImage$;
import net.ripe.rpki.validator.config.PersistentData;
import net.ripe.rpki.validator.config.PersistentData$;
import net.ripe.rpki.validator.config.PersistentDataSerialiser$;
import net.ripe.rpki.validator.config.ReleaseInfo$;
import net.ripe.rpki.validator.config.WebFilter;
import net.ripe.rpki.validator.config.health.HealthChecks$;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.lib.DateAndTime$DateTimeOrdering$;
import net.ripe.rpki.validator.lib.OnlineNewVersionDetailFetcher;
import net.ripe.rpki.validator.lib.UserPreferences;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.Idle;
import net.ripe.rpki.validator.models.IgnoreFilter;
import net.ripe.rpki.validator.models.ProcessingStatus;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.TrackValidationProcess;
import net.ripe.rpki.validator.models.TrackValidationProcess$class;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchorData;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.TrustAnchors$;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidatedObjects;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.models.ValidationProcess$class;
import net.ripe.rpki.validator.models.ValidationProcessLogger$ObjectFetcherLogger$;
import net.ripe.rpki.validator.models.ValidationProcessLogger$class;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.rtr.RTRServer;
import net.ripe.rpki.validator.rtr.RtrSessionData;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.concurrent.stm.package$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scalaz.Failure;
import scalaz.Success;
import scalaz.Validation;

@ScalaSignature(bytes="\u0006\u0001\tms!B\u0001\u0003\u0011\u0003i\u0011\u0001B'bS:T!a\u0001\u0003\u0002\r\r|gNZ5h\u0015\t)a!A\u0005wC2LG-\u0019;pe*\u0011q\u0001C\u0001\u0005eB\\\u0017N\u0003\u0002\n\u0015\u0005!!/\u001b9f\u0015\u0005Y\u0011a\u00018fi\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"\u0001B'bS:\u001c\"a\u0004\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015Ir\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0004\u001d\u001f\t\u0007I\u0011B\u000f\u0002\u0013M,7o]5p]&#W#\u0001\u0010\u0011\u0005})cB\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\r\u0011HO]\u0005\u0003I\u0005\n1\u0001\u00153v\u0013\t1sEA\u0005TKN\u001c\u0018n\u001c8JI*\u0011A%\t\u0005\u0007S=\u0001\u000b\u0011\u0002\u0010\u0002\u0015M,7o]5p]&#\u0007\u0005C\u0003,\u001f\u0011\u0005A&\u0001\u0003nC&tGCA\u00171!\t\u0019b&\u0003\u00020)\t!QK\\5u\u0011\u0015\t$\u00061\u00013\u0003\u0011\t'oZ:\u0011\u0007M\u0019T'\u0003\u00025)\t)\u0011I\u001d:bsB\u0011aG\u0010\b\u0003oqr!\u0001O\u001e\u000e\u0003eR!A\u000f\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012BA\u001f\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\"b\u0001\u0002\t\u0003\u0001\t\u001b\"!\u0011\n\t\u000be\tE\u0011\u0001#\u0015\u0003\u0015\u0003\"AD!\t\u000f\u001d\u000b%\u0019!C\u0001\u0011\u00061An\\4hKJ,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bQa\u001d7gi)T\u0011AT\u0001\tOJL'P\u001f7fI&\u0011\u0001k\u0013\u0002\u0007\u0019><w-\u001a:\t\rI\u000b\u0005\u0015!\u0003J\u0003\u001dawnZ4fe\u0002Bq\u0001V!C\u0002\u0013\rQ+A\u0006bGR|'oU=ti\u0016lW#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016!B1di>\u0014(\"A.\u0002\t\u0005\\7.Y\u0005\u0003;b\u00131\"Q2u_J\u001c\u0016p\u001d;f[\"1q,\u0011Q\u0001\nY\u000bA\"Y2u_J\u001c\u0016p\u001d;f[\u0002Bq!Y!C\u0002\u0013\u0005!-A\u0005ti\u0006\u0014H/\u001a3BiV\t1\r\u0005\u0002\u0014I&\u0011Q\r\u0006\u0002\u0005\u0019>tw\r\u0003\u0004h\u0003\u0002\u0006IaY\u0001\u000bgR\f'\u000f^3e\u0003R\u0004\u0003bB5B\u0005\u0004%\tA[\u0001\fE\u001e\u0004(+[:Ek6\u00048/F\u0001l!\ra\u0017o]\u0007\u0002[*\u0011an\\\u0001\u0004gRl'B\u00019\u0015\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003e6\u00141AU3g!\r!x/_\u0007\u0002k*\u0011a\u000fF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=v\u0005\r\u0019V-\u001d\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fq\u0001\u001d:fm&,wO\u0003\u0002\u007f\t\u0005\u0019!m\u001a9\n\u0007\u0005\u00051P\u0001\u0006COB\u0014\u0016n\u001d#v[BDq!!\u0002BA\u0003%1.\u0001\u0007cOB\u0014\u0016n\u001d#v[B\u001c\b\u0005C\u0005\u0002\n\u0005\u0013\r\u0011\"\u0001\u0002\f\u0005A\"m\u001a9B]:|WO\\2f[\u0016tGOV1mS\u0012\fGo\u001c:\u0016\u0005\u00055\u0001c\u0001>\u0002\u0010%\u0019\u0011\u0011C>\u00031\t;\u0007/\u00118o_Vt7-Z7f]R4\u0016\r\\5eCR|'\u000f\u0003\u0005\u0002\u0016\u0005\u0003\u000b\u0011BA\u0007\u0003e\u0011w\r]!o]>,hnY3nK:$h+\u00197jI\u0006$xN\u001d\u0011\t\u0013\u0005e\u0011I1A\u0005\u0002\u0005m\u0011\u0001\u00033bi\u00064\u0015\u000e\\3\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0003S>T!!a\n\u0002\t)\fg/Y\u0005\u0005\u0003W\t\tC\u0001\u0003GS2,\u0007\u0002CA\u0018\u0003\u0002\u0006I!!\b\u0002\u0013\u0011\fG/\u0019$jY\u0016\u0004\u0003\"CA\u001a\u0003\n\u0007I\u0011AA\u001b\u0003\u0011!\u0017\r^1\u0016\u0005\u0005]\u0002c\u0001\b\u0002:%\u0019\u00111\b\u0002\u0003\u001dA+'o]5ti\u0016tG\u000fR1uC\"A\u0011qH!!\u0002\u0013\t9$A\u0003eCR\f\u0007\u0005C\u0005\u0002D\u0005\u0013\r\u0011\"\u0001\u0002F\u0005aAO];ti\u0006s7\r[8sgV\u0011\u0011q\t\t\u0005i^\fI\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\ty\u0005B\u0001\u0007[>$W\r\\:\n\t\u0005M\u0013Q\n\u0002\f)J,8\u000f^!oG\"|'\u000f\u0003\u0005\u0002X\u0005\u0003\u000b\u0011BA$\u00035!(/^:u\u0003:\u001c\u0007n\u001c:tA!I\u00111L!C\u0002\u0013\u0005\u0011QL\u0001\u0005e>\f7/\u0006\u0002\u0002`A!\u00111JA1\u0013\u0011\t\u0019'!\u0014\u0003!Y\u000bG.\u001b3bi\u0016$wJ\u00196fGR\u001c\b\u0002CA4\u0003\u0002\u0006I!a\u0018\u0002\u000bI|\u0017m\u001d\u0011\t\u0013\u0005-\u0014I1A\u0005\u0002\u00055\u0014aD;tKJ\u0004&/\u001a4fe\u0016t7-Z:\u0016\u0005\u0005=\u0004\u0003\u00027r\u0003c\u0002B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o\"\u0011a\u00017jE&!\u00111PA;\u0005=)6/\u001a:Qe\u00164WM]3oG\u0016\u001c\b\u0002CA@\u0003\u0002\u0006I!a\u001c\u0002!U\u001cXM\u001d)sK\u001a,'/\u001a8dKN\u0004\u0003\"CAB\u0003\n\u0007I\u0011AAC\u0003)AG\u000f\u001e9DY&,g\u000e^\u000b\u0003\u0003\u000f\u0003B!!#\u0002 6\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0004dY&,g\u000e\u001e\u0006\u0005\u0003#\u000b\u0019*\u0001\u0003j[Bd'\u0002BAK\u0003/\u000bA\u0001\u001b;ua*!\u0011\u0011TAN\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QT\u0001\u0004_J<\u0017\u0002BAQ\u0003\u0017\u0013qcU=ti\u0016lG)\u001a4bk2$\b\n\u001e;q\u00072LWM\u001c;\t\u0011\u0005\u0015\u0016\t)A\u0005\u0003\u000f\u000b1\u0002\u001b;ua\u000ec\u0017.\u001a8uA!I\u0011\u0011V!C\u0002\u0013\u0005\u00111V\u0001\u000bQR$\b\u000fU1sC6\u001cXCAAW!\u0011\ty+!.\u000e\u0005\u0005E&\u0002BAZ\u0003'\u000ba\u0001]1sC6\u001c\u0018\u0002BA\\\u0003c\u0013!\u0002\u0013;uaB\u000b'/Y7t\u0011!\tY,\u0011Q\u0001\n\u00055\u0016a\u00035uiB\u0004\u0016M]1ng\u0002B\u0011\"a0B\u0005\u0004%\t!!1\u0002)\t<\u0007OU5t\tVl\u0007\u000fR8x]2|\u0017\rZ3s+\t\t\u0019\rE\u0002{\u0003\u000bL1!a2|\u0005Q\u0011u\r\u001d*jg\u0012+X\u000e\u001d#po:dw.\u00193fe\"A\u00111Z!!\u0002\u0013\t\u0019-A\u000bcOB\u0014\u0016n\u001d#v[B$un\u001e8m_\u0006$WM\u001d\u0011\t\u0013\u0005=\u0017I1A\u0005\u0002\u0005E\u0017aC7f[>\u0014\u00180S7bO\u0016,\"!a5\u0011\t1\f\u0018Q\u001b\t\u0004\u001d\u0005]\u0017bAAm\u0005\tYQ*Z7pefLU.Y4f\u0011!\ti.\u0011Q\u0001\n\u0005M\u0017\u0001D7f[>\u0014\u00180S7bO\u0016\u0004\u0003bBAq\u0003\u0012\u0005\u00111]\u0001\u0012kB$\u0017\r^3NK6|'/_%nC\u001e,G\u0003BAs\u0003c$2!LAt\u0011!\tI/a8A\u0004\u0005-\u0018a\u0003;sC:\u001c\u0018m\u0019;j_:\u00042\u0001\\Aw\u0013\r\ty/\u001c\u0002\t\u001b\u0006L(-\u001a+y]\"A\u00111_Ap\u0001\u0004\t)0A\u0001g!\u001d\u0019\u0012q_Ak\u0003+L1!!?\u0015\u0005%1UO\\2uS>t\u0017\u0007C\u0005\u0002~\u0006\u0013\r\u0011\"\u0001\u0002\u0000\u0006I!\u000f\u001e:TKJ4XM]\u000b\u0003\u0005\u0003\u00012\u0001\tB\u0002\u0013\r\u0011)!\t\u0002\n%R\u00136+\u001a:wKJD\u0001B!\u0003BA\u0003%!\u0011A\u0001\u000beR\u00148+\u001a:wKJ\u0004\u0003b\u0002B\u0007\u0003\u0012%!qB\u0001\u0011Y>\fG\r\u0016:vgR\fen\u00195peN$\"A!\u0005\u0011\t\u0005-#1C\u0005\u0005\u0005+\tiE\u0001\u0007UeV\u001cH/\u00118dQ>\u00148\u000fC\u0004\u0003\u001a\u0005#IAa\u0007\u0002\u001fI,gM]3tQJK7\u000fR;naN$\u0012!\f\u0005\b\u0005?\tE\u0011\u0002B\u000e\u00031\u0011XO\u001c,bY&$\u0017\r^8s\u0011\u001d\u0011y\"\u0011C\u0005\u0005G!2!\fB\u0013\u0011!\u00119C!\tA\u0002\t%\u0012\u0001\u0005;skN$\u0018I\\2i_Jt\u0015-\\3t!\u0015\u0011YC!\r6\u001d\r9$QF\u0005\u0004\u0005_!\u0012a\u00029bG.\fw-Z\u0005\u0004q\nM\"b\u0001B\u0018)!9!qG!\u0005\n\tm\u0011\u0001\u0004:v]^+'mU3sm\u0016\u0014\bb\u0002B\u001e\u0003\u0012%!QH\u0001\reVt'\u000b\u001e:TKJ4XM\u001d\u000b\u0003\u0005\u0003AqA!\u0011B\t\u0013\u0011\u0019%A\u0003tKR,\b\u000f\u0006\u0003\u0003F\te\u0003\u0003\u0002B$\u0005+j!A!\u0013\u000b\t\t-#QJ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\t\t=#\u0011K\u0001\u0006U\u0016$H/\u001f\u0006\u0005\u0005'\nY*A\u0004fG2L\u0007o]3\n\t\t]#\u0011\n\u0002\u0007'\u0016\u0014h/\u001a:\t\u0011\t-#q\ba\u0001\u0005\u000b\u0002")
public class Main {
    private final Logger logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Main.class));
    private final ActorSystem actorSystem = ActorSystem$.MODULE$.apply();
    private final long startedAt = System.currentTimeMillis();
    private final Ref<Seq<BgpRisDump>> bgpRisDumps = Ref$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpRisDump[]{new BgpRisDump("http://www.ris.ripe.net/dumps/riswhoisdump.IPv4.gz", BgpRisDump$.MODULE$.apply$default$2(), BgpRisDump$.MODULE$.apply$default$3()), new BgpRisDump("http://www.ris.ripe.net/dumps/riswhoisdump.IPv6.gz", BgpRisDump$.MODULE$.apply$default$2(), BgpRisDump$.MODULE$.apply$default$3())})), (OptManifest)ClassManifestFactory$.MODULE$.classType(Seq.class, (OptManifest)ClassManifestFactory$.MODULE$.classType(BgpRisDump.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0])));
    private final BgpAnnouncementValidator bgpAnnouncementValidator = new BgpAnnouncementValidator(this.actorSystem());
    private final File dataFile = ApplicationOptions$.MODULE$.dataFileLocation();
    private final PersistentData data = (PersistentData)PersistentDataSerialiser$.MODULE$.read(this.dataFile()).getOrElse((Function0)new $anonfun$6(this));
    private final Seq<TrustAnchor> trustAnchors = (Seq)this.loadTrustAnchors().all().map((Function1)new $anonfun$7(this), Seq$.MODULE$.canBuildFrom());
    private final ValidatedObjects roas = ValidatedObjects$.MODULE$.apply(new TrustAnchors((Seq<TrustAnchor>)((Seq)this.trustAnchors().filter((Function1)new $anonfun$9(this)))));
    private final Ref<UserPreferences> userPreferences = Ref$.MODULE$.apply((Object)this.data().userPreferences(), (OptManifest)ClassManifestFactory$.MODULE$.classType(UserPreferences.class));
    private final SystemDefaultHttpClient httpClient = new SystemDefaultHttpClient();
    private final HttpParams httpParams = this.httpClient().getParams();
    private final BgpRisDumpDownloader bgpRisDumpDownloader;
    private final Ref<MemoryImage> memoryImage;
    private final RTRServer rtrServer;

    public static void main(String[] stringArray) {
        Main$.MODULE$.main(stringArray);
    }

    public Logger logger() {
        return this.logger;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public long startedAt() {
        return this.startedAt;
    }

    public Ref<Seq<BgpRisDump>> bgpRisDumps() {
        return this.bgpRisDumps;
    }

    public BgpAnnouncementValidator bgpAnnouncementValidator() {
        return this.bgpAnnouncementValidator;
    }

    public File dataFile() {
        return this.dataFile;
    }

    public PersistentData data() {
        return this.data;
    }

    public Seq<TrustAnchor> trustAnchors() {
        return this.trustAnchors;
    }

    public ValidatedObjects roas() {
        return this.roas;
    }

    public Ref<UserPreferences> userPreferences() {
        return this.userPreferences;
    }

    public SystemDefaultHttpClient httpClient() {
        return this.httpClient;
    }

    public HttpParams httpParams() {
        return this.httpParams;
    }

    public BgpRisDumpDownloader bgpRisDumpDownloader() {
        return this.bgpRisDumpDownloader;
    }

    public Ref<MemoryImage> memoryImage() {
        return this.memoryImage;
    }

    public void updateMemoryImage(Function1<MemoryImage, MemoryImage> f, MaybeTxn transaction) {
        package$.MODULE$.atomic().apply((Function1)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            private final Function1 f$1;

            public final void apply(InTxn transaction) {
                int oldVersion = ((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).version();
                this.$outer.memoryImage().transform(this.f$1, (Object)transaction);
                if (oldVersion != ((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).version()) {
                    this.$outer.bgpAnnouncementValidator().startUpdate((Seq<BgpAnnouncement>)((Seq)((TraversableLike)this.$outer.bgpRisDumps().apply((Object)transaction)).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<BgpAnnouncement> apply(BgpRisDump x$2) {
                            return x$2.announcedRoutes();
                        }
                    }, Seq$.MODULE$.canBuildFrom())), (Seq<RtrPrefix>)((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).getDistinctRtrPrefixes().toSeq());
                    this.$outer.rtrServer().notify(((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).version());
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        }, transaction);
    }

    public RTRServer rtrServer() {
        return this.rtrServer;
    }

    private TrustAnchors loadTrustAnchors() {
        ArrayList tals = new ArrayList(FileUtils.listFiles((File)ApplicationOptions$.MODULE$.talDirLocation(), (String[])((String[])((Object[])new String[]{"tal"})), (boolean)false));
        return TrustAnchors$.MODULE$.load((Seq<File>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(tals).asScala()));
    }

    public void net$ripe$rpki$validator$config$Main$$refreshRisDumps() {
        Future$.MODULE$.traverse((TraversableOnce)this.bgpRisDumps().single().get(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final Future<BgpRisDump> apply(BgpRisDump dump) {
                return this.$outer.bgpRisDumpDownloader().download(dump, (ExecutionContext)this.$outer.actorSystem().dispatcher());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.actorSystem().dispatcher()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply(Seq<BgpRisDump> dumps) {
                package$.MODULE$.atomic().apply((Function1)new Serializable(this, dumps){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$refreshRisDumps$2 $outer;
                    private final Seq dumps$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().bgpRisDumps().update((Object)this.dumps$1, (Object)transaction);
                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().bgpAnnouncementValidator().startUpdate((Seq<BgpAnnouncement>)((Seq)this.dumps$1.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<BgpAnnouncement> apply(BgpRisDump x$3) {
                                return x$3.announcedRoutes();
                            }
                        }, Seq$.MODULE$.canBuildFrom())), (Seq<RtrPrefix>)((MemoryImage)this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().memoryImage().apply((Object)transaction)).getDistinctRtrPrefixes().toSeq());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.dumps$1 = dumps$1;
                    }
                }, (MaybeTxn)MaybeTxn$.MODULE$.unknown());
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
    }

    public void net$ripe$rpki$validator$config$Main$$runValidator() {
        DateTime now = new DateTime();
        Seq needUpdating = (Seq)((TraversableLike)((MemoryImage)this.memoryImage().single().get()).trustAnchors().all().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TrustAnchor ta) {
                return ta.status().isIdle();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TrustAnchor, Idle> apply(TrustAnchor ta) {
                ProcessingStatus processingStatus = ta.status();
                if (processingStatus instanceof Idle) {
                    Tuple2 tuple2;
                    Idle idle = (Idle)processingStatus;
                    DateTime nextUpdate = idle.nextUpdate();
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)idle, (Object)nextUpdate);
                    Idle x$4 = (Idle)tuple22._1();
                    DateTime nextUpdate2 = (DateTime)tuple22._2();
                    return new Tuple2((Object)ta, (Object)x$4);
                }
                throw new MatchError((Object)processingStatus);
            }
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final DateTime now$1;

            public final boolean apply(Tuple2<TrustAnchor, Idle> x$6) {
                Idle idle;
                Tuple2<TrustAnchor, Idle> tuple2 = x$6;
                if (tuple2 != null && (idle = (Idle)tuple2._2()) != null) {
                    DateTime nextUpdate = idle.nextUpdate();
                    boolean bl = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nextUpdate, (Ordering)DateAndTime$DateTimeOrdering$.MODULE$).$less$eq((Object)this.now$1);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.now$1 = now$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TrustAnchor, Idle> x$7) {
                Tuple2<TrustAnchor, Idle> tuple2 = x$7;
                if (tuple2 != null) {
                    TrustAnchor ta = (TrustAnchor)tuple2._1();
                    Idle idle = (Idle)tuple2._2();
                    if (idle != null) {
                        String string = ta.name();
                        return string;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.net$ripe$rpki$validator$config$Main$$runValidator((Seq<String>)needUpdating);
    }

    public void net$ripe$rpki$validator$config$Main$$runValidator(Seq<String> trustAnchorNames) {
        int maxStaleDays = ((UserPreferences)this.userPreferences().single().get()).maxStaleDays();
        Seq<TrustAnchor> trustAnchors = ((MemoryImage)this.memoryImage().single().get()).trustAnchors().all();
        Seq taLocators = (Seq)((TraversableLike)trustAnchorNames.flatMap((Function1)new Serializable(this, trustAnchors){
            public static final long serialVersionUID = 0L;
            private final Seq trustAnchors$1;

            public final Iterable<TrustAnchor> apply(String name) {
                return Option$.MODULE$.option2Iterable(this.trustAnchors$1.find((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final boolean apply(TrustAnchor x$8) {
                        String string = x$8.name();
                        String string2 = this.name$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.name$1 = name$1;
                    }
                }));
            }
            {
                this.trustAnchors$1 = trustAnchors$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TrustAnchorLocator apply(TrustAnchor x$9) {
                return x$9.locator();
            }
        }, Seq$.MODULE$.canBuildFrom());
        taLocators.foreach((Function1)new Serializable(this, maxStaleDays){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            public final int maxStaleDays$1;

            public final Future<BoxedUnit> apply(TrustAnchorLocator trustAnchorLocator) {
                return Future$.MODULE$.apply((Function0)new Serializable(this, trustAnchorLocator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1 $outer;
                    public final TrustAnchorLocator trustAnchorLocator$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        TrackValidationProcess process = new TrackValidationProcess(this){
                            private final Ref<MemoryImage> memoryImage;
                            private volatile ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module;

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            private ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$lzycompute() {
                                $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1$$anon$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if (this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module != null) return this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module;
                                    this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module = new ValidationProcessLogger$ObjectFetcherLogger$(this);
                                    return this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module;
                                }
                            }

                            public final ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger() {
                                return this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module == null ? this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$lzycompute() : this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module;
                            }

                            public Seq net$ripe$rpki$validator$models$ValidationProcessLogger$$super$objectFetcherListeners() {
                                return ValidationProcess$class.objectFetcherListeners(this);
                            }

                            public Map net$ripe$rpki$validator$models$ValidationProcessLogger$$super$validateObjects(CertificateRepositoryObjectValidationContext certificate) {
                                return TrackValidationProcess$class.validateObjects(this, certificate);
                            }

                            public PartialFunction net$ripe$rpki$validator$models$ValidationProcessLogger$$super$exceptionHandler() {
                                return ValidationProcess$class.exceptionHandler(this);
                            }

                            public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
                                return ValidationProcessLogger$class.objectFetcherListeners(this);
                            }

                            public Map<URI, ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate) {
                                return ValidationProcessLogger$class.validateObjects(this, certificate);
                            }

                            public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
                                return ValidationProcessLogger$class.exceptionHandler(this);
                            }

                            public Validation net$ripe$rpki$validator$models$TrackValidationProcess$$super$runProcess() {
                                return ValidationProcess$class.runProcess(this);
                            }

                            public Map net$ripe$rpki$validator$models$TrackValidationProcess$$super$validateObjects(CertificateRepositoryObjectValidationContext certificate) {
                                return super.validateObjects(certificate);
                            }

                            public Validation<String, Map<URI, ValidatedObject>> runProcess() {
                                return TrackValidationProcess$class.runProcess(this);
                            }

                            public Ref<MemoryImage> memoryImage() {
                                return this.memoryImage;
                            }
                            {
                                super($outer.trustAnchorLocator$1, $outer.net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer().maxStaleDays$1, ApplicationOptions$.MODULE$.workDirLocation());
                                TrackValidationProcess$class.$init$(this);
                                ValidationProcessLogger$class.$init$(this);
                                this.memoryImage = $outer.net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer().net$ripe$rpki$validator$config$Main$$anonfun$$$outer().memoryImage();
                            }
                        };
                        try {
                            Validation<String, Map<URI, ValidatedObject>> validation;
                            block8: {
                                block7: {
                                    block6: {
                                        validation = ((TrackValidationProcess)process).runProcess();
                                        if (!(validation instanceof Success)) break block6;
                                        Success success = (Success)validation;
                                        Map validatedObjects = (Map)success.a();
                                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this, validatedObjects){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1 $outer;
                                            private final Map validatedObjects$1;

                                            public final MemoryImage apply(MemoryImage x$10) {
                                                return x$10.updateValidatedObjects(this.$outer.trustAnchorLocator$1, (Seq<ValidatedObject>)this.validatedObjects$1.values().toSeq());
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.validatedObjects$1 = validatedObjects$1;
                                            }
                                        }, (MaybeTxn)MaybeTxn$.MODULE$.unknown());
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block7;
                                    }
                                    if (!(validation instanceof Failure)) break block8;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                return;
                            }
                            throw new MatchError(validation);
                        }
                        finally {
                            long now = DateTimeUtils.currentTimeMillis();
                            process.shutdown();
                        }
                    }

                    public /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1 net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.trustAnchorLocator$1 = trustAnchorLocator$1;
                    }
                }, (ExecutionContext)this.$outer.actorSystem().dispatcher());
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.maxStaleDays$1 = maxStaleDays$1;
            }
        });
    }

    private void runWebServer() {
        Server server = this.setup(new Server(ApplicationOptions$.MODULE$.httpPort()));
        scala.sys.package$.MODULE$.addShutdownHook((Function0)new Serializable(this, server){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            private final Server server$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.server$1.stop();
                this.$outer.logger().info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Terminating...";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.server$1 = server$1;
            }
        });
        server.start();
        this.logger().info((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Welcome to the RIPE NCC RPKI Validator, now available on port ").append((Object)BoxesRunTime.boxToInteger((int)ApplicationOptions$.MODULE$.httpPort())).append((Object)". Hit CTRL+C to terminate.").toString();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private RTRServer runRtrServer() {
        void var1_1;
        RTRServer rtrServer = new RTRServer(ApplicationOptions$.MODULE$.rtrPort(), ApplicationOptions$.MODULE$.rtrCloseOnError(), ApplicationOptions$.MODULE$.rtrSendNotify(), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).version();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0<Set<RtrPrefix>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final Set<RtrPrefix> apply() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply() {
                return this.apply$mcS$sp();
            }

            public short apply$mcS$sp() {
                return Main$.MODULE$.net$ripe$rpki$validator$config$Main$$sessionId();
            }
        }, this.actorSystem());
        rtrServer.startServer();
        return var1_1;
    }

    private Server setup(Server server) {
        WebFilter webFilter = new WebFilter(this){
            private final Object dataFileLock;
            private final /* synthetic */ Main $outer;

            private Object dataFileLock() {
                return this.dataFileLock;
            }

            private void updateAndPersist(Function1<InTxn, BoxedUnit> f) {
                Object object = this.dataFileLock();
                synchronized (object) {
                    Tuple2 tuple2 = (Tuple2)package$.MODULE$.atomic().apply((Function1)new $anon$1$$anonfun$17(this, f), (MaybeTxn)MaybeTxn$.MODULE$.unknown());
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        MemoryImage image = (MemoryImage)tuple2._1();
                        UserPreferences userPreferences = (UserPreferences)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)image, (Object)userPreferences);
                        MemoryImage image2 = (MemoryImage)tuple23._1();
                        UserPreferences userPreferences2 = (UserPreferences)tuple23._2();
                        Filters x$24 = image2.filters();
                        Whitelist x$25 = image2.whitelist();
                        UserPreferences x$26 = userPreferences2;
                        Map x$27 = (Map)image2.trustAnchors().all().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, TrustAnchorData> apply(TrustAnchor ta) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ta.name()), (Object)new TrustAnchorData(ta.enabled()));
                            }
                        }, scala.collection.package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
                        int x$28 = PersistentData$.MODULE$.apply$default$1();
                        PersistentDataSerialiser$.MODULE$.write(new PersistentData(x$28, x$24, x$25, x$26, (Map<String, TrustAnchorData>)x$27), this.$outer.dataFile());
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                }
            }

            public void startTrustAnchorValidation(Seq<String> trustAnchors) {
                this.$outer.net$ripe$rpki$validator$config$Main$$runValidator(trustAnchors);
            }

            public TrustAnchors trustAnchors() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).trustAnchors();
            }

            public ValidatedObjects validatedObjects() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).validatedObjects();
            }

            public Filters filters() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).filters();
            }

            public void addFilter(IgnoreFilter filter2) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, filter2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final IgnoreFilter filter$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$addFilter$1 $outer;

                            public final MemoryImage apply(MemoryImage x$12) {
                                return x$12.addFilter(this.$outer.filter$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.filter$1 = filter$1;
                    }
                });
            }

            public void removeFilter(IgnoreFilter filter2) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, filter2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final IgnoreFilter filter$2;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$removeFilter$1 $outer;

                            public final MemoryImage apply(MemoryImage x$13) {
                                return x$13.removeFilter(this.$outer.filter$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.filter$2 = filter$2;
                    }
                });
            }

            public Whitelist whitelist() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).whitelist();
            }

            public void addWhitelistEntry(RtrPrefix entry) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final RtrPrefix entry$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$addWhitelistEntry$1 $outer;

                            public final MemoryImage apply(MemoryImage x$14) {
                                return x$14.addWhitelistEntry(this.$outer.entry$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.entry$1 = entry$1;
                    }
                });
            }

            public void removeWhitelistEntry(RtrPrefix entry) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final RtrPrefix entry$2;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$removeWhitelistEntry$1 $outer;

                            public final MemoryImage apply(MemoryImage x$15) {
                                return x$15.removeWhitelistEntry(this.$outer.entry$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.entry$2 = entry$2;
                    }
                });
            }

            public Seq<BgpRisDump> bgpRisDumps() {
                return (Seq)this.$outer.bgpRisDumps().single().get();
            }

            public IndexedSeq<BgpValidatedAnnouncement> validatedAnnouncements() {
                return this.$outer.bgpAnnouncementValidator().validatedAnnouncements();
            }

            public Set<RtrPrefix> getRtrPrefixes() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }

            public Iterable<RtrSessionData> sessionData() {
                return this.$outer.rtrServer().rtrSessions().allClientData();
            }

            public OnlineNewVersionDetailFetcher newVersionDetailFetcher() {
                return new OnlineNewVersionDetailFetcher(ReleaseInfo$.MODULE$.version(), (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return Source$.MODULE$.fromURL(new URL("https://certification.ripe.net/content/static/validator/latest-version.properties"), "UTF-8").mkString();
                    }
                });
            }

            public UserPreferences userPreferences() {
                return (UserPreferences)this.$outer.userPreferences().single().get();
            }

            public void updateUserPreferences(UserPreferences userPreferences) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, userPreferences){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    private final UserPreferences userPreferences$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().userPreferences().set((Object)this.userPreferences$1, (Object)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.userPreferences$1 = userPreferences$1;
                    }
                });
            }

            public void updateTrustAnchorState(TrustAnchorLocator locator, boolean enabled) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, locator, enabled){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final TrustAnchorLocator locator$1;
                    public final boolean enabled$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().memoryImage().transform((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$updateTrustAnchorState$1 $outer;

                            public final MemoryImage apply(MemoryImage x$16) {
                                return x$16.updateTrustAnchorState(this.$outer.locator$1, this.$outer.enabled$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (Object)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.locator$1 = locator$1;
                        this.enabled$1 = enabled$1;
                    }
                });
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataFileLock = new Object();
            }
        };
        RestApi restApiServlet = new RestApi(this){
            private final /* synthetic */ Main $outer;

            public Set<RtrPrefix> getVrpObjects() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)server, "/", 1);
        root.setResourceBase(this.getClass().getResource("/public").toString());
        ServletHolder defaultServletHolder = new ServletHolder((Servlet)new DefaultServlet());
        defaultServletHolder.setName("default");
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        root.addServlet(defaultServletHolder, "/*");
        root.addServlet(new ServletHolder((Servlet)restApiServlet), "/api/*");
        root.addServlet(new ServletHolder((Servlet)new HealthCheckServlet(HealthChecks$.MODULE$.registry())), "/health");
        root.addFilter(new FilterHolder((Filter)webFilter), "/*", EnumSet.allOf(DispatcherType.class));
        RequestLogHandler handler = new RequestLogHandler();
        NCSARequestLog requestLog = new NCSARequestLog(ApplicationOptions$.MODULE$.accessLogFileName());
        requestLog.setRetainDays(90);
        requestLog.setAppend(true);
        requestLog.setExtended(false);
        requestLog.setLogLatency(true);
        handler.setRequestLog((RequestLog)requestLog);
        RequestLogHandler requestLogHandler = handler;
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)root);
        handlers.addHandler((Handler)requestLogHandler);
        server.setHandler((Handler)handlers);
        return server;
    }

    public Main() {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpParams(), (int)120000);
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpParams(), (int)120000);
        this.bgpRisDumpDownloader = new BgpRisDumpDownloader((HttpClient)this.httpClient());
        this.memoryImage = Ref$.MODULE$.apply((Object)new MemoryImage(this.data().filters(), this.data().whitelist(), new TrustAnchors(this.trustAnchors()), this.roas(), MemoryImage$.MODULE$.apply$default$5()), (OptManifest)ClassManifestFactory$.MODULE$.classType(MemoryImage.class));
        this.rtrServer = this.runRtrServer();
        this.runWebServer();
        this.actorSystem().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$config$Main$$runValidator();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
        this.actorSystem().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).hours(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$config$Main$$refreshRisDumps();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
    }
}

