/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.store;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.validator.models.StoredRepositoryObject;
import net.ripe.rpki.validator.models.StoredRepositoryObject$;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.RepositoryObjectStore;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.junit.runner.RunWith;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\tI\"+\u001a9pg&$xN]=PE*,7\r^*u_J,G+Z:u\u0015\t\u0019A!A\u0003ti>\u0014XM\u0003\u0002\u0006\r\u0005Ia/\u00197jI\u0006$xN\u001d\u0006\u0003\u000f!\tAA\u001d9lS*\u0011\u0011BC\u0001\u0005e&\u0004XMC\u0001\f\u0003\rqW\r^\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqa];qa>\u0014H/\u0003\u0002\u0014!\t\tb+\u00197jI\u0006$xN\u001d+fgR\u001c\u0015m]3\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012!C:dC2\fG/Z:u\u0015\u0005I\u0012aA8sO&\u00111D\u0006\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0004#\u0001\t\u0007I\u0011A\u0012\u0002!\u0015C\u0016)\u0014)M\u000b~k\u0015IT%G\u000bN#V#\u0001\u0013\u0011\u0005\u0015rS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001C7b]&4Wm\u001d;\u000b\u0005%R\u0013aA2ng*\u00111\u0006L\u0001\u0007GJL\b\u000f^8\u000b\u000552\u0011aB2p[6|gn]\u0005\u0003_\u0019\u00121\"T1oS\u001a,7\u000f^\"ng\"1\u0011\u0007\u0001Q\u0001\n\u0011\n\u0011#\u0012-B\u001bBcUiX'B\u001d&3Ui\u0015+!\u0011\u001d\u0019\u0004A1A\u0005\u0002Q\nA#\u0012-B\u001bBcUiX'B\u001d&3Ui\u0015+`+JKU#A\u001b\u0011\u0005YRT\"A\u001c\u000b\u0005-A$\"A\u001d\u0002\t)\fg/Y\u0005\u0003w]\u00121!\u0016*J\u0011\u0019i\u0004\u0001)A\u0005k\u0005)R\tW!N!2+u,T!O\u0013\u001a+5\u000bV0V%&\u0003\u0003bB \u0001\u0005\u0004%\t\u0001Q\u0001\u0018\u000bb\u000bU\n\u0015'F?6\u000be*\u0013$F'R{vJ\u0011&F\u0007R+\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\ta!\\8eK2\u001c\u0018B\u0001$D\u0005Y\u0019Fo\u001c:fIJ+\u0007o\\:ji>\u0014\u0018p\u00142kK\u000e$\bB\u0002%\u0001A\u0003%\u0011)\u0001\rF1\u0006k\u0005\u000bT#`\u001b\u0006s\u0015JR#T)~{%IS#D)\u0002Bqa\u0001\u0001C\u0002\u0013\u0005!*F\u0001L!\t\u0001C*\u0003\u0002N\u0005\t)\"+\u001a9pg&$xN]=PE*,7\r^*u_J,\u0007BB(\u0001A\u0003%1*\u0001\u0004ti>\u0014X\r\t\u0015\u0005\u0001EK&\f\u0005\u0002S/6\t1K\u0003\u0002U+\u00061!/\u001e8oKJT!A\u0016\r\u0002\u000b),h.\u001b;\n\u0005a\u001b&a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u00027B\u0011ALX\u0007\u0002;*\u0011aKF\u0005\u0003?v\u00131BS+oSR\u0014VO\u001c8fe\u0002")
public class RepositoryObjectStoreTest
extends ValidatorTestCase
implements BeforeAndAfter {
    private final ManifestCms EXAMPLE_MANIFEST;
    private final URI EXAMPLE_MANIFEST_URI;
    private final StoredRepositoryObject EXAMPLE_MANIFEST_OBJECT;
    private final RepositoryObjectStore store;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuite.class.runTest((FunSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuite.class.run((FunSuite)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    @Override
    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    @Override
    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public ManifestCms EXAMPLE_MANIFEST() {
        return this.EXAMPLE_MANIFEST;
    }

    public URI EXAMPLE_MANIFEST_URI() {
        return this.EXAMPLE_MANIFEST_URI;
    }

    public StoredRepositoryObject EXAMPLE_MANIFEST_OBJECT() {
        return this.EXAMPLE_MANIFEST_OBJECT;
    }

    public RepositoryObjectStore store() {
        return this.store;
    }

    public RepositoryObjectStoreTest() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.EXAMPLE_MANIFEST = ManifestCmsTest.getRootManifestCms();
        this.EXAMPLE_MANIFEST_URI = URI.create("rsync://some.host/example.mft");
        this.EXAMPLE_MANIFEST_OBJECT = StoredRepositoryObject$.MODULE$.apply(this.EXAMPLE_MANIFEST_URI(), this.EXAMPLE_MANIFEST().getEncoded());
        this.store = new RepositoryObjectStore((DataSource)DataSources$.MODULE$.InMemoryDataSource());
        this.before((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoryObjectStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().clear();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.after((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTimeUtils.setCurrentMillisSystem();
            }
        });
        this.test("Storing same object multiple times should not fail", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoryObjectStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().put(this.$outer.EXAMPLE_MANIFEST_OBJECT());
                this.$outer.store().put(this.$outer.EXAMPLE_MANIFEST_OBJECT());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should retrieve *latest* Repository Object by url", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoryObjectStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI mft_uri = URI.create("rsync://some.host/foo/bar/mft.mft");
                DateTime now = new DateTime();
                DateTimeUtils.setCurrentMillisFixed((long)now.getMillis());
                ManifestCms mft_now = ManifestCmsTest.getRootManifestCms();
                StoredRepositoryObject manifest_now_stored = StoredRepositoryObject$.MODULE$.apply(mft_uri, mft_now.getEncoded());
                this.$outer.store().put(manifest_now_stored);
                DateTimeUtils.setCurrentMillisFixed((long)now.plusDays(1).getMillis());
                ManifestCms mft_tomorrow = ManifestCmsTest.getRootManifestCms();
                StoredRepositoryObject mft_tomorrow_stored = StoredRepositoryObject$.MODULE$.apply(mft_uri, mft_tomorrow.getEncoded());
                this.$outer.store().put(mft_tomorrow_stored);
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getLatestByUrl(mft_uri)).should(this.$outer.equal(new Some((Object)mft_tomorrow_stored)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should retrieve Repository Object by hash", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoryObjectStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().put(this.$outer.EXAMPLE_MANIFEST_OBJECT());
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getByHash((byte[])this.$outer.EXAMPLE_MANIFEST_OBJECT().hash().toArray(ClassTag$.MODULE$.Byte()))).should(this.$outer.equal(new Some((Object)this.$outer.EXAMPLE_MANIFEST_OBJECT())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should store multiple objects including already existing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoryObjectStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaCms ROA_OBJECT = RoaCmsTest.getRoaCms();
                StoredRepositoryObject ROA_RETRIEVED_OBJECT = StoredRepositoryObject$.MODULE$.apply(URI.create("rsync://some.host/example.roa"), ROA_OBJECT.getEncoded());
                this.$outer.store().put(this.$outer.EXAMPLE_MANIFEST_OBJECT());
                this.$outer.store().put((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StoredRepositoryObject[]{this.$outer.EXAMPLE_MANIFEST_OBJECT(), ROA_RETRIEVED_OBJECT})));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getByHash((byte[])ROA_RETRIEVED_OBJECT.hash().toArray(ClassTag$.MODULE$.Byte()))).should(this.$outer.equal(new Some((Object)ROA_RETRIEVED_OBJECT)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

