/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.rtr;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsObjectMother;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.validator.config.MemoryImage;
import net.ripe.rpki.validator.config.MemoryImage$;
import net.ripe.rpki.validator.lib.Port$;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.Filters$;
import net.ripe.rpki.validator.models.Idle;
import net.ripe.rpki.validator.models.ProcessingStatus;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchor$;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObjects;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.models.Whitelist$;
import net.ripe.rpki.validator.rtr.CacheResetPdu;
import net.ripe.rpki.validator.rtr.CacheResponsePdu;
import net.ripe.rpki.validator.rtr.EndOfDataPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu$;
import net.ripe.rpki.validator.rtr.IPv4PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.IPv6PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.Pdu;
import net.ripe.rpki.validator.rtr.RTRClient;
import net.ripe.rpki.validator.rtr.RTRServer;
import net.ripe.rpki.validator.rtr.ResetQueryPdu;
import net.ripe.rpki.validator.rtr.RtrServerScenariosTest$;
import net.ripe.rpki.validator.rtr.SerialNotifyPdu;
import net.ripe.rpki.validator.rtr.SerialQueryPdu;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.runner.RunWith;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import org.scalatest.junit.JUnitRunner;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u00015\u0011aC\u0015;s'\u0016\u0014h/\u001a:TG\u0016t\u0017M]5pgR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1A\u001d;s\u0015\t)a!A\u0005wC2LG-\u0019;pe*\u0011q\u0001C\u0001\u0005eB\\\u0017N\u0003\u0002\n\u0015\u0005!!/\u001b9f\u0015\u0005Y\u0011a\u00018fi\u000e\u00011\u0003\u0002\u0001\u000f)q\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000fM,\b\u000f]8si&\u00111\u0003\u0005\u0002\u0012-\u0006d\u0017\u000eZ1u_J$Vm\u001d;DCN,\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u001a\u0003\ry'oZ\u0005\u00037Y\u0011\u0011CQ3g_J,\u0017I\u001c3BMR,'/\u00117m!\t)R$\u0003\u0002\u001f-\tq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\b\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0003\u0011\u001d)\u0003A1A\u0005\u0002\u0019\nA\u0001]8siV\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0002J]RDaA\f\u0001!\u0002\u00139\u0013!\u00029peR\u0004\u0003b\u0002\u0019\u0001\u0001\u0004%\t!M\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0003I\u0002\"aI\u001a\n\u0005Q\u0012!!\u0003*U%N+'O^3s\u0011\u001d1\u0004\u00011A\u0005\u0002]\n!b]3sm\u0016\u0014x\fJ3r)\tA4\b\u0005\u0002)s%\u0011!(\u000b\u0002\u0005+:LG\u000fC\u0004=k\u0005\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0013\u0007\u0003\u0004?\u0001\u0001\u0006KAM\u0001\bg\u0016\u0014h/\u001a:!\u0011\u001d\u0001\u0005\u00011A\u0005\u0002\u0005\u000baa\u00197jK:$X#\u0001\"\u0011\u0005\r\u001a\u0015B\u0001#\u0003\u0005%\u0011FKU\"mS\u0016tG\u000fC\u0004G\u0001\u0001\u0007I\u0011A$\u0002\u0015\rd\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u00029\u0011\"9A(RA\u0001\u0002\u0004\u0011\u0005B\u0002&\u0001A\u0003&!)A\u0004dY&,g\u000e\u001e\u0011\t\u000f1\u0003\u0001\u0019!C\u0001\u001b\u0006)1-Y2iKV\ta\nE\u0002P)Zk\u0011\u0001\u0015\u0006\u0003#J\u000b1a\u001d;n\u0015\t\u0019\u0016&\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0016)\u0003\u0007I+g\r\u0005\u0002X56\t\u0001L\u0003\u0002Z\t\u000511m\u001c8gS\u001eL!a\u0017-\u0003\u00175+Wn\u001c:z\u00136\fw-\u001a\u0005\b;\u0002\u0001\r\u0011\"\u0001_\u0003%\u0019\u0017m\u00195f?\u0012*\u0017\u000f\u0006\u00029?\"9A\bXA\u0001\u0002\u0004q\u0005BB1\u0001A\u0003&a*\u0001\u0004dC\u000eDW\r\t\u0005\bG\u0002\u0001\r\u0011\"\u0001e\u0003%\u0019Xm]:j_:LE-F\u0001f!\tAc-\u0003\u0002hS\t)1\u000b[8si\"9\u0011\u000e\u0001a\u0001\n\u0003Q\u0017!D:fgNLwN\\%e?\u0012*\u0017\u000f\u0006\u00029W\"9A\b[A\u0001\u0002\u0004)\u0007BB7\u0001A\u0003&Q-\u0001\u0006tKN\u001c\u0018n\u001c8JI\u0002Bqa\u001c\u0001A\u0002\u0013\u0005\u0001/A\u0002uC2,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i\u0012\tA!\u001e;jY&\u0011ao\u001d\u0002\u0013)J,8\u000f^!oG\"|'\u000fT8dCR|'\u000fC\u0004y\u0001\u0001\u0007I\u0011A=\u0002\u000fQ\fGn\u0018\u0013fcR\u0011\u0001H\u001f\u0005\by]\f\t\u00111\u0001r\u0011\u0019a\b\u0001)Q\u0005c\u0006!A/\u00197!\u0011\u0015q\b\u0001\"\u0011\u0000\u0003%\u0011WMZ8sK\u0006cG\u000eF\u00019\u0011\u0019\t\u0019\u0001\u0001C!\u007f\u0006A\u0011M\u001a;fe\u0006cG\u000eK\u0004\u0001\u0003\u000f\t9\"!\u0007\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u00051!/\u001e8oKJT1!!\u0005\u0019\u0003\u0015QWO\\5u\u0013\u0011\t)\"a\u0003\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u00111\u0004\t\u0005\u0003;\t\t#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0003\f\n\t\u0005\r\u0012q\u0004\u0002\f\u0015Vs\u0017\u000e\u001e*v]:,'\u000f")
public class RtrServerScenariosTest
extends ValidatorTestCase
implements BeforeAndAfterAll,
BeforeAndAfter {
    private final int port;
    private RTRServer server;
    private RTRClient client;
    private Ref<MemoryImage> cache;
    private short sessionId;
    private TrustAnchorLocator tal;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuite.class.runTest((FunSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    @Override
    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    @Override
    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuite.class.run((FunSuite)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void beforeAll(Map<String, Object> configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, configMap);
    }

    public void afterAll(Map<String, Object> configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, configMap);
    }

    public int port() {
        return this.port;
    }

    public RTRServer server() {
        return this.server;
    }

    public void server_$eq(RTRServer x$1) {
        this.server = x$1;
    }

    public RTRClient client() {
        return this.client;
    }

    public void client_$eq(RTRClient x$1) {
        this.client = x$1;
    }

    public Ref<MemoryImage> cache() {
        return this.cache;
    }

    public void cache_$eq(Ref<MemoryImage> x$1) {
        this.cache = x$1;
    }

    public short sessionId() {
        return this.sessionId;
    }

    public void sessionId_$eq(short x$1) {
        this.sessionId = x$1;
    }

    public TrustAnchorLocator tal() {
        return this.tal;
    }

    public void tal_$eq(TrustAnchorLocator x$1) {
        this.tal = x$1;
    }

    public void beforeAll() {
        ActorSystem actorSystem = ActorSystem$.MODULE$.apply();
        File file = new File("/tmp");
        String caName = "test ca";
        URI location = URI.create("rsync://example.com/");
        String publicKeyInfo = "info";
        ArrayList prefetchUris = new ArrayList();
        this.tal_$eq(new TrustAnchorLocator(file, caName, location, publicKeyInfo, prefetchUris));
        TrustAnchors trustAnchors = new TrustAnchors((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustAnchor[]{new TrustAnchor(this.tal(), (ProcessingStatus)new Idle(new DateTime(), (Option)None$.MODULE$), true, TrustAnchor$.MODULE$.apply$default$4(), TrustAnchor$.MODULE$.apply$default$5(), TrustAnchor$.MODULE$.apply$default$6(), TrustAnchor$.MODULE$.apply$default$7())})));
        ValidatedObjects validatedObjects = new ValidatedObjects(Predef$.MODULE$.Map().empty());
        this.cache_$eq((Ref<MemoryImage>)Ref$.MODULE$.apply((Object)new MemoryImage(new Filters(Filters$.MODULE$.apply$default$1()), new Whitelist(Whitelist$.MODULE$.apply$default$1()), trustAnchors, validatedObjects, MemoryImage$.MODULE$.apply$default$5()), (OptManifest)ClassManifestFactory$.MODULE$.classType(MemoryImage.class)));
        this.server_$eq(new RTRServer(this.port(), true, true, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ((MemoryImage)this.$outer.cache().single().get()).version();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final Set<RtrPrefix> apply() {
                return ((MemoryImage)this.$outer.cache().single().get()).getDistinctRtrPrefixes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final short apply() {
                return this.apply$mcS$sp();
            }

            public short apply$mcS$sp() {
                return this.$outer.sessionId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, actorSystem));
        this.server().startServer();
    }

    public void afterAll() {
        this.server().stopServer();
    }

    public RtrServerScenariosTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.port = Port$.MODULE$.any();
        this.server = null;
        this.client = null;
        this.cache = null;
        this.sessionId = (short)new Random().nextInt(65536);
        this.tal = null;
        this.before((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.client_$eq(new RTRClient(this.$outer.port()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.after((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TrustAnchors trustAnchors = new TrustAnchors((Seq)Seq$.MODULE$.empty());
                ValidatedObjects validatedObjects = new ValidatedObjects(Predef$.MODULE$.Map().empty());
                this.$outer.cache().single().transform((Function1)new Serializable(this, trustAnchors, validatedObjects){
                    public static final long serialVersionUID = 0L;
                    private final TrustAnchors trustAnchors$1;
                    private final ValidatedObjects validatedObjects$1;

                    public final MemoryImage apply(MemoryImage db) {
                        return new MemoryImage(new Filters(Filters$.MODULE$.apply$default$1()), new Whitelist(Whitelist$.MODULE$.apply$default$1()), this.trustAnchors$1, this.validatedObjects$1, MemoryImage$.MODULE$.apply$default$5());
                    }
                    {
                        this.trustAnchors$1 = trustAnchors$1;
                        this.validatedObjects$1 = validatedObjects$1;
                    }
                });
                this.$outer.client().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Server should answer with data to ResetQuery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List prefixes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RoaPrefix[]{RoaCmsObjectMother.TEST_IPV4_PREFIX_1, RoaCmsObjectMother.TEST_IPV4_PREFIX_2, RoaCmsObjectMother.TEST_IPV6_PREFIX, RoaCmsObjectMother.TEST_IPV6_PREFIX}));
                ValidityPeriod validityPeriod = new ValidityPeriod((ReadableInstant)new DateTime(), (ReadableInstant)new DateTime().plusYears(1));
                RoaCms roa = RoaCmsObjectMother.getRoaCms((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)prefixes).asJava()), (ValidityPeriod)validityPeriod, (Asn)RoaCmsObjectMother.TEST_ASN);
                URI roaUri = URI.create("rsync://example.com/roa.roa");
                ValidObject validatedRoa = new ValidObject(roaUri, Predef$.MODULE$.Set().empty(), (CertificateRepositoryObject)roa);
                Seq roas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidObject[]{validatedRoa}));
                this.$outer.cache().single().transform((Function1)new Serializable(this, roas){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final Seq roas$1;

                    public final MemoryImage apply(MemoryImage db) {
                        return db.updateValidatedObjects(this.$outer.net$ripe$rpki$validator$rtr$RtrServerScenariosTest$$anonfun$$$outer().tal(), this.roas$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.roas$1 = roas$1;
                    }
                });
                this.$outer.client().sendPdu((Pdu)new ResetQueryPdu());
                RTRClient qual$1 = this.$outer.client();
                int x$1 = 5;
                int x$2 = qual$1.getResponse$default$2();
                List responsePdus = qual$1.getResponse(x$1, x$2);
                this.$outer.convertToIntShouldWrapper(responsePdus.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)5)));
                Iterator iter = responsePdus.iterator();
                Pdu pdu = (Pdu)iter.next();
                if (pdu instanceof CacheResponsePdu) {
                    CacheResponsePdu cacheResponsePdu = (CacheResponsePdu)pdu;
                    short responseSessionId = cacheResponsePdu.sessionId();
                    this.$outer.convertToShortShouldWrapper(responseSessionId).should(this.$outer.equal(BoxesRunTime.boxToShort((short)this.$outer.sessionId())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Pdu pdu2 = (Pdu)iter.next();
                    if (pdu2 instanceof IPv4PrefixAnnouncePdu) {
                        IPv4PrefixAnnouncePdu iPv4PrefixAnnouncePdu = (IPv4PrefixAnnouncePdu)pdu2;
                        Ipv4Address start = iPv4PrefixAnnouncePdu.ipv4PrefixStart();
                        byte length = iPv4PrefixAnnouncePdu.prefixLength();
                        byte maxLength = iPv4PrefixAnnouncePdu.maxLength();
                        Asn asn = iPv4PrefixAnnouncePdu.asn();
                        this.$outer.convertToAnyRefShouldWrapper(start).should(this.$outer.equal(Ipv4Address.parse((String)"10.64.0.0")));
                        this.$outer.convertToByteShouldWrapper(length).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)12)));
                        this.$outer.convertToByteShouldWrapper(maxLength).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)24)));
                        this.$outer.convertToAnyRefShouldWrapper(asn).should(this.$outer.equal(Asn.parse((String)"AS65000")));
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        Pdu pdu3 = (Pdu)iter.next();
                        if (pdu3 instanceof IPv4PrefixAnnouncePdu) {
                            IPv4PrefixAnnouncePdu iPv4PrefixAnnouncePdu2 = (IPv4PrefixAnnouncePdu)pdu3;
                            Ipv4Address start2 = iPv4PrefixAnnouncePdu2.ipv4PrefixStart();
                            byte length2 = iPv4PrefixAnnouncePdu2.prefixLength();
                            byte maxLength2 = iPv4PrefixAnnouncePdu2.maxLength();
                            Asn asn2 = iPv4PrefixAnnouncePdu2.asn();
                            this.$outer.convertToAnyRefShouldWrapper(start2).should(this.$outer.equal(Ipv4Address.parse((String)"10.32.0.0")));
                            this.$outer.convertToByteShouldWrapper(length2).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)12)));
                            this.$outer.convertToByteShouldWrapper(maxLength2).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)12)));
                            this.$outer.convertToAnyRefShouldWrapper(asn2).should(this.$outer.equal(Asn.parse((String)"AS65000")));
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            Pdu pdu4 = (Pdu)iter.next();
                            if (pdu4 instanceof IPv6PrefixAnnouncePdu) {
                                IPv6PrefixAnnouncePdu iPv6PrefixAnnouncePdu = (IPv6PrefixAnnouncePdu)pdu4;
                                Ipv6Address start3 = iPv6PrefixAnnouncePdu.ipv6PrefixStart();
                                byte length3 = iPv6PrefixAnnouncePdu.prefixLength();
                                byte maxLength3 = iPv6PrefixAnnouncePdu.maxLength();
                                Asn asn3 = iPv6PrefixAnnouncePdu.asn();
                                this.$outer.convertToAnyRefShouldWrapper(start3).should(this.$outer.equal(Ipv6Address.parse((String)"2001:0:200::")));
                                this.$outer.convertToByteShouldWrapper(length3).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)39)));
                                this.$outer.convertToByteShouldWrapper(maxLength3).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)39)));
                                this.$outer.convertToAnyRefShouldWrapper(asn3).should(this.$outer.equal(Asn.parse((String)"AS65000")));
                                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                                long lastSerial = 0L;
                                Pdu pdu5 = (Pdu)iter.next();
                                if (pdu5 instanceof EndOfDataPdu) {
                                    EndOfDataPdu endOfDataPdu = (EndOfDataPdu)pdu5;
                                    short responseSessionId2 = endOfDataPdu.sessionId();
                                    long serial = endOfDataPdu.serial();
                                    this.$outer.convertToShortShouldWrapper(responseSessionId2).should(this.$outer.equal(BoxesRunTime.boxToShort((short)this.$outer.sessionId())));
                                    this.$outer.convertToLongShouldWrapper(serial).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)((MemoryImage)this.$outer.cache().single().get()).version())));
                                    lastSerial = serial;
                                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.client().isConnected())).should(this.$outer.be().apply(true));
                                    this.$outer.client().sendPdu((Pdu)new SerialQueryPdu(this.$outer.sessionId(), lastSerial));
                                    RTRClient qual$2 = this.$outer.client();
                                    int x$3 = 2;
                                    int x$4 = qual$2.getResponse$default$2();
                                    List responsePdusBeforeNewRoas = qual$2.getResponse(x$3, x$4);
                                    this.$outer.convertToIntShouldWrapper(responsePdusBeforeNewRoas.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)));
                                    iter = responsePdusBeforeNewRoas.iterator();
                                    Pdu pdu6 = (Pdu)iter.next();
                                    if (pdu6 instanceof CacheResponsePdu) {
                                        CacheResponsePdu cacheResponsePdu2 = (CacheResponsePdu)pdu6;
                                        short responseSessionId3 = cacheResponsePdu2.sessionId();
                                        this.$outer.convertToShortShouldWrapper(responseSessionId3).should(this.$outer.equal(BoxesRunTime.boxToShort((short)this.$outer.sessionId())));
                                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                                        Pdu pdu7 = (Pdu)iter.next();
                                        if (pdu7 instanceof EndOfDataPdu) {
                                            EndOfDataPdu endOfDataPdu2 = (EndOfDataPdu)pdu7;
                                            short responseSessionId4 = endOfDataPdu2.sessionId();
                                            long serial2 = endOfDataPdu2.serial();
                                            this.$outer.convertToShortShouldWrapper(responseSessionId4).should(this.$outer.equal(BoxesRunTime.boxToShort((short)this.$outer.sessionId())));
                                            this.$outer.convertToLongShouldWrapper(serial2).should(this.$outer.equal(BoxesRunTime.boxToLong((long)lastSerial)));
                                            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                                            this.$outer.convertToAnyRefShouldWrapper(this.$outer.client()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("connected")));
                                            this.$outer.cache().single().transform((Function1)new Serializable(this, roas){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ $anonfun$3 $outer;
                                                private final Seq roas$1;

                                                public final MemoryImage apply(MemoryImage db) {
                                                    return db.updateValidatedObjects(this.$outer.net$ripe$rpki$validator$rtr$RtrServerScenariosTest$$anonfun$$$outer().tal(), this.roas$1);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.roas$1 = roas$1;
                                                }
                                            });
                                            this.$outer.server().notify((long)((MemoryImage)this.$outer.cache().single().get()).version());
                                            RTRClient qual$3 = this.$outer.client();
                                            int x$5 = 1;
                                            int x$6 = qual$3.getResponse$default$2();
                                            List responsePdusAfterCacheUpdate = qual$3.getResponse(x$5, x$6);
                                            this.$outer.convertToIntShouldWrapper(responsePdusAfterCacheUpdate.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                                            Pdu pdu8 = (Pdu)responsePdusAfterCacheUpdate.head();
                                            if (pdu8 instanceof SerialNotifyPdu) {
                                                BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                                                this.$outer.client().sendPdu((Pdu)new SerialQueryPdu(this.$outer.sessionId(), lastSerial));
                                                RTRClient qual$4 = this.$outer.client();
                                                int x$7 = 1;
                                                int x$8 = qual$4.getResponse$default$2();
                                                List responsePdusAfterNewRoas = qual$4.getResponse(x$7, x$8);
                                                this.$outer.convertToIntShouldWrapper(responsePdusAfterNewRoas.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                                                Pdu pdu9 = (Pdu)responsePdusAfterNewRoas.head();
                                                if (pdu9 instanceof CacheResetPdu) {
                                                    BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                                                    this.$outer.convertToAnyRefShouldWrapper(this.$outer.client()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("connected")));
                                                    return;
                                                }
                                                throw this.$outer.fail("Should get cache reset response");
                                            }
                                            throw this.$outer.fail("Should get serial notify");
                                        }
                                        throw this.$outer.fail("Expected end of data");
                                    }
                                    throw this.$outer.fail("Should get cache response");
                                }
                                throw this.$outer.fail("Expected end of data");
                            }
                            throw this.$outer.fail("Should get IPv6 Announce Pdu");
                        }
                        throw this.$outer.fail("Should get IPv4 Announce Pdu");
                    }
                    throw this.$outer.fail("Should get IPv4 Announce Pdu");
                }
                throw this.$outer.fail("Should get cache response");
            }

            public /* synthetic */ RtrServerScenariosTest net$ripe$rpki$validator$rtr$RtrServerScenariosTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Server should answer with No Data Available Error Pdu when RTRClient sends ResetQuery -- and there is no data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.client().sendPdu((Pdu)new ResetQueryPdu());
                RTRClient qual$5 = this.$outer.client();
                int x$9 = qual$5.getResponse$default$1();
                int x$10 = qual$5.getResponse$default$2();
                List responsePdus = qual$5.getResponse(x$9, x$10);
                this.$outer.convertToIntShouldWrapper(responsePdus.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                Pdu response = (Pdu)responsePdus.head();
                this.$outer.assert(response instanceof ErrorPdu);
                ErrorPdu errorPdu = (ErrorPdu)response;
                this.$outer.convertToIntShouldWrapper(errorPdu.errorCode()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)ErrorPdu$.MODULE$.NoDataAvailable())));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.client()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("connected")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Server should answer with Invalid Request Error Pdu when RTRClient sends nonsense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.client().sendPdu((Pdu)new ErrorPdu(ErrorPdu$.MODULE$.NoDataAvailable(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), ""));
                RTRClient qual$6 = this.$outer.client();
                int x$11 = qual$6.getResponse$default$1();
                int x$12 = qual$6.getResponse$default$2();
                List responsePdus = qual$6.getResponse(x$11, x$12);
                this.$outer.convertToIntShouldWrapper(responsePdus.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                Pdu response = (Pdu)responsePdus.head();
                this.$outer.assert(response instanceof ErrorPdu);
                ErrorPdu errorPdu = (ErrorPdu)response;
                this.$outer.convertToIntShouldWrapper(errorPdu.errorCode()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)ErrorPdu$.MODULE$.InvalidRequest())));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.client()).should(this.$outer.not()).be(Symbol$.MODULE$.apply("connected"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Server should answer with '5 - Unsupported PDU Type' when unsupported PDU type is sent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.client().sendData((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, (byte)255, 0, 0, 0, 0, 0, 8}), ClassTag$.MODULE$.Byte()));
                RTRClient qual$7 = this.$outer.client();
                int x$13 = qual$7.getResponse$default$1();
                int x$14 = qual$7.getResponse$default$2();
                List responsePdus = qual$7.getResponse(x$13, x$14);
                this.$outer.convertToIntShouldWrapper(responsePdus.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                Pdu response = (Pdu)responsePdus.head();
                this.$outer.assert(response instanceof ErrorPdu);
                ErrorPdu errorPdu = (ErrorPdu)response;
                this.$outer.convertToIntShouldWrapper(errorPdu.errorCode()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)ErrorPdu$.MODULE$.UnsupportedPduType())));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.client()).should(this.$outer.not()).be(Symbol$.MODULE$.apply("connected"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Server should answer with '4: Unsupported Protocol Version' when unsupported protocol is sent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.client().sendData((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 0, 0, 0, 0, 0, 8}), ClassTag$.MODULE$.Byte()));
                RTRClient qual$8 = this.$outer.client();
                int x$15 = qual$8.getResponse$default$1();
                int x$16 = qual$8.getResponse$default$2();
                List responsePdus = qual$8.getResponse(x$15, x$16);
                this.$outer.convertToIntShouldWrapper(responsePdus.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                Pdu response = (Pdu)responsePdus.head();
                this.$outer.assert(response instanceof ErrorPdu);
                ErrorPdu errorPdu = (ErrorPdu)response;
                this.$outer.convertToIntShouldWrapper(errorPdu.errorCode()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)ErrorPdu$.MODULE$.UnsupportedProtocolVersion())));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.client()).should(this.$outer.not()).be(Symbol$.MODULE$.apply("connected"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Server should answer with CorruptData when PDU length less than 8", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RtrServerScenariosTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.client().sendData((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 2, 0, 0, 0, 0, 0, 6}), ClassTag$.MODULE$.Byte()));
                RTRClient qual$9 = this.$outer.client();
                int x$17 = qual$9.getResponse$default$1();
                int x$18 = qual$9.getResponse$default$2();
                List responsePdus = qual$9.getResponse(x$17, x$18);
                this.$outer.convertToIntShouldWrapper(responsePdus.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                Pdu response = (Pdu)responsePdus.head();
                this.$outer.assert(response instanceof ErrorPdu);
                ErrorPdu errorPdu = (ErrorPdu)response;
                this.$outer.convertToIntShouldWrapper(errorPdu.errorCode()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)ErrorPdu$.MODULE$.CorruptData())));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.client()).should(this.$outer.not()).be(Symbol$.MODULE$.apply("connected"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

