/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.rtr;

import net.ripe.ipresource.Asn;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.rpki.validator.rtr.CacheResetPdu;
import net.ripe.rpki.validator.rtr.CacheResponsePdu;
import net.ripe.rpki.validator.rtr.EndOfDataPdu;
import net.ripe.rpki.validator.rtr.EndOfDataPdu$;
import net.ripe.rpki.validator.rtr.ErrorPdu;
import net.ripe.rpki.validator.rtr.IPv4PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.IPv6PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.Pdu;
import net.ripe.rpki.validator.rtr.PduTest$;
import net.ripe.rpki.validator.rtr.Pdus$;
import net.ripe.rpki.validator.rtr.ResetQueryPdu;
import net.ripe.rpki.validator.rtr.SerialNotifyPdu;
import net.ripe.rpki.validator.rtr.SerialQueryPdu;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.junit.runner.RunWith;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Right;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\r<Q!\u0001\u0002\t\u00025\tq\u0001\u00153v)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001e:\u000b\u0005\u00151\u0011!\u0003<bY&$\u0017\r^8s\u0015\t9\u0001\"\u0001\u0003sa.L'BA\u0005\u000b\u0003\u0011\u0011\u0018\u000e]3\u000b\u0003-\t1A\\3u\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011q\u0001\u00153v)\u0016\u001cHoE\u0002\u0010%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\n\u001a\u0013\tQBC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001d\u001f\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!9qd\u0004b\u0001\n\u0003\u0001\u0013a\u0006(p\t\u0006$\u0018-\u0011<bS2\f'\r\\3QIV\u0014\u0015\u0010^3t+\u0005\t\u0003cA\n#I%\u00111\u0005\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'\u0015J!A\n\u000b\u0003\t\tKH/\u001a\u0005\u0007Q=\u0001\u000b\u0011B\u0011\u000219{G)\u0019;b\u0003Z\f\u0017\u000e\\1cY\u0016\u0004F-\u001e\"zi\u0016\u001c\b\u0005C\u0004+\u001f\t\u0007I\u0011A\u0016\u0002%9{G)\u0019;b\u0003Z\f\u0017\u000e\\1cY\u0016\u0004F-^\u000b\u0002YA\u0011a\"L\u0005\u0003]\t\u0011\u0001\"\u0012:s_J\u0004F-\u001e\u0005\u0007a=\u0001\u000b\u0011\u0002\u0017\u0002'9{G)\u0019;b\u0003Z\f\u0017\u000e\\1cY\u0016\u0004F-\u001e\u0011\t\u000fIz!\u0019!C\u0001g\u00051R*\u0011-`\u0011\u0016\u000bE)\u0012*`'\"{%\u000bV0W\u00032+V)F\u00015!\t\u0019R'\u0003\u00027)\t)1\u000b[8si\"1\u0001h\u0004Q\u0001\nQ\nq#T!Y?\"+\u0015\tR#S?NCuJ\u0015+`-\u0006cU+\u0012\u0011\t\u000fiz\u0011\u0011!C\u0005w\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005a\u0004CA\u001fC\u001b\u0005q$BA A\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u0010\u0002\u0007\u001f\nTWm\u0019;\u0007\tA\u0011\u0001!R\n\u0003\t\u001a\u0003\"a\u0012&\u000e\u0003!S!!\u0013\u0003\u0002\u000fM,\b\u000f]8si&\u00111\n\u0013\u0002\u0012-\u0006d\u0017\u000eZ1u_J$Vm\u001d;DCN,\u0007\"\u0002\u000fE\t\u0003iE#\u0001(\u0011\u00059!\u0005\u0006\u0002#Q5n\u0003\"!\u0015-\u000e\u0003IS!a\u0015+\u0002\rI,hN\\3s\u0015\t)f+A\u0003kk:LGOC\u0001X\u0003\ry'oZ\u0005\u00033J\u0013qAU;o/&$\b.A\u0003wC2,XmI\u0001]!\ti\u0016-D\u0001_\u0015\t)vL\u0003\u0002a-\u0006I1oY1mCR,7\u000f^\u0005\u0003Ez\u00131BS+oSR\u0014VO\u001c8fe\u0002")
public class PduTest
extends ValidatorTestCase {
    public static short MAX_HEADER_SHORT_VALUE() {
        return PduTest$.MODULE$.MAX_HEADER_SHORT_VALUE();
    }

    public static ErrorPdu NoDataAvailablePdu() {
        return PduTest$.MODULE$.NoDataAvailablePdu();
    }

    public static byte[] NoDataAvailablePduBytes() {
        return PduTest$.MODULE$.NoDataAvailablePduBytes();
    }

    public PduTest() {
        this.test("convert to byte array an ErrorPdu without causingPdu nor errorText", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)PduTest$.MODULE$.NoDataAvailablePdu());
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(PduTest$.MODULE$.NoDataAvailablePduBytes()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert serial notify pdu to byte array and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                SerialNotifyPdu serialNotifyPdu = new SerialNotifyPdu(PduTest$.MODULE$.MAX_HEADER_SHORT_VALUE(), EndOfDataPdu$.MODULE$.MAX_SERIAL());
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, (byte)255, (byte)255, 0, 0, 0, 12, (byte)255, (byte)255, (byte)255, (byte)255}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)serialNotifyPdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof SerialNotifyPdu) {
                    SerialNotifyPdu serialNotifyPdu2 = (SerialNotifyPdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(serialNotifyPdu2).should(this.$outer.equal(serialNotifyPdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert serial query pdu to byte array and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                SerialQueryPdu serialQueryPdu = new SerialQueryPdu(PduTest$.MODULE$.MAX_HEADER_SHORT_VALUE(), EndOfDataPdu$.MODULE$.MAX_SERIAL());
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, (byte)255, (byte)255, 0, 0, 0, 12, (byte)255, (byte)255, (byte)255, (byte)255}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)serialQueryPdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof SerialQueryPdu) {
                    SerialQueryPdu serialQueryPdu2 = (SerialQueryPdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(serialQueryPdu2).should(this.$outer.equal(serialQueryPdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert reset pdu to byte array and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                ResetQueryPdu resetPdu = new ResetQueryPdu();
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 2, 0, 0, 0, 0, 0, 8}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)resetPdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof ResetQueryPdu) {
                    ResetQueryPdu resetQueryPdu = (ResetQueryPdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(resetQueryPdu).should(this.$outer.equal(resetPdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert cache response pdu to byte array and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                CacheResponsePdu cacheResponsePdu = new CacheResponsePdu(PduTest$.MODULE$.MAX_HEADER_SHORT_VALUE());
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 3, (byte)255, (byte)255, 0, 0, 0, 8}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)cacheResponsePdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof CacheResponsePdu) {
                    CacheResponsePdu cacheResponsePdu2 = (CacheResponsePdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(cacheResponsePdu2).should(this.$outer.equal(cacheResponsePdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert ipv4 prefix announce pdu to byte array and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                IPv4PrefixAnnouncePdu ipv4PrefixPdu = new IPv4PrefixAnnouncePdu(Ipv4Address.parse((String)"10.0.0.0"), 8, 10, Asn.parse((String)"65535"));
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 4, 0, 0, 0, 0, 0, 20, 1, 8, 10, 0, 10, 0, 0, 0, 0, 0, (byte)255, (byte)255}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)ipv4PrefixPdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof IPv4PrefixAnnouncePdu) {
                    IPv4PrefixAnnouncePdu iPv4PrefixAnnouncePdu = (IPv4PrefixAnnouncePdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(iPv4PrefixAnnouncePdu).should(this.$outer.equal(ipv4PrefixPdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle asn: 0, see GRE-314 bugreport", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                IPv4PrefixAnnouncePdu ipv4PrefixPdu = new IPv4PrefixAnnouncePdu(Ipv4Address.parse((String)"10.0.0.0"), 8, 10, Asn.parse((String)"0"));
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 4, 0, 0, 0, 0, 0, 20, 1, 8, 10, 0, 10, 0, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)ipv4PrefixPdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof IPv4PrefixAnnouncePdu) {
                    IPv4PrefixAnnouncePdu iPv4PrefixAnnouncePdu = (IPv4PrefixAnnouncePdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(iPv4PrefixAnnouncePdu).should(this.$outer.equal(ipv4PrefixPdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert ipv6 prefix announce pdu to byte array and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                IPv6PrefixAnnouncePdu ipv6PrefixPdu = new IPv6PrefixAnnouncePdu(Ipv6Address.parse((String)"fc00::"), 7, 10, Asn.parse((String)"65535"));
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 6, 0, 0, 0, 0, 0, 32, 1, 7, 10, 0, (byte)252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (byte)255, (byte)255}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)ipv6PrefixPdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof IPv6PrefixAnnouncePdu) {
                    IPv6PrefixAnnouncePdu iPv6PrefixAnnouncePdu = (IPv6PrefixAnnouncePdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(iPv6PrefixAnnouncePdu).should(this.$outer.equal(ipv6PrefixPdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert end of data pdu to byte array and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                EndOfDataPdu endOfDataPdu = new EndOfDataPdu(PduTest$.MODULE$.MAX_HEADER_SHORT_VALUE(), EndOfDataPdu$.MODULE$.MAX_SERIAL());
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 7, (byte)255, (byte)255, 0, 0, 0, 12, (byte)255, (byte)255, (byte)255, (byte)255}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)endOfDataPdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof EndOfDataPdu) {
                    EndOfDataPdu endOfDataPdu2 = (EndOfDataPdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(endOfDataPdu2).should(this.$outer.equal(endOfDataPdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert cache reset pdu to byte array and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PduTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Right right;
                Pdu decodedPdu;
                CacheResetPdu cacheResetPdu = new CacheResetPdu();
                byte[] expectedBytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 8, 0, 0, 0, 0, 0, 8}), ClassTag$.MODULE$.Byte());
                byte[] bytes = Pdus$.MODULE$.encode((Pdu)cacheResetPdu);
                this.$outer.convertToArrayShouldWrapper(bytes).should(this.$outer.equal(expectedBytes));
                Either either = Pdus$.MODULE$.fromByteArray((ChannelBuffer)new BigEndianHeapChannelBuffer(bytes));
                if (either instanceof Right && (decodedPdu = (Pdu)(right = (Right)either).b()) instanceof CacheResetPdu) {
                    CacheResetPdu cacheResetPdu2 = (CacheResetPdu)decodedPdu;
                    this.$outer.convertHasIntParameterlessLengthMethodToLengthShouldWrapper(cacheResetPdu2).should(this.$outer.equal(cacheResetPdu));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw this.$outer.fail("Got back a wrong response");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

