/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.UnknownCertificateRepositoryObject;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.stubbing.Answer;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u001b\t!b+\u00197jI\u0006$X\rZ(cU\u0016\u001cGo\u001d+fgRT!a\u0001\u0003\u0002\r5|G-\u001a7t\u0015\t)a!A\u0005wC2LG-\u0019;pe*\u0011q\u0001C\u0001\u0005eB\\\u0017N\u0003\u0002\n\u0015\u0005!!/\u001b9f\u0015\u0005Y\u0011a\u00018fi\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\bgV\u0004\bo\u001c:u\u0013\t\u0019\u0002CA\tWC2LG-\u0019;peR+7\u000f^\"bg\u0016\u0004\"!\u0006\u000f\u000e\u0003YQ!a\u0006\r\u0002\t5|7m\u001b\u0006\u00033i\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003m\t1a\u001c:h\u0013\tibC\u0001\u0007N_\u000e\\\u0017\u000e^8Tk\u001e\f'\u000fC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!)A\u0005\u0001C\u0001K\u00051R.Y6f\u0019&\u001cHo\u00144WC2LGm\u00142kK\u000e$8\u000f\u0006\u0002'gA\u0019qE\f\u0019\u000e\u0003!R!!\u000b\u0016\u0002\u0013%lW.\u001e;bE2,'BA\u0016-\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\u000b\u0002\u000b\u0013:$W\r_3e'\u0016\f\bC\u0001\u00122\u0013\t\u0011$AA\u0006WC2LGm\u00142kK\u000e$\b\"\u0002\u001b$\u0001\u0004)\u0014A\u00028v[\n,'\u000f\u0005\u00027o5\tA&\u0003\u00029Y\t\u0019\u0011J\u001c;\t\u000bi\u0002A\u0011A\u001e\u000215\f7.\u001a'jgR|e-\u00138wC2LGm\u00142kK\u000e$8\u000f\u0006\u0002=\u0001B\u0019qEL\u001f\u0011\u0005\tr\u0014BA \u0003\u00055IeN^1mS\u0012|%M[3di\")A'\u000fa\u0001k!\"\u0001A\u0011&L!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0004sk:tWM\u001d\u0006\u0003\u000fj\tQA[;oSRL!!\u0013#\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\nA\n\u0005\u0002N\u001f6\taJ\u0003\u0002H1%\u0011\u0001K\u0014\u0002\f\u0015Vs\u0017\u000e\u001e*v]:,'\u000f")
public class ValidatedObjectsTest
extends ValidatorTestCase
implements MockitoSugar {
    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public IndexedSeq<ValidObject> makeListOfValidObjects(int number) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), number + 1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidObject apply(int nr) {
                return new ValidObject(URI.create(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rsync://some.host/repo/valid-", ".unk"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nr)}))), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationCheck[]{new ValidationCheck(ValidationStatus.PASSED, "validator.read.file", new String[0])})), (CertificateRepositoryObject)new UnknownCertificateRepositoryObject(new byte[0]));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public IndexedSeq<InvalidObject> makeListOfInvalidObjects(int number) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), number + 1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InvalidObject apply(int nr) {
                return new InvalidObject(URI.create(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rsync://some.host/repo/invalid-", ".unk"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nr)}))), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationCheck[]{new ValidationCheck(ValidationStatus.ERROR, "validator.read.file", new String[0])})));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public ValidatedObjectsTest() {
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.test("Should add repository error when at least one error was found and there is a 10% or more drop in valid object count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq<ValidObject> oldValidatedObjects = this.$outer.makeListOfValidObjects(10);
                IndexedSeq newObjects = (IndexedSeq)this.$outer.makeListOfValidObjects(8).$plus$plus(this.$outer.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom());
                URI taUri = URI.create("rsync://some/ta.cer");
                Seq objectsWithRepositoryHealth = ValidatedObjects$.MODULE$.getValidatedObjectsWithRepositoryHealth(taUri, oldValidatedObjects, (Seq)newObjects);
                this.$outer.assert(objectsWithRepositoryHealth.contains((Object)new InvalidObject(taUri, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationCheck[]{new ValidationCheck(ValidationStatus.ERROR, "validator.repository.object.drop", new String[]{"10", "9"})})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should NOT add repository error when at least one error was found and there is a less than 10% drop in valid object count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq<ValidObject> oldValidatedObjects = this.$outer.makeListOfValidObjects(10);
                IndexedSeq newObjects = (IndexedSeq)this.$outer.makeListOfValidObjects(9).$plus$plus(this.$outer.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom());
                URI taUri = URI.create("rsync://some/ta.cer");
                Seq objectsWithRepositoryHealth = ValidatedObjects$.MODULE$.getValidatedObjectsWithRepositoryHealth(taUri, oldValidatedObjects, (Seq)newObjects);
                this.$outer.assert(!objectsWithRepositoryHealth.contains((Object)new InvalidObject(taUri, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationCheck[]{new ValidationCheck(ValidationStatus.ERROR, "validator.repository.object.drop", new String[]{"10", "10"})})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should NOT add repository error there is a drop in object count, but no errors were found", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq<ValidObject> oldValidatedObjects = this.$outer.makeListOfValidObjects(10);
                IndexedSeq<ValidObject> newObjects = this.$outer.makeListOfValidObjects(5);
                URI taUri = URI.create("rsync://some/ta.cer");
                Seq objectsWithRepositoryHealth = ValidatedObjects$.MODULE$.getValidatedObjectsWithRepositoryHealth(taUri, oldValidatedObjects, newObjects);
                this.$outer.assert(!objectsWithRepositoryHealth.contains((Object)new InvalidObject(taUri, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationCheck[]{new ValidationCheck(ValidationStatus.ERROR, "validator.repository.object.drop", new String[]{"10", "5"})})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

