/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.fetchers;

import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsBuilder;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.fetchers.ConsistentObjectFetcher;
import net.ripe.rpki.validator.fetchers.RsyncRpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.TestRemoteObjectFetcher;
import net.ripe.rpki.validator.models.StoredRepositoryObject;
import net.ripe.rpki.validator.models.StoredRepositoryObject$;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.RepositoryObjectStore;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.stubbing.Answer;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u00015\u00111dQ8og&\u001cH/\u001a8u\u001f\nTWm\u0019;GKR\u001c\u0007.\u001a:UKN$(BA\u0002\u0005\u0003!1W\r^2iKJ\u001c(BA\u0003\u0007\u0003%1\u0018\r\\5eCR|'O\u0003\u0002\b\u0011\u0005!!\u000f]6j\u0015\tI!\"\u0001\u0003sSB,'\"A\u0006\u0002\u00079,Go\u0001\u0001\u0014\t\u0001qA\u0003\b\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqa];qa>\u0014H/\u0003\u0002\u0014!\t\tb+\u00197jI\u0006$xN\u001d+fgR\u001c\u0015m]3\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012!C:dC2\fG/Z:u\u0015\u0005I\u0012aA8sO&\u00111D\u0006\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s!\ti\u0002%D\u0001\u001f\u0015\tyb#\u0001\u0003n_\u000e\\\u0017BA\u0011\u001f\u00051iunY6ji>\u001cVoZ1s\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t!\u0001C\u0004)\u0001\t\u0007I\u0011A\u0015\u0002%%\u001c8/^5oO\u000e+'\u000f^5gS\u000e\fG/Z\u000b\u0002UA\u00111FM\u0007\u0002Y)\u0011QFL\u0001\tqV\u0002\u0014hY3si*\u0011q\u0006M\u0001\u0007GJL\b\u000f^8\u000b\u0005E2\u0011aB2p[6|gn]\u0005\u0003g1\u0012q\u0003W\u001b1sI+7o\\;sG\u0016\u001cUM\u001d;jM&\u001c\u0017\r^3\t\rU\u0002\u0001\u0015!\u0003+\u0003MI7o];j]\u001e\u001cUM\u001d;jM&\u001c\u0017\r^3!\u0011\u001d9\u0004A1A\u0005\u0002a\nqAY1tKV\u0013\u0018.F\u0001:!\tQd(D\u0001<\u0015\tYAHC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}Z$aA+S\u0013\"1\u0011\t\u0001Q\u0001\ne\n\u0001BY1tKV\u0013\u0018\u000e\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u0001E\u0003U\u0011\u0017m]3WC2LG-\u0019;j_:\u001cuN\u001c;fqR,\u0012!\u0012\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000b\u0001c\u001c2kK\u000e$h/\u00197jI\u0006$xN]:\u000b\u0005)\u0003\u0014A\u0003<bY&$\u0017\r^5p]&\u0011Aj\u0012\u0002-\u0007\u0016\u0014H/\u001b4jG\u0006$XMU3q_NLGo\u001c:z\u001f\nTWm\u0019;WC2LG-\u0019;j_:\u001cuN\u001c;fqRDaA\u0014\u0001!\u0002\u0013)\u0015A\u00062bg\u00164\u0016\r\\5eCRLwN\\\"p]R,\u0007\u0010\u001e\u0011\t\u000bA\u0003A\u0011A)\u0002\u001fI,7o\u001c7wK\u001aKG.\u001a(b[\u0016$\"A\u0015/\u0011\u0005MKfB\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+\u0016A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001W+\t\u000bu{\u0005\u0019A\u001d\u0002\u0007U\u0014\u0018\u000eC\u0004`\u0001\t\u0007I\u0011\u00011\u0002\u0007\r\u0014H.F\u0001b!\t\u0011G-D\u0001d\u0015\tyf&\u0003\u0002fG\n9\u0001,\u000e\u0019:\u0007Jd\u0007BB4\u0001A\u0003%\u0011-\u0001\u0003de2\u0004\u0003bB5\u0001\u0005\u0004%\t\u0001O\u0001\u0007GJdWK]5\t\r-\u0004\u0001\u0015!\u0003:\u0003\u001d\u0019'\u000f\\+sS\u0002Bq!\u001c\u0001C\u0002\u0013\u0005a.A\u0006de24\u0015\u000e\\3OC6,W#\u0001*\t\rA\u0004\u0001\u0015!\u0003S\u00031\u0019'\u000f\u001c$jY\u0016t\u0015-\\3!\u0011\u001d\u0011\bA1A\u0005\u0002M\f1A]8b+\u0005!\bCA;z\u001b\u00051(B\u0001:x\u0015\tAh&A\u0002d[NL!A\u001f<\u0003\rI{\u0017mQ7t\u0011\u0019a\b\u0001)A\u0005i\u0006!!o\\1!\u0011\u001dq\bA1A\u0005\u0002}\f1B]8b\r&dWMT1nKV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u001f\u0002\t1\fgnZ\u0005\u00045\u0006\u0015\u0001\u0002CA\u0007\u0001\u0001\u0006I!!\u0001\u0002\u0019I|\u0017MR5mK:\u000bW.\u001a\u0011\t\u0011\u0005E\u0001A1A\u0005\u0002a\naA]8b+JL\u0007bBA\u000b\u0001\u0001\u0006I!O\u0001\be>\fWK]5!\u0011%\tI\u0002\u0001b\u0001\n\u0003\tY\"\u0001\u0006nMR\u0014U/\u001b7eKJ,\"!!\b\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\tx\u0003!i\u0017M\\5gKN$\u0018\u0002BA\u0014\u0003C\u0011!#T1oS\u001a,7\u000f^\"ng\n+\u0018\u000e\u001c3fe\"A\u00111\u0006\u0001!\u0002\u0013\ti\"A\u0006nMR\u0014U/\u001b7eKJ\u0004\u0003\"CA\u0018\u0001\t\u0007I\u0011AA\u0019\u0003\rig\r^\u000b\u0003\u0003g\u0001B!a\b\u00026%!\u0011qGA\u0011\u0005-i\u0015M\\5gKN$8)\\:\t\u0011\u0005m\u0002\u0001)A\u0005\u0003g\tA!\u001c4uA!A\u0011q\b\u0001C\u0002\u0013\u0005\u0001(\u0001\u0004nMR,&/\u001b\u0005\b\u0003\u0007\u0002\u0001\u0015!\u0003:\u0003\u001dig\r^+sS\u0002B\u0001\"a\u0012\u0001\u0005\u0004%\tA\\\u0001\f[\u001a$h)\u001b7f\u001d\u0006lW\rC\u0004\u0002L\u0001\u0001\u000b\u0011\u0002*\u0002\u001954GOR5mK:\u000bW.\u001a\u0011\t\u0013\u0005=\u0003A1A\u0005\u0002\u0005E\u0013!B:u_J,WCAA*!\u0011\t)&!\u0017\u000e\u0005\u0005]#bAA(\t%!\u00111LA,\u0005U\u0011V\r]8tSR|'/_(cU\u0016\u001cGo\u0015;pe\u0016D\u0001\"a\u0018\u0001A\u0003%\u00111K\u0001\u0007gR|'/\u001a\u0011)\u000f\u0001\t\u0019'a\u001d\u0002vA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014A\u0002:v]:,'OC\u0002\u0002na\tQA[;oSRLA!!\u001d\u0002h\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA<!\u0011\tI(! \u000e\u0005\u0005m$bAA7-%!\u0011qPA>\u0005-QUK\\5u%Vtg.\u001a:")
public class ConsistentObjectFetcherTest
extends ValidatorTestCase
implements BeforeAndAfter,
MockitoSugar {
    private final X509ResourceCertificate issuingCertificate;
    private final URI baseUri;
    private final CertificateRepositoryObjectValidationContext baseValidationContext;
    private final X509Crl crl;
    private final URI crlUri;
    private final String crlFileName;
    private final RoaCms roa;
    private final String roaFileName;
    private final URI roaUri;
    private final ManifestCmsBuilder mftBuilder;
    private final ManifestCms mft;
    private final URI mftUri;
    private final String mftFileName;
    private final RepositoryObjectStore store;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuite.class.runTest((FunSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuite.class.run((FunSuite)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    @Override
    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    @Override
    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public X509ResourceCertificate issuingCertificate() {
        return this.issuingCertificate;
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public CertificateRepositoryObjectValidationContext baseValidationContext() {
        return this.baseValidationContext;
    }

    public String resolveFileName(URI uri) {
        return new File(uri.getPath()).getName();
    }

    public X509Crl crl() {
        return this.crl;
    }

    public URI crlUri() {
        return this.crlUri;
    }

    public String crlFileName() {
        return this.crlFileName;
    }

    public RoaCms roa() {
        return this.roa;
    }

    public String roaFileName() {
        return this.roaFileName;
    }

    public URI roaUri() {
        return this.roaUri;
    }

    public ManifestCmsBuilder mftBuilder() {
        return this.mftBuilder;
    }

    public ManifestCms mft() {
        return this.mft;
    }

    public URI mftUri() {
        return this.mftUri;
    }

    public String mftFileName() {
        return this.mftFileName;
    }

    public RepositoryObjectStore store() {
        return this.store;
    }

    public ConsistentObjectFetcherTest() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.issuingCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        this.baseUri = this.issuingCertificate().getRepositoryUri();
        this.baseValidationContext = new CertificateRepositoryObjectValidationContext(this.baseUri(), this.issuingCertificate());
        this.crl = X509CrlTest.createCrl();
        this.crlUri = X509ResourceCertificateTest.TEST_TA_CRL;
        this.crlFileName = this.resolveFileName(this.crlUri());
        this.roa = RoaCmsTest.getRoaCms();
        this.roaFileName = "roa.roa";
        this.roaUri = this.baseUri().resolve(this.roaFileName());
        this.mftBuilder = ManifestCmsTest.getRootManifestBuilder();
        this.mftBuilder().addFile(this.crlFileName(), this.crl().getEncoded());
        this.mftBuilder().addFile(this.roaFileName(), this.roa().getEncoded());
        this.mft = this.mftBuilder().build(ManifestCmsTest.MANIFEST_KEY_PAIR.getPrivate());
        this.mftUri = this.issuingCertificate().getManifestUri();
        this.mftFileName = this.resolveFileName(this.mftUri());
        this.store = new RepositoryObjectStore((DataSource)DataSources$.MODULE$.InMemoryDataSource());
        this.before((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsistentObjectFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().clear();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should store consistent set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsistentObjectFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map entries = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.mftUri()), (Object)this.$outer.mft()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.crlUri()), (Object)this.$outer.crl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.roaUri()), (Object)this.$outer.roa())}));
                TestRemoteObjectFetcher rsyncFetcher = new TestRemoteObjectFetcher((Map<URI, CertificateRepositoryObject>)entries);
                ConsistentObjectFetcher subject = new ConsistentObjectFetcher((RsyncRpkiRepositoryObjectFetcher)rsyncFetcher, this.$outer.store());
                ValidationResult validationResult = ValidationResult.withLocation((URI)this.$outer.mftUri());
                this.$outer.convertHasIntSizeMethodToSizeShouldWrapper(subject.getManifest(this.$outer.mftUri(), this.$outer.baseValidationContext(), validationResult)).should(this.$outer.equal(this.$outer.mft()));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)validationResult.hasFailures())).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getLatestByUrl(this.$outer.mftUri())).should(this.$outer.equal(new Some((Object)StoredRepositoryObject$.MODULE$.apply(this.$outer.mftUri(), this.$outer.mft().getEncoded()))));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getLatestByUrl(this.$outer.crlUri())).should(this.$outer.equal(new Some((Object)StoredRepositoryObject$.MODULE$.apply(this.$outer.crlUri(), this.$outer.crl().getEncoded()))));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getLatestByUrl(this.$outer.roaUri())).should(this.$outer.equal(new Some((Object)StoredRepositoryObject$.MODULE$.apply(this.$outer.roaUri(), this.$outer.roa().getEncoded()))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should fall back to old mft if new content is missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsistentObjectFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().put((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StoredRepositoryObject[]{StoredRepositoryObject$.MODULE$.apply(this.$outer.mftUri(), this.$outer.mft().getEncoded()), StoredRepositoryObject$.MODULE$.apply(this.$outer.crlUri(), this.$outer.crl().getEncoded()), StoredRepositoryObject$.MODULE$.apply(this.$outer.roaUri(), this.$outer.roa().getEncoded())})));
                ManifestCmsBuilder mftBuilder = ManifestCmsTest.getRootManifestBuilder();
                mftBuilder.addFile(this.$outer.crlFileName(), this.$outer.crl().getEncoded());
                ManifestCms mft2 = mftBuilder.build(ManifestCmsTest.MANIFEST_KEY_PAIR.getPrivate());
                Map entries = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.mftUri()), (Object)mft2)}));
                TestRemoteObjectFetcher rsyncFetcher = new TestRemoteObjectFetcher((Map<URI, CertificateRepositoryObject>)entries);
                ConsistentObjectFetcher subject = new ConsistentObjectFetcher((RsyncRpkiRepositoryObjectFetcher)rsyncFetcher, this.$outer.store());
                ValidationResult validationResult = ValidationResult.withLocation((URI)this.$outer.mftUri());
                this.$outer.convertHasIntSizeMethodToSizeShouldWrapper(subject.getManifest(this.$outer.mftUri(), this.$outer.baseValidationContext(), validationResult)).should(this.$outer.equal(this.$outer.mft()));
                this.$outer.convertToJavaListShouldWrapper(validationResult.getWarnings()).should(this.$outer.have()).size(1);
                ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getWarnings()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ValidationCheck x$1) {
                        return x$1.getKey();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).contains((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validator.repository.incomplete"})));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getLatestByUrl(this.$outer.mftUri())).should(this.$outer.equal(new Some((Object)StoredRepositoryObject$.MODULE$.apply(this.$outer.mftUri(), this.$outer.mft().getEncoded()))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should fall back to old mft if new content has file not matching hash", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsistentObjectFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().put((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StoredRepositoryObject[]{StoredRepositoryObject$.MODULE$.apply(this.$outer.mftUri(), this.$outer.mft().getEncoded()), StoredRepositoryObject$.MODULE$.apply(this.$outer.crlUri(), this.$outer.crl().getEncoded()), StoredRepositoryObject$.MODULE$.apply(this.$outer.roaUri(), this.$outer.roa().getEncoded())})));
                ManifestCmsBuilder mftWrongHashBuilder = ManifestCmsTest.getRootManifestBuilder();
                mftWrongHashBuilder.addFile(this.$outer.crlFileName(), this.$outer.crl().getEncoded());
                mftWrongHashBuilder.addFile(this.$outer.roaFileName(), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 2, 3}), ClassTag$.MODULE$.Byte()));
                ManifestCms mftWrongHash = mftWrongHashBuilder.build(ManifestCmsTest.MANIFEST_KEY_PAIR.getPrivate());
                Map entries = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.mftUri()), (Object)mftWrongHash), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.crlUri()), (Object)this.$outer.crl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.roaUri()), (Object)this.$outer.roa())}));
                TestRemoteObjectFetcher rsyncFetcher = new TestRemoteObjectFetcher((Map<URI, CertificateRepositoryObject>)entries);
                ConsistentObjectFetcher subject = new ConsistentObjectFetcher((RsyncRpkiRepositoryObjectFetcher)rsyncFetcher, this.$outer.store());
                ValidationResult validationResult = ValidationResult.withLocation((URI)this.$outer.mftUri());
                this.$outer.convertHasIntSizeMethodToSizeShouldWrapper(subject.getManifest(this.$outer.mftUri(), this.$outer.baseValidationContext(), validationResult)).should(this.$outer.equal(this.$outer.mft()));
                this.$outer.convertToJavaListShouldWrapper(validationResult.getWarnings()).should(this.$outer.have()).size(1);
                ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getWarnings()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ValidationCheck x$2) {
                        return x$2.getKey();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).contains((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validator.repository.incomplete"})));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getLatestByUrl(this.$outer.mftUri())).should(this.$outer.equal(new Some((Object)StoredRepositoryObject$.MODULE$.apply(this.$outer.mftUri(), this.$outer.mft().getEncoded()))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should store new mft and objects despite inconsistencies if cache is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsistentObjectFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getLatestByUrl(this.$outer.mftUri())).should(this.$outer.equal(None$.MODULE$));
                ManifestCmsBuilder mftWrongHashBuilder = ManifestCmsTest.getRootManifestBuilder();
                mftWrongHashBuilder.addFile(this.$outer.crlFileName(), this.$outer.crl().getEncoded());
                mftWrongHashBuilder.addFile(this.$outer.roaFileName(), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 2, 3}), ClassTag$.MODULE$.Byte()));
                ManifestCms mftWrongHash = mftWrongHashBuilder.build(ManifestCmsTest.MANIFEST_KEY_PAIR.getPrivate());
                Map entries = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.mftUri()), (Object)mftWrongHash), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.crlUri()), (Object)this.$outer.crl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.roaUri()), (Object)this.$outer.roa())}));
                TestRemoteObjectFetcher rsyncFetcher = new TestRemoteObjectFetcher((Map<URI, CertificateRepositoryObject>)entries);
                ConsistentObjectFetcher subject = new ConsistentObjectFetcher((RsyncRpkiRepositoryObjectFetcher)rsyncFetcher, this.$outer.store());
                ValidationResult validationResult = ValidationResult.withLocation((URI)this.$outer.mftUri());
                this.$outer.convertHasIntSizeMethodToSizeShouldWrapper(subject.getManifest(this.$outer.mftUri(), this.$outer.baseValidationContext(), validationResult)).should(this.$outer.equal(mftWrongHash));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.store().getLatestByUrl(this.$outer.mftUri())).should(this.$outer.equal(new Some((Object)StoredRepositoryObject$.MODULE$.apply(this.$outer.mftUri(), mftWrongHash.getEncoded()))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should get objects by hash", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsistentObjectFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().put((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StoredRepositoryObject[]{StoredRepositoryObject$.MODULE$.apply(this.$outer.mftUri(), this.$outer.mft().getEncoded()), StoredRepositoryObject$.MODULE$.apply(this.$outer.crlUri(), this.$outer.crl().getEncoded()), StoredRepositoryObject$.MODULE$.apply(this.$outer.roaUri(), this.$outer.roa().getEncoded())})));
                TestRemoteObjectFetcher rsyncFetcher = new TestRemoteObjectFetcher((Map<URI, CertificateRepositoryObject>)Predef$.MODULE$.Map().empty());
                ConsistentObjectFetcher subject = new ConsistentObjectFetcher((RsyncRpkiRepositoryObjectFetcher)rsyncFetcher, this.$outer.store());
                URI nonExistentUri = URI.create("rsync://some.host/doesnotexist.roa");
                ValidationResult validationResult = ValidationResult.withLocation((URI)nonExistentUri);
                this.$outer.convertToAnyRefShouldWrapper(subject.getObject(nonExistentUri, this.$outer.baseValidationContext(), (Specification)this.$outer.mft().getFileContentSpecification(this.$outer.roaFileName()), validationResult)).should(this.$outer.equal(this.$outer.roa()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should get crl for mft from cache", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsistentObjectFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().put((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StoredRepositoryObject[]{StoredRepositoryObject$.MODULE$.apply(this.$outer.mftUri(), this.$outer.mft().getEncoded()), StoredRepositoryObject$.MODULE$.apply(this.$outer.crlUri(), this.$outer.crl().getEncoded()), StoredRepositoryObject$.MODULE$.apply(this.$outer.roaUri(), this.$outer.roa().getEncoded())})));
                X509Crl crl2 = X509CrlTest.getCrlBuilder().withNumber(BigInteger.valueOf(11L)).build(KeyPairFactoryTest.TEST_KEY_PAIR.getPrivate());
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.crl()).should(this.$outer.not()).equal((Object)crl2);
                ManifestCmsBuilder mft2Builder = ManifestCmsTest.getRootManifestBuilder();
                mft2Builder.addFile(this.$outer.crlFileName(), crl2.getEncoded());
                mft2Builder.addFile(this.$outer.roaFileName(), this.$outer.roa().getEncoded());
                ManifestCms mft2 = mft2Builder.build(ManifestCmsTest.MANIFEST_KEY_PAIR.getPrivate());
                Map entries = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.mftUri()), (Object)mft2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.crlUri()), (Object)crl2)}));
                TestRemoteObjectFetcher rsyncFetcher = new TestRemoteObjectFetcher((Map<URI, CertificateRepositoryObject>)entries);
                ConsistentObjectFetcher subject = new ConsistentObjectFetcher((RsyncRpkiRepositoryObjectFetcher)rsyncFetcher, this.$outer.store());
                ValidationResult validationResult = ValidationResult.withLocation((URI)this.$outer.mftUri());
                this.$outer.convertHasIntSizeMethodToSizeShouldWrapper(subject.getManifest(this.$outer.mftUri(), this.$outer.baseValidationContext(), validationResult)).should(this.$outer.equal(this.$outer.mft()));
                this.$outer.convertToAnyRefShouldWrapper(subject.getCrl(this.$outer.crlUri(), this.$outer.baseValidationContext(), validationResult)).should(this.$outer.equal(this.$outer.crl()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

