/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import java.io.File;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.config.PersistentData;
import net.ripe.rpki.validator.config.PersistentData$;
import net.ripe.rpki.validator.config.PersistentDataSerialiser;
import net.ripe.rpki.validator.config.PersistentDataSerialiser$;
import net.ripe.rpki.validator.lib.UserPreferences;
import net.ripe.rpki.validator.lib.UserPreferences$;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.Filters$;
import net.ripe.rpki.validator.models.IgnoreFilter;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.RtrPrefix$;
import net.ripe.rpki.validator.models.TrustAnchorData;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.apache.commons.io.FileUtils;
import org.junit.runner.RunWith;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u001b\t\u0011\u0002+\u001a:tSN$XM\u001c;ECR\fG+Z:u\u0015\t\u0019A!\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u000b\u0019\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u0005\u001dA\u0011\u0001\u0002:qW&T!!\u0003\u0006\u0002\tIL\u0007/\u001a\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqa];qa>\u0014H/\u0003\u0002\u0014!\t\tb+\u00197jI\u0006$xN\u001d+fgR\u001c\u0015m]3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%\taG\u0001\u000bg\u0016\u0014\u0018.\u00197jg\u0016\u0014X#\u0001\u000f\u0011\u0005ai\u0012B\u0001\u0010\u0003\u0005a\u0001VM]:jgR,g\u000e\u001e#bi\u0006\u001cVM]5bY&\u001cXM\u001d\u0005\u0007A\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u0017M,'/[1mSN,'\u000f\t\u0005\bE\u0001\u0011\r\u0011\"\u0001$\u0003)!\u0017\r^1`K6\u0004H/_\u000b\u0002IA\u0011\u0001$J\u0005\u0003M\t\u0011a\u0002U3sg&\u001cH/\u001a8u\t\u0006$\u0018\r\u0003\u0004)\u0001\u0001\u0006I\u0001J\u0001\fI\u0006$\u0018mX3naRL\b\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\u0002\u0015)\u001cxN\\0f[B$\u00180F\u0001-!\ti3G\u0004\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011t&\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a0\u0011\u00199\u0004\u0001)A\u0005Y\u0005Y!n]8o?\u0016l\u0007\u000f^=!\u0011\u001dI\u0004A1A\u0005\u0002\r\n\u0011\u0002Z1uC~\u001bx.\\3\t\rm\u0002\u0001\u0015!\u0003%\u0003)!\u0017\r^1`g>lW\r\t\u0005\b{\u0001\u0011\r\u0011\"\u0001,\u0003%Q7o\u001c8`g>lW\r\u0003\u0004@\u0001\u0001\u0006I\u0001L\u0001\u000bUN|gnX:p[\u0016\u0004\u0003\u0006\u0002\u0001B\u00172\u0003\"AQ%\u000e\u0003\rS!\u0001R#\u0002\rI,hN\\3s\u0015\t1u)A\u0003kk:LGOC\u0001I\u0003\ry'oZ\u0005\u0003\u0015\u000e\u0013qAU;o/&$\b.A\u0003wC2,XmI\u0001N!\tq%+D\u0001P\u0015\t1\u0005K\u0003\u0002R\u000f\u0006I1oY1mCR,7\u000f^\u0005\u0003'>\u00131BS+oSR\u0014VO\u001c8fe\u0002")
public class PersistentDataTest
extends ValidatorTestCase {
    private final PersistentDataSerialiser serialiser = new PersistentDataSerialiser();
    private final PersistentData data_empty = new PersistentData(PersistentData$.MODULE$.apply$default$1(), PersistentData$.MODULE$.apply$default$2(), PersistentData$.MODULE$.apply$default$3(), PersistentData$.MODULE$.apply$default$4(), PersistentData$.MODULE$.apply$default$5());
    private final String json_empty;
    private final PersistentData data_some = new PersistentData(0, new Filters((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IgnoreFilter[]{new IgnoreFilter(IpRange.parse((String)"192.168.0.0/16"))}))), new Whitelist((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{new RtrPrefix(Asn.parse((String)"AS65530"), IpRange.parse((String)"10.0.0.0/8"), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4())}))), PersistentData$.MODULE$.apply$default$4(), PersistentData$.MODULE$.apply$default$5());
    private final String json_some;

    public PersistentDataSerialiser serialiser() {
        return this.serialiser;
    }

    public PersistentData data_empty() {
        return this.data_empty;
    }

    public String json_empty() {
        return this.json_empty;
    }

    public PersistentData data_some() {
        return this.data_some;
    }

    public String json_some() {
        return this.json_some;
    }

    public PersistentDataTest() {
        this.json_empty = "{\"schemaVersion\":0,\"filters\":{\"entries\":[]},\"whitelist\":{\"entries\":[]},\"userPreferences\":{\"updateAlertActive\":true,\"maxStaleDays\":0},\"trustAnchorData\":{}}";
        this.json_some = "{\"schemaVersion\":0,\"filters\":{\"entries\":[{\"prefix\":\"192.168.0.0/16\"}]},\"whitelist\":{\"entries\":[{\"asn\":65530,\"prefix\":\"10.0.0.0/8\"}]},\"userPreferences\":{\"updateAlertActive\":true,\"maxStaleDays\":0},\"trustAnchorData\":{}}";
        this.test("serialise empty Whitelist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PersistentDataTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.serialiser().serialise(this.$outer.data_empty())).should(this.$outer.equal(this.$outer.json_empty()));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.serialiser().deserialise(this.$outer.json_empty())).should(this.$outer.equal(this.$outer.data_empty()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("serialise non-empty Whitelist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PersistentDataTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.serialiser().serialise(this.$outer.data_some())).should(this.$outer.equal(this.$outer.json_some()));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.serialiser().deserialise(this.$outer.json_some())).should(this.$outer.equal(this.$outer.data_some()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("serialise Whitelist with maxPrefixLength", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PersistentDataTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PersistentData data = new PersistentData(0, new Filters(Filters$.MODULE$.apply$default$1()), new Whitelist((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{(RtrPrefix)RtrPrefix$.MODULE$.validate(Asn.parse((String)"AS65530"), IpRange.parse((String)"10.0.0.0/8"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)16))).toOption().get()}))), PersistentData$.MODULE$.apply$default$4(), PersistentData$.MODULE$.apply$default$5());
                String json = "{\"schemaVersion\":0,\"filters\":{\"entries\":[]},\"whitelist\":{\"entries\":[{\"asn\":65530,\"prefix\":\"10.0.0.0/8\",\"maxPrefixLength\":16}]},\"userPreferences\":{\"updateAlertActive\":true,\"maxStaleDays\":0},\"trustAnchorData\":{}}";
                this.$outer.convertToStringShouldWrapper(this.$outer.serialiser().serialise(data)).should(this.$outer.equal(json));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.serialiser().deserialise(json)).should(this.$outer.equal(data));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should be backwards compatible with json string without software update preferences or disabled trust anchors list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PersistentDataTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String json = "{\"schemaVersion\":0}";
                PersistentData data = this.$outer.serialiser().deserialise(json);
                this.$outer.convertToAnyRefShouldWrapper(data.userPreferences()).should(this.$outer.equal(new UserPreferences(UserPreferences$.MODULE$.apply$default$1(), UserPreferences$.MODULE$.apply$default$2())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should be backwards compatible with json string without software maxStaleDays in update preferences", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PersistentDataTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String json = "{\"schemaVersion\":0,\"userPreferences\":{\"updateAlertActive\":false}}";
                PersistentData data = this.$outer.serialiser().deserialise(json);
                this.$outer.convertToAnyRefShouldWrapper(data.userPreferences()).should(this.$outer.equal(new UserPreferences(false, UserPreferences$.MODULE$.apply$default$2())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should be backwards compatible with json string with feedback enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PersistentDataTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String json = "{\"schemaVersion\":0,\"userPreferences\":{\"updateAlertActive\":false, \"enableFeedback\":true}}";
                PersistentData data = this.$outer.serialiser().deserialise(json);
                this.$outer.convertToAnyRefShouldWrapper(data.userPreferences()).should(this.$outer.equal(new UserPreferences(false, UserPreferences$.MODULE$.apply$default$2())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("serialise Whitelist, maxPrefixLength, preferences and disabled trust anchors list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PersistentDataTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PersistentData data = new PersistentData(0, new Filters(Filters$.MODULE$.apply$default$1()), new Whitelist((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{(RtrPrefix)RtrPrefix$.MODULE$.validate(Asn.parse((String)"AS65530"), IpRange.parse((String)"10.0.0.0/8"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)16))).toOption().get()}))), new UserPreferences(false, 5), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"AfriNIC RPKI Root"), (Object)new TrustAnchorData(true))})));
                String json = "{\"schemaVersion\":0,\"filters\":{\"entries\":[]},\"whitelist\":{\"entries\":[{\"asn\":65530,\"prefix\":\"10.0.0.0/8\",\"maxPrefixLength\":16}]},\"userPreferences\":{\"updateAlertActive\":false,\"maxStaleDays\":5},\"trustAnchorData\":{\"AfriNIC RPKI Root\":{\"enabled\":true}}}";
                this.$outer.convertToStringShouldWrapper(this.$outer.serialiser().serialise(data)).should(this.$outer.equal(json));
                this.$outer.convertToAnyRefShouldWrapper(this.$outer.serialiser().deserialise(json)).should(this.$outer.equal(data));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("persist to file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PersistentDataTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File file = File.createTempFile("test-rpki", ".dat");
                file.deleteOnExit();
                file.delete();
                this.$outer.convertToAnyRefShouldWrapper(PersistentDataSerialiser$.MODULE$.read(file)).should(this.$outer.equal(None$.MODULE$));
                PersistentDataSerialiser$.MODULE$.write(this.$outer.data_empty(), file);
                this.$outer.convertToStringShouldWrapper(FileUtils.readFileToString((File)file, (String)"UTF-8")).should(this.$outer.equal(this.$outer.json_empty()));
                this.$outer.convertToAnyRefShouldWrapper(PersistentDataSerialiser$.MODULE$.read(file)).should(this.$outer.equal(new Some((Object)this.$outer.data_empty())));
                PersistentDataSerialiser$.MODULE$.write(this.$outer.data_some(), file);
                this.$outer.convertToStringShouldWrapper(FileUtils.readFileToString((File)file, (String)"UTF-8")).should(this.$outer.equal(this.$outer.json_some()));
                this.$outer.convertToAnyRefShouldWrapper(PersistentDataSerialiser$.MODULE$.read(file)).should(this.$outer.equal(new Some((Object)this.$outer.data_some())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

