/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncement;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncement$;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementValidator;
import net.ripe.rpki.validator.bgp.preview.BgpValidatedAnnouncement;
import net.ripe.rpki.validator.bgp.preview.BgpValidatedAnnouncement$;
import net.ripe.rpki.validator.models.RouteValidity$;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.RtrPrefix$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.junit.runner.RunWith;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import org.scalatest.junit.JUnitRunner;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001=\u0011ADQ4q\u0003:tw.\u001e8dK6,g\u000e\u001e,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002\u0004\t\u00059\u0001O]3wS\u0016<(BA\u0003\u0007\u0003\r\u0011w\r\u001d\u0006\u0003\u000f!\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u0005%Q\u0011\u0001\u0002:qW&T!a\u0003\u0007\u0002\tIL\u0007/\u001a\u0006\u0002\u001b\u0005\u0019a.\u001a;\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011aB:vaB|'\u000f^\u0005\u0003+I\u0011\u0011CV1mS\u0012\fGo\u001c:UKN$8)Y:f!\t9B$D\u0001\u0019\u0015\tI\"$A\u0005tG\u0006d\u0017\r^3ti*\t1$A\u0002pe\u001eL!!\b\r\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG\u000eC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!)A\u0005\u0001C\u0002K\u0005IAj\u001c8h)>\f5O\u001c\u000b\u0003M1\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\u0006\u0002\u0015%\u0004(/Z:pkJ\u001cW-\u0003\u0002,Q\t\u0019\u0011i\u001d8\t\u000b5\u001a\u0003\u0019\u0001\u0018\u0002\u0007\u0005\u001ch\u000e\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0003M_:<\u0007\"B\u001b\u0001\t\u00071\u0014aC*ue&tw\rV8Bg:$\"AJ\u001c\t\u000b5\"\u0004\u0019\u0001\u001d\u0011\u0005ebdBA\u0018;\u0013\tY\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e1\u0011\u0015\u0001\u0005\u0001b\u0001B\u0003=\u0019FO]5oOR{\u0017\n\u001d*b]\u001e,GC\u0001\"F!\t93)\u0003\u0002EQ\t9\u0011\n\u001d*b]\u001e,\u0007\"\u0002$@\u0001\u0004A\u0014A\u00029sK\u001aL\u0007\u0010C\u0003I\u0001\u0011\r\u0011*\u0001\fUkBdW\rV8COB\feN\\8v]\u000e,W.\u001a8u)\tQU\n\u0005\u0002#\u0017&\u0011AJ\u0001\u0002\u0010\u0005\u001e\u0004\u0018I\u001c8pk:\u001cW-\\3oi\")aj\u0012a\u0001\u001f\u0006\t\u0001\u0010\u0005\u00030!JC\u0014BA)1\u0005\u0019!V\u000f\u001d7feA\u0011qfU\u0005\u0003)B\u00121!\u00138u\u0011\u00151\u0006\u0001b\u0001X\u0003A!V\u000f\u001d7f)>\u0014FO\u001d)sK\u001aL\u0007\u0010\u0006\u0002Y=B\u0011\u0011\fX\u0007\u00025*\u00111LB\u0001\u0007[>$W\r\\:\n\u0005uS&!\u0003*ueB\u0013XMZ5y\u0011\u0015qU\u000b1\u0001P\u0011\u00151\u0006\u0001b\u0001a)\tA\u0016\rC\u0003O?\u0002\u0007!\rE\u00030GJC$+\u0003\u0002ea\t1A+\u001e9mKNBqA\u001a\u0001C\u0002\u0013\rq-A\u0006bGR|'oU=ti\u0016lW#\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!B1di>\u0014(\"A7\u0002\t\u0005\\7.Y\u0005\u0003_*\u00141\"Q2u_J\u001c\u0016p\u001d;f[\"1\u0011\u000f\u0001Q\u0001\n!\fA\"Y2u_J\u001c\u0016p\u001d;f[\u0002Bqa\u001d\u0001C\u0002\u0013%A/A\u0004tk\nTWm\u0019;\u0016\u0003U\u0004\"A\t<\n\u0005]\u0014!\u0001\u0007\"ha\u0006sgn\\;oG\u0016lWM\u001c;WC2LG-\u0019;pe\"1\u0011\u0010\u0001Q\u0001\nU\f\u0001b];cU\u0016\u001cG\u000f\t\u0015\u0007\u0001m\f9!!\u0003\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0004sk:tWM\u001d\u0006\u0004\u0003\u0003Q\u0012!\u00026v]&$\u0018bAA\u0003{\n9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA\u0006!\u0011\ti!!\u0005\u000e\u0005\u0005=!bAA\u00011%!\u00111CA\b\u0005-QUK\\5u%Vtg.\u001a:")
public class BgpAnnouncementValidatorTest
extends ValidatorTestCase
implements BeforeAndAfterAll {
    private final ActorSystem actorSystem;
    private final BgpAnnouncementValidator net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject;

    public void org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuite.class.run((FunSuite)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    public void beforeAll(Map<String, Object> configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, configMap);
    }

    public void afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public void afterAll(Map<String, Object> configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, configMap);
    }

    @Override
    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Asn LongToAsn(long asn) {
        return new Asn(asn);
    }

    public Asn StringToAsn(String asn) {
        return Asn.parse((String)asn);
    }

    public IpRange StringToIpRange(String prefix) {
        return IpRange.parse((String)prefix);
    }

    public BgpAnnouncement TupleToBgpAnnouncement(Tuple2<Object, String> x) {
        return BgpAnnouncement$.MODULE$.apply(this.LongToAsn(x._1$mcI$sp()), this.StringToIpRange((String)x._2()));
    }

    public RtrPrefix TupleToRtrPrefix(Tuple2<Object, String> x) {
        return new RtrPrefix(this.LongToAsn(x._1$mcI$sp()), this.StringToIpRange((String)x._2()), RtrPrefix$.MODULE$.apply$default$3(), RtrPrefix$.MODULE$.apply$default$4());
    }

    public RtrPrefix TupleToRtrPrefix(Tuple3<Object, String, Object> x) {
        return new RtrPrefix(this.LongToAsn(BoxesRunTime.unboxToInt((Object)x._1())), this.StringToIpRange((String)x._2()), (Option)new Some(x._3()), RtrPrefix$.MODULE$.apply$default$4());
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public BgpAnnouncementValidator net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject() {
        return this.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject;
    }

    public BgpAnnouncementValidatorTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        this.actorSystem = ActorSystem$.MODULE$.apply();
        this.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject = new BgpAnnouncementValidator(this.actorSystem());
        this.test("should validate prefixes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24")), this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.2.0/24")), this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65003), (Object)"10.0.3.0/24")), this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65004), (Object)"10.0.4.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24")), this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.2.0/24")), this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65003), (Object)"10.0.3.0/24", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToSeqShouldWrapper((Seq)this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements()).should(this.$outer.have()).size(4);
                BgpValidatedAnnouncement[] bgpValidatedAnnouncementArray = new BgpValidatedAnnouncement[4];
                bgpValidatedAnnouncementArray[0] = new BgpValidatedAnnouncement(this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))})), BgpValidatedAnnouncement$.MODULE$.apply$default$3(), BgpValidatedAnnouncement$.MODULE$.apply$default$4());
                BgpAnnouncement x$1 = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.2.0/24"));
                Seq x$2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.2.0/24"))}));
                Seq x$3 = BgpValidatedAnnouncement$.MODULE$.apply$default$2();
                Seq x$4 = BgpValidatedAnnouncement$.MODULE$.apply$default$4();
                bgpValidatedAnnouncementArray[1] = new BgpValidatedAnnouncement(x$1, x$3, x$2, x$4);
                BgpAnnouncement x$5 = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65003), (Object)"10.0.3.0/24"));
                Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65003), (Object)"10.0.3.0/24", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                Seq x$7 = BgpValidatedAnnouncement$.MODULE$.apply$default$2();
                Seq x$8 = BgpValidatedAnnouncement$.MODULE$.apply$default$3();
                bgpValidatedAnnouncementArray[2] = new BgpValidatedAnnouncement(x$5, x$7, x$8, x$6);
                bgpValidatedAnnouncementArray[3] = new BgpValidatedAnnouncement(this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65004), (Object)"10.0.4.0/24")), BgpValidatedAnnouncement$.MODULE$.apply$default$2(), BgpValidatedAnnouncement$.MODULE$.apply$default$3(), BgpValidatedAnnouncement$.MODULE$.apply$default$4());
                this.$outer.convertToSeqShouldWrapper((Seq)this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements()).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])bgpValidatedAnnouncementArray))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be Unknown if there are no RTR prefixes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.empty();
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToSeqShouldWrapper((Seq)this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Asn, IpRange, Enumeration.Value> apply(BgpValidatedAnnouncement x) {
                        return new Tuple3((Object)x.asn(), (Object)x.prefix(), (Object)x.validity());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.$outer.LongToAsn(65001L), (Object)this.$outer.StringToIpRange("10.0.1.0/24"), (Object)RouteValidity$.MODULE$.Unknown())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be Valid if there is an appropriate RTR prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToSeqShouldWrapper((Seq)this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Asn, IpRange, Enumeration.Value> apply(BgpValidatedAnnouncement x) {
                        return new Tuple3((Object)x.asn(), (Object)x.prefix(), (Object)x.validity());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.$outer.LongToAsn(65001L), (Object)this.$outer.StringToIpRange("10.0.1.0/24"), (Object)RouteValidity$.MODULE$.Valid())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be Invalid ASN if there is an appropriate RTR prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.1.0/24"))}));
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToSeqShouldWrapper((Seq)this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Asn, IpRange, Enumeration.Value> apply(BgpValidatedAnnouncement x) {
                        return new Tuple3((Object)x.asn(), (Object)x.prefix(), (Object)x.validity());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.$outer.LongToAsn(65001L), (Object)this.$outer.StringToIpRange("10.0.1.0/24"), (Object)RouteValidity$.MODULE$.InvalidAsn())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be Invalid Length if there is an appropriate RTR prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToSeqShouldWrapper((Seq)this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Asn, IpRange, Enumeration.Value> apply(BgpValidatedAnnouncement x) {
                        return new Tuple3((Object)x.asn(), (Object)x.prefix(), (Object)x.validity());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.$outer.LongToAsn(65001L), (Object)this.$outer.StringToIpRange("10.0.1.0/24"), (Object)RouteValidity$.MODULE$.InvalidLength())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail to construct BgpValidatedAnnouncement if invalidsLength contains a VRP that refers to a different ASN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BgpAnnouncement announcement = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"));
                Seq invalidsAsn = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.1.0/24"))}));
                IllegalArgumentException e = (IllegalArgumentException)this.$outer.convertToEvaluatingApplicationShouldWrapper(this.$outer.evaluating((Function0)new Serializable(this, announcement, invalidsAsn){
                    public static final long serialVersionUID = 0L;
                    private final BgpAnnouncement announcement$1;
                    private final Seq invalidsAsn$1;

                    public final BgpValidatedAnnouncement apply() {
                        BgpAnnouncement x$9 = this.announcement$1;
                        Seq x$10 = this.invalidsAsn$1;
                        Seq x$11 = BgpValidatedAnnouncement$.MODULE$.apply$default$2();
                        Seq x$12 = BgpValidatedAnnouncement$.MODULE$.apply$default$3();
                        return new BgpValidatedAnnouncement(x$9, x$11, x$12, x$10);
                    }
                    {
                        this.announcement$1 = announcement$1;
                        this.invalidsAsn$1 = invalidsAsn$1;
                    }
                })).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(IllegalArgumentException.class)));
                this.$outer.convertToStringShouldWrapper(e.getMessage()).should(this.$outer.equal("requirement failed: invalidsLength must only contain VRPs that refer to the same ASN"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail to construct BgpValidatedAnnouncement if invalidsAsn contains a VRP with the announced ASN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BgpAnnouncement announcement = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"));
                Seq invalidsLength = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.0.0/16", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                IllegalArgumentException e = (IllegalArgumentException)this.$outer.convertToEvaluatingApplicationShouldWrapper(this.$outer.evaluating((Function0)new Serializable(this, announcement, invalidsLength){
                    public static final long serialVersionUID = 0L;
                    private final BgpAnnouncement announcement$2;
                    private final Seq invalidsLength$1;

                    public final BgpValidatedAnnouncement apply() {
                        BgpAnnouncement x$13 = this.announcement$2;
                        Seq x$14 = this.invalidsLength$1;
                        Seq x$15 = BgpValidatedAnnouncement$.MODULE$.apply$default$2();
                        Seq x$16 = BgpValidatedAnnouncement$.MODULE$.apply$default$4();
                        return new BgpValidatedAnnouncement(x$13, x$15, x$14, x$16);
                    }
                    {
                        this.announcement$2 = announcement$2;
                        this.invalidsLength$1 = invalidsLength$1;
                    }
                })).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(IllegalArgumentException.class)));
                this.$outer.convertToStringShouldWrapper(e.getMessage()).should(this.$outer.equal("requirement failed: invalidsAsn must not contain the announced ASN"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be determined by RTR prefixes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BgpAnnouncement announcement = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"));
                Seq valids = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq invalidsAsn = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.1.0/24"))}));
                Seq invalidsLength = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.0.0/16", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                this.$outer.convertToAnyRefShouldWrapper(new BgpValidatedAnnouncement(announcement, BgpValidatedAnnouncement$.MODULE$.apply$default$2(), BgpValidatedAnnouncement$.MODULE$.apply$default$3(), BgpValidatedAnnouncement$.MODULE$.apply$default$4()).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Unknown()));
                BgpAnnouncement x$17 = announcement;
                Seq x$18 = invalidsLength;
                Seq x$19 = BgpValidatedAnnouncement$.MODULE$.apply$default$2();
                Seq x$20 = BgpValidatedAnnouncement$.MODULE$.apply$default$3();
                this.$outer.convertToAnyRefShouldWrapper(new BgpValidatedAnnouncement(x$17, x$19, x$20, x$18).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.InvalidLength()));
                BgpAnnouncement x$21 = announcement;
                Seq x$22 = invalidsAsn;
                Seq x$23 = invalidsLength;
                Seq x$24 = BgpValidatedAnnouncement$.MODULE$.apply$default$2();
                this.$outer.convertToAnyRefShouldWrapper(new BgpValidatedAnnouncement(x$21, x$24, x$22, x$23).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.InvalidLength()));
                BgpAnnouncement x$25 = announcement;
                Seq x$26 = invalidsAsn;
                Seq x$27 = BgpValidatedAnnouncement$.MODULE$.apply$default$2();
                Seq x$28 = BgpValidatedAnnouncement$.MODULE$.apply$default$4();
                this.$outer.convertToAnyRefShouldWrapper(new BgpValidatedAnnouncement(x$25, x$27, x$26, x$28).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.InvalidAsn()));
                this.$outer.convertToAnyRefShouldWrapper(new BgpValidatedAnnouncement(announcement, valids, BgpValidatedAnnouncement$.MODULE$.apply$default$3(), BgpValidatedAnnouncement$.MODULE$.apply$default$4()).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Valid()));
                this.$outer.convertToAnyRefShouldWrapper(new BgpValidatedAnnouncement(announcement, valids, invalidsAsn, BgpValidatedAnnouncement$.MODULE$.apply$default$4()).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Valid()));
                BgpAnnouncement x$29 = announcement;
                Seq x$30 = valids;
                Seq x$31 = invalidsLength;
                Seq x$32 = BgpValidatedAnnouncement$.MODULE$.apply$default$3();
                this.$outer.convertToAnyRefShouldWrapper(new BgpValidatedAnnouncement(x$29, x$30, x$32, x$31).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Valid()));
                this.$outer.convertToAnyRefShouldWrapper(new BgpValidatedAnnouncement(announcement, valids, invalidsAsn, invalidsLength).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Valid()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

