/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import grizzled.slf4j.Logger;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.commands.TopDownWalker;
import net.ripe.rpki.validator.fetchers.CachingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ConsistentObjectFetcher;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RsyncRpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ValidatingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidationProcess;
import net.ripe.rpki.validator.models.ValidationProcess$class;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.RepositoryObjectStore;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import net.ripe.rpki.validator.util.UriToFileMapper;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scalaz.Validation;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u00015\u0011A\u0004\u0016:vgR\fen\u00195peZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t\tb+\u00197jI\u0006$\u0018n\u001c8Qe>\u001cWm]:\t\u0011e\u0001!Q1A\u0005Bi\t!\u0003\u001e:vgR\fen\u00195pe2{7-\u0019;peV\t1\u0004\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\t\u0005!Q\u000f^5m\u0013\t\u0001SD\u0001\nUeV\u001cH/\u00118dQ>\u0014Hj\\2bi>\u0014\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002'Q\u0014Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u0011\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\nA\"\\1y'R\fG.\u001a#bsN\u0004\"a\u0004\u0014\n\u0005\u001d\u0002\"aA%oi\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\tx_J\\\u0017N\\4ESJ,7\r^8ssB\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0003S>T\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022Y\t!a)\u001b7f\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q!QGN\u001c9!\t)\u0002\u0001C\u0003\u001ae\u0001\u00071\u0004C\u0003%e\u0001\u0007Q\u0005C\u0003*e\u0001\u0007!\u0006C\u0004;\u0001\t\u0007I\u0011B\u001e\u0002#Y\fG.\u001b3bi&|gn\u00149uS>t7/F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0006wC2LG-\u0019;j_:T!!\u0011\u0004\u0002\u000f\r|W.\\8og&\u00111I\u0010\u0002\u0012-\u0006d\u0017\u000eZ1uS>tw\n\u001d;j_:\u001c\bBB#\u0001A\u0003%A(\u0001\nwC2LG-\u0019;j_:|\u0005\u000f^5p]N\u0004\u0003bB$\u0001\u0005\u0004%I\u0001S\u0001\u0017%NLhn\u0019#jg.\u001c\u0015m\u00195f\u0005\u0006\u001cX\rU1uQV\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002M]\u0005!A.\u00198h\u0013\tq5J\u0001\u0004TiJLgn\u001a\u0005\u0007!\u0002\u0001\u000b\u0011B%\u0002/I\u001b\u0018P\\2ESN\\7)Y2iK\n\u000b7/\u001a)bi\"\u0004\u0003b\u0002*\u0001\u0005\u0004%IaU\u0001\u0016%\u0016\u0004xn]5u_JLxJ\u00196fGR\u001cFo\u001c:f+\u0005!\u0006CA+^\u001b\u00051&BA,Y\u0003\u0011!'m\u00199\u000b\u0005\u0005K&B\u0001.\\\u0003\u0019\t\u0007/Y2iK*\tA,A\u0002pe\u001eL!A\u0018,\u0003\u001f\t\u000b7/[2ECR\f7k\\;sG\u0016Da\u0001\u0019\u0001!\u0002\u0013!\u0016A\u0006*fa>\u001c\u0018\u000e^8ss>\u0013'.Z2u'R|'/\u001a\u0011\t\u000b\t\u0004A\u0011I2\u00023\u0015DHO]1diR\u0013Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u000b\u0002IB\u0011Q#Z\u0005\u0003M\n\u0011qBV1mS\u0012\fG/\u001a3PE*,7\r\u001e\u0005\u0006Q\u0002!\t%[\u0001\u0010m\u0006d\u0017\u000eZ1uK>\u0013'.Z2ugR\u0011!n\u001e\t\u0005WB\u0014H-D\u0001m\u0015\tig.A\u0005j[6,H/\u00192mK*\u0011q\u000eE\u0001\u000bG>dG.Z2uS>t\u0017BA9m\u0005\ri\u0015\r\u001d\t\u0003gVl\u0011\u0001\u001e\u0006\u0003\u00179J!A\u001e;\u0003\u0007U\u0013\u0016\nC\u0003yO\u0002\u0007\u00110A\u0006dKJ$\u0018NZ5dCR,\u0007C\u0001>~\u001b\u0005Y(B\u0001??\u0003Ay'M[3diZ\fG.\u001b3bi>\u00148/\u0003\u0002\u007fw\na3)\u001a:uS\u001aL7-\u0019;f%\u0016\u0004xn]5u_JLxJ\u00196fGR4\u0016\r\\5eCRLwN\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003I9\u0018\u000e]3Sgft7\rR5tW\u000e\u000b7\r[3\u0015\u0005\u0005\u0015\u0001cA\b\u0002\b%\u0019\u0011\u0011\u0002\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001b\u0001A\u0011BA\b\u00035\u0019'/Z1uK\u001a+Go\u00195feR!\u0011\u0011CA\u000f!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\t\u0005Aa-\u001a;dQ\u0016\u00148/\u0003\u0003\u0002\u001c\u0005U!AI\"feRLg-[2bi\u0016\u0014V\r]8tSR|'/_(cU\u0016\u001cGOR3uG\",'\u000f\u0003\u0005\u0002 \u0005-\u0001\u0019AA\u0011\u0003%a\u0017n\u001d;f]\u0016\u00148\u000fE\u0003\u0010\u0003G\t9#C\u0002\u0002&A\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011\tI#a\f\u000f\t\u0005M\u00111F\u0005\u0005\u0003[\t)\"A\u0016O_RLg-_5oO\u000e+'\u000f^5gS\u000e\fG/\u001a*fa>\u001c\u0018\u000e^8ss>\u0013'.Z2u\r\u0016$8\r[3s\u0013\u0011\t\t$a\r\u0003\u00111K7\u000f^3oKJTA!!\f\u0002\u0016!Q\u0011q\u0007\u0001\t\u0006\u0004&I!!\u000f\u0002/\r|gn]5ti\u0016tGo\u00142kK\u000e$h)\u001a;dQ\u0016\u0014XCAA\u001e!\u0011\t\u0019\"!\u0010\n\t\u0005}\u0012Q\u0003\u0002\u0018\u0007>t7/[:uK:$xJ\u00196fGR4U\r^2iKJD!\"a\u0011\u0001\u0011\u0003\u0005\u000b\u0015BA\u001e\u0003a\u0019wN\\:jgR,g\u000e^(cU\u0016\u001cGOR3uG\",'\u000f\t\u0004\u0007\u0003\u000f\u0002A!!\u0013\u0003\u0019I{\u0017mQ8mY\u0016\u001cGo\u001c:\u0014\t\u0005\u0015\u00131\n\t\u0005\u0003S\ti%\u0003\u0003\u0002P\u0005M\"a\u0004'jgR,g.\u001a:BI\u0006\u0004H/\u001a:\t\u0015\u0005M\u0013Q\tB\u0001B\u0003%1$A\u0006ueV\u001cH/\u00118dQ>\u0014\bbCA,\u0003\u000b\u0012\t\u0011)A\u0005\u00033\nqa\u001c2kK\u000e$8\u000f\r\u0003\u0002\\\u0005E\u0004\u0003CA/\u0003G\n9'!\u001c\u000e\u0005\u0005}#bAA1]\u00069Q.\u001e;bE2,\u0017\u0002BA3\u0003?\u0012qAQ;jY\u0012,'\u000fE\u0003\u0010\u0003S\u0012H-C\u0002\u0002lA\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA8\u0003cb\u0001\u0001\u0002\u0007\u0002t\u0005U\u0013\u0011!A\u0001\u0006\u0003\t)HA\u0002`IE\nB!a\u001e\u0002~A\u0019q\"!\u001f\n\u0007\u0005m\u0004CA\u0004O_RD\u0017N\\4\u0011\u0007=\ty(C\u0002\u0002\u0002B\u00111!\u00118z\u0011\u001d\u0019\u0014Q\tC\u0001\u0003\u000b#b!a\"\u0002\f\u00065\u0005\u0003BAE\u0003\u000bj\u0011\u0001\u0001\u0005\b\u0003'\n\u0019\t1\u0001\u001c\u0011!\t9&a!A\u0002\u0005=\u0005\u0007BAI\u0003+\u0003\u0002\"!\u0018\u0002d\u0005\u001d\u00141\u0013\t\u0005\u0003_\n)\n\u0002\u0007\u0002t\u00055\u0015\u0011!A\u0001\u0006\u0003\t)\b\u0003\u0005\u0002\u001a\u0006\u0015C\u0011IAN\u0003E\tg\r^3s\r\u0016$8\r\u001b$bS2,(/\u001a\u000b\u0007\u0003\u000b\ti*!)\t\u000f\u0005}\u0015q\u0013a\u0001e\u0006\u0019QO]5\t\u0011\u0005\r\u0016q\u0013a\u0001\u0003K\u000baA]3tk2$\bcA\u001f\u0002(&\u0019\u0011\u0011\u0016 \u0003!Y\u000bG.\u001b3bi&|gNU3tk2$\b\u0002CAW\u0003\u000b\"\t%a,\u0002#\u00054G/\u001a:GKR\u001c\u0007nU;dG\u0016\u001c8\u000f\u0006\u0005\u0002\u0006\u0005E\u00161WAb\u0011\u001d\ty*a+A\u0002ID\u0001\"!.\u0002,\u0002\u0007\u0011qW\u0001\u0004_\nT\u0007\u0003BA]\u0003\u007fk!!a/\u000b\u0007\u0005u\u0006)\u0001\u0004def\u0004Ho\\\u0005\u0005\u0003\u0003\fYLA\u000eDKJ$\u0018NZ5dCR,'+\u001a9pg&$xN]=PE*,7\r\u001e\u0005\t\u0003G\u000bY\u000b1\u0001\u0002&\u0002")
public class TrustAnchorValidationProcess
implements ValidationProcess {
    private final TrustAnchorLocator trustAnchorLocator;
    private final int maxStaleDays;
    private final ValidationOptions validationOptions;
    private final String RsyncDiskCacheBasePath;
    private final BasicDataSource RepositoryObjectStore;
    private ConsistentObjectFetcher consistentObjectFetcher;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private ConsistentObjectFetcher consistentObjectFetcher$lzycompute() {
        TrustAnchorValidationProcess trustAnchorValidationProcess = this;
        synchronized (trustAnchorValidationProcess) {
            if (!this.bitmap$0) {
                Rsync rsync = new Rsync();
                rsync.setTimeoutInSeconds(300);
                RsyncRpkiRepositoryObjectFetcher rsyncFetcher = new RsyncRpkiRepositoryObjectFetcher(rsync, new UriToFileMapper(new File(new StringBuilder().append((Object)this.RsyncDiskCacheBasePath()).append((Object)this.trustAnchorLocator().getFile().getName()).toString())));
                this.consistentObjectFetcher = new ConsistentObjectFetcher(rsyncFetcher, new RepositoryObjectStore((DataSource)this.RepositoryObjectStore()));
                this.bitmap$0 = true;
            }
            return this.consistentObjectFetcher;
        }
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void net$ripe$rpki$validator$models$ValidationProcess$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Validation<String, Map<URI, ValidatedObject>> runProcess() {
        return ValidationProcess$class.runProcess(this);
    }

    @Override
    public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
        return ValidationProcess$class.exceptionHandler(this);
    }

    @Override
    public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
        return ValidationProcess$class.objectFetcherListeners(this);
    }

    @Override
    public void finishProcessing() {
        ValidationProcess$class.finishProcessing(this);
    }

    @Override
    public void shutdown() {
        ValidationProcess$class.shutdown(this);
    }

    @Override
    public TrustAnchorLocator trustAnchorLocator() {
        return this.trustAnchorLocator;
    }

    private ValidationOptions validationOptions() {
        return this.validationOptions;
    }

    private String RsyncDiskCacheBasePath() {
        return this.RsyncDiskCacheBasePath;
    }

    private BasicDataSource RepositoryObjectStore() {
        return this.RepositoryObjectStore;
    }

    @Override
    public ValidatedObject extractTrustAnchorLocator() {
        Option<X509ResourceCertificate> option;
        block4: {
            InvalidObject invalidObject;
            block3: {
                ValidationResult validationResult;
                URI uri;
                block2: {
                    uri = this.trustAnchorLocator().getCertificateLocation();
                    validationResult = ValidationResult.withLocation((URI)uri);
                    option = this.consistentObjectFetcher().getTrustAnchorCertificate(uri, validationResult);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    X509ResourceCertificate certificate = (X509ResourceCertificate)some.x();
                    String string = this.trustAnchorLocator().getPublicKeyInfo();
                    String string2 = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)certificate.getCertificate());
                    validationResult.rejectIfFalse(!(string != null ? !string.equals(string2) : string2 != null), "trust.anchor.public.key.match", new String[0]);
                    invalidObject = validationResult.hasFailureForCurrentLocation() ? new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet()) : new ValidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet(), (CertificateRepositoryObject)certificate);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<X509ResourceCertificate> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                invalidObject = new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet());
            }
            return invalidObject;
        }
        throw new MatchError(option);
    }

    @Override
    public Map<URI, ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate) {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        RoaCollector roaCollector = new RoaCollector(this, this.trustAnchorLocator(), builder);
        CertificateRepositoryObjectFetcher fetcher = this.createFetcher((Seq<NotifyingCertificateRepositoryObjectFetcher.Listener>)((Seq)this.objectFetcherListeners().$plus$colon((Object)roaCollector, Seq$.MODULE$.canBuildFrom())));
        RepositoryObjectStore cache = new RepositoryObjectStore((DataSource)this.RepositoryObjectStore());
        cache.purgeExpired(this.maxStaleDays);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.trustAnchorLocator().getPrefetchUris()).asScala()).foreach((Function1)new Serializable(this, fetcher){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcess $outer;
            private final CertificateRepositoryObjectFetcher fetcher$1;

            public final void apply(URI prefetchUri) {
                this.$outer.logger().info((Function0)new Serializable(this, prefetchUri){
                    public static final long serialVersionUID = 0L;
                    private final URI prefetchUri$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Prefetching '").append((Object)this.prefetchUri$1).append((Object)"'").toString();
                    }
                    {
                        this.prefetchUri$1 = prefetchUri$1;
                    }
                });
                ValidationResult validationResult = ValidationResult.withLocation((URI)prefetchUri);
                this.fetcher$1.prefetch(prefetchUri, validationResult);
                this.$outer.logger().info((Function0)new Serializable(this, prefetchUri){
                    public static final long serialVersionUID = 0L;
                    private final URI prefetchUri$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Done prefetching for '").append((Object)this.prefetchUri$1).append((Object)"'").toString();
                    }
                    {
                        this.prefetchUri$1 = prefetchUri$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fetcher$1 = fetcher$1;
            }
        });
        TopDownWalker walker = new TopDownWalker(fetcher);
        walker.addTrustAnchor(certificate);
        walker.execute();
        return (Map)builder.result();
    }

    public void wipeRsyncDiskCache() {
        File diskCache = new File(this.RsyncDiskCacheBasePath());
        if (diskCache.isDirectory()) {
            FileUtils.cleanDirectory((File)diskCache);
        }
    }

    private CertificateRepositoryObjectFetcher createFetcher(Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> listeners) {
        ValidatingCertificateRepositoryObjectFetcher validatingFetcher = new ValidatingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)this.consistentObjectFetcher(), this.validationOptions());
        NotifyingCertificateRepositoryObjectFetcher notifyingFetcher = new NotifyingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)validatingFetcher);
        CachingCertificateRepositoryObjectFetcher cachingFetcher = new CachingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)notifyingFetcher);
        validatingFetcher.setOuterMostDecorator((CertificateRepositoryObjectFetcher)cachingFetcher);
        listeners.foreach((Function1)new Serializable(this, notifyingFetcher){
            public static final long serialVersionUID = 0L;
            private final NotifyingCertificateRepositoryObjectFetcher notifyingFetcher$1;

            public final void apply(NotifyingCertificateRepositoryObjectFetcher.Listener x$1) {
                this.notifyingFetcher$1.addCallback(x$1);
            }
            {
                this.notifyingFetcher$1 = notifyingFetcher$1;
            }
        });
        return cachingFetcher;
    }

    private ConsistentObjectFetcher consistentObjectFetcher() {
        return this.bitmap$0 ? this.consistentObjectFetcher : this.consistentObjectFetcher$lzycompute();
    }

    public TrustAnchorValidationProcess(TrustAnchorLocator trustAnchorLocator, int maxStaleDays, File workingDirectory) {
        this.trustAnchorLocator = trustAnchorLocator;
        this.maxStaleDays = maxStaleDays;
        ValidationProcess$class.$init$(this);
        this.validationOptions = new ValidationOptions();
        this.RsyncDiskCacheBasePath = new StringBuilder().append((Object)workingDirectory.toString()).append((Object)File.separator).append((Object)"cache").append((Object)File.separator).toString();
        this.RepositoryObjectStore = DataSources$.MODULE$.DurableDataSource(workingDirectory);
        this.validationOptions().setMaxStaleDays(maxStaleDays);
    }

    public class RoaCollector
    extends NotifyingCertificateRepositoryObjectFetcher.ListenerAdapter {
        private final Builder<Tuple2<URI, ValidatedObject>, ?> objects;
        public final /* synthetic */ TrustAnchorValidationProcess $outer;

        public void afterFetchFailure(URI uri, ValidationResult result) {
            this.objects.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)uri), (Object)new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet())));
        }

        public void afterFetchSuccess(URI uri, CertificateRepositoryObject obj, ValidationResult result) {
            this.objects.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)uri), (Object)new ValidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet(), obj)));
        }

        public /* synthetic */ TrustAnchorValidationProcess net$ripe$rpki$validator$models$TrustAnchorValidationProcess$RoaCollector$$$outer() {
            return this.$outer;
        }

        public RoaCollector(TrustAnchorValidationProcess $outer, TrustAnchorLocator trustAnchor, Builder<Tuple2<URI, ValidatedObject>, ?> objects) {
            this.objects = objects;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

