/*
 * Decompiled with CFR 0.152.
 */
package rl;

import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import rl.AbsolutePath;
import rl.AbsoluteUri;
import rl.Authority;
import rl.Authority$;
import rl.EmptyPath$;
import rl.FailedUri;
import rl.QueryString$;
import rl.RelativePath;
import rl.RelativeUri;
import rl.Scheme;
import rl.Uri;
import rl.UriFragment$;
import rl.UriPath;
import rl.package;
import rl.package$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.GenSeq;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class Uri$ {
    public static final Uri$ MODULE$;
    private final Regex UriParts;
    private volatile boolean bitmap$init$0;

    static {
        new Uri$();
    }

    public Regex UriParts() {
        if (this.bitmap$init$0) {
            return this.UriParts;
        }
        throw new UninitializedFieldError("Uninitialized field: Uri.scala: 93".toString());
    }

    public Uri apply(String uriString) {
        Uri uri;
        try {
            uri = this.apply(URI.create(uriString), this.apply$default$2());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            uri = new FailedUri(illegalArgumentException, uriString);
        }
        catch (URISyntaxException uRISyntaxException) {
            uri = new FailedUri(uRISyntaxException, uriString);
        }
        return uri;
    }

    public Uri apply(URI u, Option<String> originalUri) {
        Product product;
        try {
            String string = u.getRawPath();
            package$ package$2 = package$.MODULE$;
            UriPath pth = this.parsePath(new package.UriStringExtensions(string).blankOption());
            if (u.isAbsolute()) {
                None$ none$;
                Scheme scheme = new Scheme(u.getScheme());
                String string2 = u.getRawAuthority();
                package$ package$3 = package$.MODULE$;
                Option<String> option = new package.UriStringExtensions(string2).blankOption();
                if (!option.isEmpty()) {
                    Object object = option.get();
                    String string3 = (String)object;
                    Some some = new Some((Object)Authority$.MODULE$.apply(IDN.toASCII(string3)));
                    none$ = some;
                } else {
                    none$ = None$.MODULE$;
                }
                product = new AbsoluteUri(scheme, (Option<Authority>)none$, pth, QueryString$.MODULE$.apply(u.getRawQuery()), UriFragment$.MODULE$.apply(u.getRawFragment()), (String)(!originalUri.isEmpty() ? originalUri.get() : u.toString()));
            } else {
                None$ none$;
                String string4 = u.getRawAuthority();
                package$ package$4 = package$.MODULE$;
                Option<String> option = new package.UriStringExtensions(string4).blankOption();
                if (!option.isEmpty()) {
                    Object object = option.get();
                    String string5 = (String)object;
                    Some some = new Some((Object)Authority$.MODULE$.apply(IDN.toASCII(string5)));
                    none$ = some;
                } else {
                    none$ = None$.MODULE$;
                }
                product = new RelativeUri((Option<Authority>)none$, pth, QueryString$.MODULE$.apply(u.getRawQuery()), UriFragment$.MODULE$.apply(u.getRawFragment()), (String)(!originalUri.isEmpty() ? originalUri.get() : u.toString()));
            }
        }
        catch (Throwable throwable) {
            product = new FailedUri(throwable, (String)(!originalUri.isEmpty() ? originalUri.get() : u.toString()));
        }
        catch (NullPointerException nullPointerException) {
            product = new FailedUri(nullPointerException, (String)(!originalUri.isEmpty() ? originalUri.get() : u.toString()));
        }
        return product;
    }

    public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    private UriPath parsePath(Option<String> text) {
        block6: {
            Serializable serializable;
            block3: {
                Some x2;
                boolean rc7;
                block5: {
                    block4: {
                        block2: {
                            rc7 = false;
                            x2 = null;
                            None$ none$ = None$.MODULE$;
                            if (none$ != null ? !none$.equals(text) : text != null) break block2;
                            serializable = EmptyPath$.MODULE$;
                            break block3;
                        }
                        if (!(text instanceof Some)) break block4;
                        rc7 = true;
                        x2 = (Some)text;
                        if (x2 == null) break block4;
                        String string = ((String)x2.x()).trim();
                        if (string != null ? !string.equals("/") : "/" != null) break block4;
                        serializable = EmptyPath$.MODULE$;
                        break block3;
                    }
                    if (!rc7 || x2 == null || !((String)x2.x()).startsWith("/")) break block5;
                    serializable = new AbsolutePath((GenSeq<String>)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)x2.x()).split("/")).drop(1)).toList());
                    break block3;
                }
                if (!rc7 || x2 == null) break block6;
                serializable = new RelativePath((GenSeq<String>)Predef$.MODULE$.wrapRefArray((Object[])((String)x2.x()).split("/")));
            }
            return serializable;
        }
        throw new MatchError(text);
    }

    private Uri$() {
        MODULE$ = this;
        Predef$ predef$ = Predef$.MODULE$;
        this.UriParts = new StringOps("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?").r();
        this.bitmap$init$0 = true;
    }
}

