/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.util;

import ch.epfl.lamp.compiler.msil.PEFile;
import java.io.PrintStream;

public final class PESection {
    private final PEFile file;
    private final long sectionStart;
    public final String name;
    public final int virtAddr;
    public final int virtSize;
    public final int realAddr;
    public final int realSize;
    public final int flags;
    private static final byte[] buf = new byte[8];

    public PESection(PEFile file) {
        int i;
        this.file = file;
        this.sectionStart = file.pos();
        file.read(buf);
        for (i = 7; i >= 0 && 0 == buf[i]; --i) {
        }
        this.name = new String(buf, 0, i + 1);
        this.virtSize = file.readInt();
        this.virtAddr = file.readInt();
        this.realSize = file.readInt();
        this.realAddr = file.readInt();
        file.skip(12);
        this.flags = file.readInt();
    }

    public void dump(PrintStream out) {
        out.println("Section name:    " + this.name + " (name.length=" + this.name.length() + ")");
        out.println("Virtual Address: 0x" + PEFile.int2hex(this.virtAddr));
        out.println("Virtual Size:    0x" + PEFile.int2hex(this.virtSize));
        out.println("Real Address:    0x" + PEFile.int2hex(this.realAddr));
        out.println("Real Size:       0x" + PEFile.int2hex(this.realSize));
        out.println("Flags:           0x" + PEFile.int2hex(this.flags));
    }
}

