/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorInterruptedException;
import akka.actor.ActorRef;
import akka.actor.ChildRestartStats;
import akka.actor.Failed;
import akka.actor.InternalActorRef;
import akka.actor.PostRestartException;
import akka.actor.PreRestartException;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$Termination$;
import akka.dispatch.ChildTerminated;
import akka.dispatch.NullMessage$;
import akka.dispatch.SystemMessage;
import akka.event.Logging;
import akka.event.Logging$;
import akka.event.Logging$Error$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class FaultHandling$class {
    private static void suspendNonRecursive(ActorCell $this) {
        $this.dispatcher().suspend($this);
    }

    private static void resumeNonRecursive(ActorCell $this) {
        $this.dispatcher().resume($this);
    }

    private static boolean isFailed(ActorCell $this) {
        return $this.akka$actor$dungeon$FaultHandling$$_failed() != null;
    }

    private static void setFailed(ActorCell $this, ActorRef perpetrator) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(perpetrator);
    }

    private static void clearFailed(ActorCell $this) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(null);
    }

    private static ActorRef perpetrator(ActorCell $this) {
        return $this.akka$actor$dungeon$FaultHandling$$_failed();
    }

    public static void faultRecreate(ActorCell $this, Throwable cause) {
        block10: {
            Actor failedActor;
            block12: {
                block11: {
                    block9: {
                        if ($this.actor() != null) break block9;
                        $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Recreate into Create after ").append((Object)cause).toString()));
                        $this.faultCreate();
                        break block10;
                    }
                    if (!$this.isNormal()) break block11;
                    failedActor = $this.actor();
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(failedActor), "restarting"));
                    }
                    if (failedActor == null) break block12;
                    None$ optionalMessage = $this.currentMessage() != null ? new Some($this.currentMessage().message()) : None$.MODULE$;
                    try {
                        if (failedActor.context() != null) {
                            failedActor.preRestart(cause, (Option<Object>)optionalMessage);
                        }
                        $this.clearActorFields(failedActor);
                    }
                    catch (Throwable throwable) {
                        try {
                            Throwable x4 = throwable;
                            Option o11 = NonFatal$.MODULE$.unapply(x4);
                            if (o11.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)o11.get();
                            PreRestartException ex = new PreRestartException($this.self(), e, cause, (Option<Object>)optionalMessage);
                            $this.publish(new Logging.Error(ex, $this.self().path().toString(), $this.clazz(failedActor), e.getMessage()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        finally {
                            $this.clearActorFields(failedActor);
                        }
                    }
                }
                $this.faultResume(null);
                break block10;
            }
            Predef$.MODULE$.assert($this.mailbox().isSuspended(), (Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ActorCell $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"mailbox must be suspended during restart, status=").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.mailbox().status())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (!$this.setChildrenTerminationReason(new ChildrenContainer.Recreation(cause))) {
                FaultHandling$class.finishRecreate($this, cause, failedActor);
            }
        }
    }

    public static void faultSuspend(ActorCell $this) {
        FaultHandling$class.suspendNonRecursive($this);
        $this.suspendChildren($this.suspendChildren$default$1());
    }

    public static void faultResume(ActorCell $this, Throwable causedByFailure) {
        if ($this.actor() == null) {
            $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Resume into Create after ").append((Object)causedByFailure).toString()));
            $this.faultCreate();
        } else if ($this.actor().context() == null && causedByFailure != null) {
            $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Resume into Restart after ").append((Object)causedByFailure).toString()));
            $this.faultRecreate(causedByFailure);
        } else {
            ActorRef perp = FaultHandling$class.perpetrator($this);
            FaultHandling$class.resumeNonRecursive($this);
            $this.resumeChildren(causedByFailure, perp);
        }
        return;
        finally {
            if (causedByFailure != null) {
                FaultHandling$class.clearFailed($this);
            }
        }
    }

    public static void faultCreate(ActorCell $this) {
        Predef$.MODULE$.assert($this.mailbox().isSuspended(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"mailbox must be suspended during failed creation, status=").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.mailbox().status())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ActorRef actorRef = FaultHandling$class.perpetrator($this);
        InternalActorRef internalActorRef = $this.self();
        Predef$.MODULE$.assert(!(actorRef != null ? !((Object)actorRef).equals(internalActorRef) : internalActorRef != null));
        $this.setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
        $this.cancelReceiveTimeout();
        $this.children().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final void apply(ActorRef actor) {
                this.$outer.stop(actor);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (!$this.setChildrenTerminationReason(new ChildrenContainer.Creation())) {
            FaultHandling$class.finishCreate($this);
        }
    }

    private static void finishCreate(ActorCell $this) {
        try {
            FaultHandling$class.resumeNonRecursive($this);
            $this.create($this.uid());
            return;
        }
        finally {
            FaultHandling$class.clearFailed($this);
        }
    }

    public static void terminate(ActorCell $this) {
        $this.setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
        $this.cancelReceiveTimeout();
        $this.children().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final void apply(ActorRef actor) {
                this.$outer.stop(actor);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        boolean wasTerminating = $this.isTerminating();
        if ($this.setChildrenTerminationReason(ChildrenContainer$Termination$.MODULE$)) {
            if (!wasTerminating) {
                FaultHandling$class.suspendNonRecursive($this);
                FaultHandling$class.setFailed($this, $this.self());
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), "stopping"));
                }
            }
        } else {
            $this.setTerminated();
            FaultHandling$class.finishTerminate($this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void handleInvokeFailure(ActorCell $this, Iterable childrenNotToSuspend, Throwable t, String message) {
        block9: {
            $this.publish(new Logging.Error(t, $this.self().path().toString(), $this.clazz($this.actor()), message));
            if (FaultHandling$class.isFailed($this)) break block9;
            try {
                FaultHandling$class.suspendNonRecursive($this);
                var11_4 = $this.currentMessage();
                if (var11_4 == null) ** GOTO lbl-1000
                p2 = var11_4.message();
                child = var11_4.sender();
                if (p2 instanceof Failed && (x5 = (Failed)p2) != null) {
                    p3 = x5.cause();
                    p4 = x5.uid();
                    FaultHandling$class.setFailed($this, child);
                    var17_10 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorRef[]{child}));
                } else lbl-1000:
                // 2 sources

                {
                    FaultHandling$class.setFailed($this, $this.self());
                    var17_10 = Predef$.MODULE$.Set().empty();
                }
                skip = var17_10;
                $this.suspendChildren((Set<ActorRef>)((Set)skip.$plus$plus((GenTraversableOnce)childrenNotToSuspend)));
                var18_12 = t;
                if (var18_12 instanceof InterruptedException) {
                    x2 = (InterruptedException)var18_12;
                    $this.parent().tell(new Failed(new ActorInterruptedException(t), $this.uid()), $this.self());
                    Thread.interrupted();
                    throw t;
                }
                $this.parent().tell(new Failed(t, $this.uid()), $this.self());
                var20_14 = BoxedUnit.UNIT;
            }
            catch (Throwable var4_15) {
                x4 = var4_15;
                o11 = NonFatal$.MODULE$.unapply(x4);
                if (o11.isEmpty()) {
                    throw var4_15;
                }
                e = (Throwable)o11.get();
                $this.publish(new Logging.Error(e, $this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"emergency stop: exception in failure handling for ").append(t.getClass()).append((Object)Logging$.MODULE$.stackTraceFor(t)).toString()));
                $this.children().foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ActorCell $outer;

                    public final void apply(ActorRef actor) {
                        this.$outer.stop(actor);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                var8_19 = BoxedUnit.UNIT;
            }
        }
        return;
        {
            finally {
                FaultHandling$class.finishTerminate($this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void finishTerminate(ActorCell $this) {
        Actor a;
        block246: {
            a = $this.actor();
            try {
                if (a == null) break block246;
                a.postStop();
            }
            catch (Throwable throwable) {
                try {
                    Throwable x4 = throwable;
                    Option o11 = NonFatal$.MODULE$.unapply(x4);
                    if (o11.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)o11.get();
                    $this.publish(new Logging.Error(e, $this.self().path().toString(), $this.clazz(a), e.getMessage()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable13) {
                    try {
                        $this.dispatcher().detach($this);
                        throw throwable13;
                    }
                    finally {
                        try {
                            $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
                        }
                        finally {
                            try {
                                NullMessage$ x$1 = NullMessage$.MODULE$;
                                ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                                $this.parent().$bang(x$1, x$2);
                            }
                            finally {
                                try {
                                    $this.tellWatchersWeDied(a);
                                }
                                finally {
                                    try {
                                        $this.unwatchWatchedActors(a);
                                    }
                                    finally {
                                        if ($this.system().settings().DebugLifecycle()) {
                                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                                        }
                                        $this.clearActorFields(a);
                                        $this.actor_$eq(null);
                                    }
                                }
                            }
                        }
                    }
                }
                try {
                    $this.dispatcher().detach($this);
                }
                finally {
                    try {
                        $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
                    }
                    catch (Throwable throwable2) {
                        try {
                            NullMessage$ x$1 = NullMessage$.MODULE$;
                            ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                            $this.parent().$bang(x$1, x$2);
                        }
                        catch (Throwable throwable14) {
                            try {
                                $this.tellWatchersWeDied(a);
                            }
                            catch (Throwable throwable15) {
                                try {
                                    $this.unwatchWatchedActors(a);
                                    throw throwable15;
                                }
                                finally {
                                    if ($this.system().settings().DebugLifecycle()) {
                                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                                    }
                                    $this.clearActorFields(a);
                                    $this.actor_$eq(null);
                                }
                            }
                            try {
                                $this.unwatchWatchedActors(a);
                                throw throwable14;
                            }
                            finally {
                                if ($this.system().settings().DebugLifecycle()) {
                                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                                }
                                $this.clearActorFields(a);
                                $this.actor_$eq(null);
                            }
                        }
                        try {
                            $this.tellWatchersWeDied(a);
                        }
                        catch (Throwable throwable16) {
                            try {
                                $this.unwatchWatchedActors(a);
                                throw throwable16;
                            }
                            finally {
                                if ($this.system().settings().DebugLifecycle()) {
                                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                                }
                                $this.clearActorFields(a);
                                $this.actor_$eq(null);
                            }
                        }
                        try {
                            $this.unwatchWatchedActors(a);
                            throw throwable2;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                            }
                            $this.clearActorFields(a);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        NullMessage$ x$1 = NullMessage$.MODULE$;
                        ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                        $this.parent().$bang(x$1, x$2);
                    }
                    catch (Throwable throwable3) {
                        try {
                            $this.tellWatchersWeDied(a);
                        }
                        catch (Throwable throwable17) {
                            try {
                                $this.unwatchWatchedActors(a);
                                throw throwable17;
                            }
                            finally {
                                if ($this.system().settings().DebugLifecycle()) {
                                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                                }
                                $this.clearActorFields(a);
                                $this.actor_$eq(null);
                            }
                        }
                        try {
                            $this.unwatchWatchedActors(a);
                            throw throwable3;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                            }
                            $this.clearActorFields(a);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        $this.tellWatchersWeDied(a);
                    }
                    catch (Throwable throwable4) {
                        try {
                            $this.unwatchWatchedActors(a);
                            throw throwable4;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                            }
                            $this.clearActorFields(a);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        $this.unwatchWatchedActors(a);
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                    }
                    catch (Throwable throwable5) {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                        throw throwable5;
                    }
                    $this.actor_$eq(null);
                }
            }
        }
        try {
            $this.dispatcher().detach($this);
        }
        catch (Throwable throwable) {
            try {
                $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
            }
            catch (Throwable throwable2) {
                try {
                    NullMessage$ x$1 = NullMessage$.MODULE$;
                    ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                    $this.parent().$bang(x$1, x$2);
                }
                catch (Throwable throwable3) {
                    try {
                        $this.tellWatchersWeDied(a);
                    }
                    catch (Throwable throwable4) {
                        try {
                            $this.unwatchWatchedActors(a);
                            throw throwable4;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                            }
                            $this.clearActorFields(a);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        $this.unwatchWatchedActors(a);
                        throw throwable3;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.tellWatchersWeDied(a);
                }
                catch (Throwable throwable5) {
                    try {
                        $this.unwatchWatchedActors(a);
                        throw throwable5;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable2;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                NullMessage$ x$1 = NullMessage$.MODULE$;
                ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                $this.parent().$bang(x$1, x$2);
            }
            catch (Throwable throwable6) {
                try {
                    $this.tellWatchersWeDied(a);
                }
                catch (Throwable throwable7) {
                    try {
                        $this.unwatchWatchedActors(a);
                        throw throwable7;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable6;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.tellWatchersWeDied(a);
            }
            catch (Throwable throwable8) {
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable8;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors(a);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                }
                $this.clearActorFields(a);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
        }
        catch (Throwable throwable) {
            try {
                NullMessage$ x$1 = NullMessage$.MODULE$;
                ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                $this.parent().$bang(x$1, x$2);
            }
            catch (Throwable throwable9) {
                try {
                    $this.tellWatchersWeDied(a);
                }
                catch (Throwable throwable10) {
                    try {
                        $this.unwatchWatchedActors(a);
                        throw throwable10;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable9;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.tellWatchersWeDied(a);
            }
            catch (Throwable throwable11) {
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable11;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors(a);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                }
                $this.clearActorFields(a);
                $this.actor_$eq(null);
            }
        }
        try {
            NullMessage$ x$1 = NullMessage$.MODULE$;
            ActorRef x$2 = $this.parent().$bang$default$2(x$1);
            $this.parent().$bang(x$1, x$2);
        }
        catch (Throwable throwable) {
            try {
                $this.tellWatchersWeDied(a);
            }
            catch (Throwable throwable12) {
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable12;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors(a);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                }
                $this.clearActorFields(a);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.tellWatchersWeDied(a);
        }
        catch (Throwable throwable) {
            try {
                $this.unwatchWatchedActors(a);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                }
                $this.clearActorFields(a);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.unwatchWatchedActors(a);
            return;
        }
        finally {
            if ($this.system().settings().DebugLifecycle()) {
                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
            }
            $this.clearActorFields(a);
            $this.actor_$eq(null);
        }
    }

    private static void finishRecreate(ActorCell $this, Throwable cause, Actor failedActor) {
        block8: {
            Iterable<ActorRef> survivors = $this.children();
            try {
                Actor freshActor;
                block7: {
                    FaultHandling$class.resumeNonRecursive($this);
                    freshActor = $this.newActor();
                    $this.actor_$eq(freshActor);
                    if (freshActor == failedActor) {
                        $this.setActorFields(freshActor, $this, $this.self());
                    }
                    freshActor.postRestart(cause);
                    if (!$this.system().settings().DebugLifecycle()) break block7;
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(freshActor), "restarted"));
                }
                survivors.foreach((Function1)new Serializable($this, cause, freshActor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ActorCell $outer;
                    private final Throwable cause$1;
                    private final Actor freshActor$1;

                    public final void apply(ActorRef child) {
                        try {
                            ((InternalActorRef)child).restart(this.cause$1);
                        }
                        catch (Throwable throwable) {
                            Throwable x4 = throwable;
                            Option o11 = NonFatal$.MODULE$.unapply(x4);
                            if (o11.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)o11.get();
                            this.$outer.publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.freshActor$1), new StringBuilder().append((Object)"restarting ").append((Object)child).toString()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cause$1 = cause$1;
                        this.freshActor$1 = freshActor$1;
                    }
                });
                break block8;
                finally {
                    FaultHandling$class.clearFailed($this);
                }
            }
            catch (Throwable throwable) {
                Throwable x4 = throwable;
                Option o11 = NonFatal$.MODULE$.unapply(x4);
                if (o11.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)o11.get();
                $this.clearActorFields($this.actor());
                $this.handleInvokeFailure(survivors, new PostRestartException((ActorRef)$this.self(), e, cause), e.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final void handleFailure(ActorCell $this, ActorRef child, Throwable cause, int uid) {
        Option<ChildRestartStats> option;
        block6: {
            block4: {
                block5: {
                    Some x2;
                    boolean rc6;
                    block2: {
                        block3: {
                            ChildRestartStats stats2;
                            rc6 = false;
                            x2 = null;
                            option = $this.getChildByRef(child);
                            if (!(option instanceof Some)) break block2;
                            rc6 = true;
                            x2 = (Some)option;
                            if (x2 == null || (stats2 = (ChildRestartStats)x2.x()).uid() != uid) break block2;
                            if (!$this.actor().supervisorStrategy().handleFailure($this, child, cause, stats2, $this.getAllChildStats())) break block3;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        throw cause;
                    }
                    if (!rc6 || x2 == null) break block5;
                    ChildRestartStats stats3 = (ChildRestartStats)x2.x();
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"dropping Failed(").append((Object)cause).append((Object)") from old child ").append((Object)child).append((Object)" (uid=").append((Object)BoxesRunTime.boxToInteger((int)stats3.uid())).append((Object)" != ").append((Object)BoxesRunTime.boxToInteger((int)uid)).append((Object)")").toString()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                None$ none$ = None$.MODULE$;
                Option<ChildRestartStats> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                Option<ChildRestartStats> x4 = option;
                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"dropping Failed(").append((Object)cause).append((Object)") from unknown child ").append((Object)child).toString()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SystemMessage handleChildTerminated(ActorCell $this, ActorRef child) {
        ChildrenContainer.Creation x5;
        ChildrenContainer.SuspendReason c;
        Option<ChildrenContainer.SuspendReason> status = $this.removeChildAndGetStateChange(child);
        if ($this.actor() != null) {
            try {
                $this.actor().supervisorStrategy().handleChildTerminated($this, child, $this.children());
            }
            catch (Throwable throwable) {
                Throwable x4 = throwable;
                Option o11 = NonFatal$.MODULE$.unapply(x4);
                if (o11.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)o11.get();
                $this.handleInvokeFailure((Iterable<ActorRef>)Nil$.MODULE$, e, "handleChildTerminated failed");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        boolean rc10 = false;
        Some x2 = null;
        Option<ChildrenContainer.SuspendReason> option = status;
        if (option instanceof Some) {
            ChildrenContainer.Recreation x3;
            ChildrenContainer.SuspendReason c2;
            rc10 = true;
            x2 = (Some)option;
            if (x2 != null && (c2 = (ChildrenContainer.SuspendReason)x2.x()) instanceof ChildrenContainer.Recreation && (x3 = (ChildrenContainer.Recreation)c2) != null) {
                Throwable cause = x3.cause();
                FaultHandling$class.finishRecreate($this, cause, $this.actor());
                return x3.dequeueAll();
            }
        }
        if (rc10 && x2 != null && (c = (ChildrenContainer.SuspendReason)x2.x()) instanceof ChildrenContainer.Creation && (x5 = (ChildrenContainer.Creation)c) != null) {
            FaultHandling$class.finishCreate($this);
            return x5.dequeueAll();
        }
        if (!rc10) return null;
        if (x2 == null) return null;
        ChildrenContainer.SuspendReason p6 = (ChildrenContainer.SuspendReason)x2.x();
        ChildrenContainer$Termination$ childrenContainer$Termination$ = ChildrenContainer$Termination$.MODULE$;
        ChildrenContainer.SuspendReason suspendReason = p6;
        if (childrenContainer$Termination$ == null) {
            if (suspendReason != null) {
                return null;
            }
        } else if (!childrenContainer$Termination$.equals(suspendReason)) return null;
        ChildrenContainer.SuspendReason x8 = p6;
        FaultHandling$class.finishTerminate($this);
        return null;
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(null);
    }
}

