/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.util.KeyStoreException;
import org.apache.commons.io.output.NullOutputStream;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.joda.time.DateTime;

public final class KeyStoreUtil {
    private static final char[] KEYSTORE_PASSPHRASE = "4AD8A8BD-A001-4400-8DAC-5F3B97F07DE5".toCharArray();
    static final String KEYSTORE_KEY_ALIAS = "mykey1";

    private KeyStoreUtil() {
    }

    public static KeyStore createKeyStoreForKeyPair(KeyPair keyPair, String keyStoreProvider, String signatureProvider, String keyStoreType) {
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            keyStore.load(null, KEYSTORE_PASSPHRASE);
            keyStore.aliases();
            X509Certificate certificate = KeyStoreUtil.generateCertificate(keyPair, signatureProvider);
            keyStore.setKeyEntry(KEYSTORE_KEY_ALIAS, keyPair.getPrivate(), KEYSTORE_PASSPHRASE, new Certificate[]{certificate});
            return keyStore;
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(e);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
    }

    public static KeyPair getKeyPairFromKeyStore(byte[] keyStoreData, String keyStoreProvider, String keyStoreType) {
        KeyStore keyStore = KeyStoreUtil.loadKeyStore(keyStoreData, keyStoreProvider, keyStoreType);
        return KeyStoreUtil.getKeyPairFromKeyStore(keyStore);
    }

    public static byte[] storeKeyStore(KeyStore keyStore) {
        ByteArrayOutputStream keyStoreOS = new ByteArrayOutputStream();
        try {
            keyStore.store(keyStoreOS, KEYSTORE_PASSPHRASE);
            keyStoreOS.flush();
            return keyStoreOS.toByteArray();
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(e);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
    }

    public static KeyStore clearKeyStore(byte[] keyStoreData, String keyStoreProvider, String keyStoreType) {
        KeyStore keyStore = KeyStoreUtil.loadKeyStore(keyStoreData, keyStoreProvider, keyStoreType);
        KeyStoreUtil.clearKeyStore(keyStore);
        return keyStore;
    }

    private static KeyStore clearKeyStore(KeyStore keyStore) {
        try {
            if (keyStore.containsAlias(KEYSTORE_KEY_ALIAS)) {
                keyStore.deleteEntry(KEYSTORE_KEY_ALIAS);
                keyStore.store((OutputStream)new NullOutputStream(), KEYSTORE_PASSPHRASE);
            }
            return keyStore;
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(e);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
    }

    private static KeyPair getKeyPairFromKeyStore(KeyStore keyStore) {
        try {
            Certificate certificate = keyStore.getCertificateChain(KEYSTORE_KEY_ALIAS)[0];
            PublicKey publicKey = certificate.getPublicKey();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(KEYSTORE_KEY_ALIAS, KEYSTORE_PASSPHRASE);
            return new KeyPair(publicKey, privateKey);
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(e);
        }
    }

    private static KeyStore loadKeyStore(byte[] keyStoreData, String keyStoreProvider, String keyStoreType) {
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            keyStore.load(new ByteArrayInputStream(keyStoreData), KEYSTORE_PASSPHRASE);
            return keyStore;
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(e);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
    }

    public static X509Certificate generateCertificate(KeyPair keyPair, String signatureProvider) {
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(new X500Principal("CN=issuer"), BigInteger.ONE, new DateTime().minusYears(2).toDate(), new DateTime().minusYears(1).toDate(), new X500Principal("CN=subject"), keyPair.getPublic());
        try {
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA256withRSA").setProvider(signatureProvider).build(keyPair.getPrivate());
            return new JcaX509CertificateConverter().getCertificate(builder.build(sigGen));
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

