/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import grizzled.slf4j.Logger;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.util.Specifications;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.commands.TopDownWalker;
import net.ripe.rpki.validator.fetchers.CachingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ConsistentObjectFetcher;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RemoteObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcherAdapter;
import net.ripe.rpki.validator.fetchers.RsyncRpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ValidatingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidationProcess;
import net.ripe.rpki.validator.models.ValidationProcess$class;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.RepositoryObjectStore;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import net.ripe.rpki.validator.util.UriToFileMapper;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scalaz.Validation;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u00015\u0011A\u0004\u0016:vgR\fen\u00195peZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t\tb+\u00197jI\u0006$\u0018n\u001c8Qe>\u001cWm]:\t\u0011e\u0001!Q1A\u0005Bi\t!\u0003\u001e:vgR\fen\u00195pe2{7-\u0019;peV\t1\u0004\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\t\u0005!Q\u000f^5m\u0013\t\u0001SD\u0001\nUeV\u001cH/\u00118dQ>\u0014Hj\\2bi>\u0014\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002'Q\u0014Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u0011\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\nA\"\\1y'R\fG.\u001a#bsN\u0004\"a\u0004\u0014\n\u0005\u001d\u0002\"aA%oi\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"2a\u000b\u0017.!\t)\u0002\u0001C\u0003\u001aQ\u0001\u00071\u0004C\u0003%Q\u0001\u0007Q\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0019\u0002\u000f=\u0004H/[8ogV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005Y2\u0011aB2p[6|gn]\u0005\u0003qM\u0012\u0011CV1mS\u0012\fG/[8o\u001fB$\u0018n\u001c8t\u0011\u0019Q\u0004\u0001)A\u0005c\u0005Aq\u000e\u001d;j_:\u001c\b\u0005C\u0004=\u0001\t\u0007I\u0011B\u001f\u0002-I\u001b\u0018P\\2ESN\\7)Y2iK\n\u000b7/\u001a)bi\",\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019\u0019FO]5oO\"1q\t\u0001Q\u0001\ny\nqCU:z]\u000e$\u0015n]6DC\u000eDWMQ1tKB\u000bG\u000f\u001b\u0011\t\u000b%\u0003A\u0011\t&\u00023\u0015DHO]1diR\u0013Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u000b\u0002\u0017B\u0011Q\u0003T\u0005\u0003\u001b\n\u0011qBV1mS\u0012\fG/\u001a3PE*,7\r\u001e\u0005\u0006\u001f\u0002!\t\u0005U\u0001\u0010m\u0006d\u0017\u000eZ1uK>\u0013'.Z2ugR\u0011\u0011K\u0018\t\u0005%^K6*D\u0001T\u0015\t!V+A\u0005j[6,H/\u00192mK*\u0011a\u000bE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001-T\u0005\ri\u0015\r\u001d\t\u00035rk\u0011a\u0017\u0006\u0003\u0017\tK!!X.\u0003\u0007U\u0013\u0016\nC\u0003`\u001d\u0002\u0007\u0001-A\u0006dKJ$\u0018NZ5dCR,\u0007CA1e\u001b\u0005\u0011'BA24\u0003Ay'M[3diZ\fG.\u001b3bi>\u00148/\u0003\u0002fE\na3)\u001a:uS\u001aL7-\u0019;f%\u0016\u0004xn]5u_JLxJ\u00196fGR4\u0016\r\\5eCRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006O\u0002!\t\u0001[\u0001\u0013o&\u0004XMU:z]\u000e$\u0015n]6DC\u000eDW\rF\u0001j!\ty!.\u0003\u0002l!\t!QK\\5u\u0011\u0015i\u0007\u0001\"\u0003o\u00035\u0019'/Z1uK\u001a+Go\u00195feR\u0011q.\u001e\t\u0003aNl\u0011!\u001d\u0006\u0003e\u0012\t\u0001BZ3uG\",'o]\u0005\u0003iF\u0014!eQ3si&4\u0017nY1uKJ+\u0007o\\:ji>\u0014\u0018p\u00142kK\u000e$h)\u001a;dQ\u0016\u0014\b\"\u0002<m\u0001\u00049\u0018!\u00037jgR,g.\u001a:t!\ry\u0001P_\u0005\u0003sB\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tYhP\u0004\u0002qy&\u0011Q0]\u0001,\u001d>$\u0018NZ=j]\u001e\u001cUM\u001d;jM&\u001c\u0017\r^3SKB|7/\u001b;pef|%M[3di\u001a+Go\u00195fe&\u0019q0!\u0001\u0003\u00111K7\u000f^3oKJT!!`9\t\u0015\u0005\u0015\u0001\u0001#b!\n\u0013\t9!A\fd_:\u001c\u0018n\u001d;f]R|%M[3di\u001a+Go\u00195feV\u0011\u0011\u0011\u0002\t\u0004a\u0006-\u0011bAA\u0007c\n92i\u001c8tSN$XM\u001c;PE*,7\r\u001e$fi\u000eDWM\u001d\u0005\u000b\u0003#\u0001\u0001\u0012!Q!\n\u0005%\u0011\u0001G2p]NL7\u000f^3oi>\u0013'.Z2u\r\u0016$8\r[3sA\u00191\u0011Q\u0003\u0001\u0005\u0003/\u0011ABU8b\u0007>dG.Z2u_J\u001cB!a\u0005\u0002\u001aA\u001910a\u0007\n\t\u0005u\u0011\u0011\u0001\u0002\u0010\u0019&\u001cH/\u001a8fe\u0006#\u0017\r\u001d;fe\"Q\u0011\u0011EA\n\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u0017Q\u0014Xo\u001d;B]\u000eDwN\u001d\u0005\f\u0003K\t\u0019B!A!\u0002\u0013\t9#A\u0004pE*,7\r^:1\t\u0005%\u0012q\b\t\t\u0003W\t\t$!\u000e\u0002<5\u0011\u0011Q\u0006\u0006\u0004\u0003_)\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0003g\tiCA\u0004Ck&dG-\u001a:\u0011\u000b=\t9$W&\n\u0007\u0005e\u0002C\u0001\u0004UkBdWM\r\t\u0005\u0003{\ty\u0004\u0004\u0001\u0005\u0019\u0005\u0005\u00131EA\u0001\u0002\u0003\u0015\t!a\u0011\u0003\u0007}#\u0013'\u0005\u0003\u0002F\u0005-\u0003cA\b\u0002H%\u0019\u0011\u0011\n\t\u0003\u000f9{G\u000f[5oOB\u0019q\"!\u0014\n\u0007\u0005=\u0003CA\u0002B]fDq!KA\n\t\u0003\t\u0019\u0006\u0006\u0004\u0002V\u0005e\u00131\f\t\u0005\u0003/\n\u0019\"D\u0001\u0001\u0011\u001d\t\t#!\u0015A\u0002mA\u0001\"!\n\u0002R\u0001\u0007\u0011Q\f\u0019\u0005\u0003?\n\u0019\u0007\u0005\u0005\u0002,\u0005E\u0012QGA1!\u0011\ti$a\u0019\u0005\u0019\u0005\u0005\u00131LA\u0001\u0002\u0003\u0015\t!a\u0011\t\u0011\u0005\u001d\u00141\u0003C!\u0003S\n\u0011#\u00194uKJ4U\r^2i\r\u0006LG.\u001e:f)\u0015I\u00171NA8\u0011\u001d\ti'!\u001aA\u0002e\u000b1!\u001e:j\u0011!\t\t(!\u001aA\u0002\u0005M\u0014A\u0002:fgVdG\u000fE\u00023\u0003kJ1!a\u001e4\u0005A1\u0016\r\\5eCRLwN\u001c*fgVdG\u000f\u0003\u0005\u0002|\u0005MA\u0011IA?\u0003E\tg\r^3s\r\u0016$8\r[*vG\u000e,7o\u001d\u000b\bS\u0006}\u0014\u0011QAI\u0011\u001d\ti'!\u001fA\u0002eC\u0001\"a!\u0002z\u0001\u0007\u0011QQ\u0001\u0004_\nT\u0007\u0003BAD\u0003\u001bk!!!#\u000b\u0007\u0005-U'\u0001\u0004def\u0004Ho\\\u0005\u0005\u0003\u001f\u000bIIA\u000eDKJ$\u0018NZ5dCR,'+\u001a9pg&$xN]=PE*,7\r\u001e\u0005\t\u0003c\nI\b1\u0001\u0002t\u0001")
public class TrustAnchorValidationProcess
implements ValidationProcess {
    private final TrustAnchorLocator trustAnchorLocator;
    private final int maxStaleDays;
    private final ValidationOptions options;
    private final String RsyncDiskCacheBasePath;
    private ConsistentObjectFetcher consistentObjectFetcher;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private ConsistentObjectFetcher consistentObjectFetcher$lzycompute() {
        TrustAnchorValidationProcess trustAnchorValidationProcess = this;
        synchronized (trustAnchorValidationProcess) {
            if (!this.bitmap$0) {
                Rsync rsync = new Rsync();
                rsync.setTimeoutInSeconds(300);
                RsyncRpkiRepositoryObjectFetcher rsyncFetcher = new RsyncRpkiRepositoryObjectFetcher(rsync, new UriToFileMapper(new File(new StringBuilder().append((Object)this.RsyncDiskCacheBasePath()).append((Object)this.trustAnchorLocator().getFile().getName()).toString())));
                RemoteObjectFetcher remoteFetcher = new RemoteObjectFetcher(rsyncFetcher);
                this.consistentObjectFetcher = new ConsistentObjectFetcher(remoteFetcher, new RepositoryObjectStore((DataSource)DataSources$.MODULE$.DurableDataSource()));
                this.bitmap$0 = true;
            }
            return this.consistentObjectFetcher;
        }
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void net$ripe$rpki$validator$models$ValidationProcess$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Validation<String, Map<URI, ValidatedObject>> runProcess() {
        return ValidationProcess$class.runProcess(this);
    }

    @Override
    public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
        return ValidationProcess$class.exceptionHandler(this);
    }

    @Override
    public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
        return ValidationProcess$class.objectFetcherListeners(this);
    }

    @Override
    public void finishProcessing() {
        ValidationProcess$class.finishProcessing(this);
    }

    @Override
    public void shutdown() {
        ValidationProcess$class.shutdown(this);
    }

    @Override
    public TrustAnchorLocator trustAnchorLocator() {
        return this.trustAnchorLocator;
    }

    private ValidationOptions options() {
        return this.options;
    }

    private String RsyncDiskCacheBasePath() {
        return this.RsyncDiskCacheBasePath;
    }

    @Override
    public ValidatedObject extractTrustAnchorLocator() {
        InvalidObject invalidObject;
        URI uri = this.trustAnchorLocator().getCertificateLocation();
        ValidationResult validationResult = ValidationResult.withLocation((URI)uri);
        CertificateRepositoryObject cro = this.consistentObjectFetcher().fetch(uri, (Specification<byte[]>)Specifications.alwaysTrue(), validationResult);
        CertificateRepositoryObject certificateRepositoryObject = cro;
        if (certificateRepositoryObject instanceof X509ResourceCertificate) {
            X509ResourceCertificate x509ResourceCertificate = (X509ResourceCertificate)certificateRepositoryObject;
            String string = this.trustAnchorLocator().getPublicKeyInfo();
            String string2 = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)x509ResourceCertificate.getCertificate());
            validationResult.rejectIfFalse(!(string != null ? !string.equals(string2) : string2 != null), "trust.anchor.public.key.match", new String[0]);
            invalidObject = validationResult.hasFailureForCurrentLocation() ? new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet()) : new ValidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet(), (CertificateRepositoryObject)x509ResourceCertificate);
        } else {
            invalidObject = new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet());
        }
        return invalidObject;
    }

    @Override
    public Map<URI, ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate) {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        RoaCollector roaCollector = new RoaCollector(this, this.trustAnchorLocator(), builder);
        CertificateRepositoryObjectFetcher fetcher = this.createFetcher((Seq<NotifyingCertificateRepositoryObjectFetcher.Listener>)((Seq)this.objectFetcherListeners().$plus$colon((Object)roaCollector, Seq$.MODULE$.canBuildFrom())));
        RepositoryObjectStore cache = new RepositoryObjectStore((DataSource)DataSources$.MODULE$.DurableDataSource());
        cache.purgeExpired(this.maxStaleDays);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.trustAnchorLocator().getPrefetchUris()).asScala()).foreach((Function1)new Serializable(this, fetcher){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcess $outer;
            private final CertificateRepositoryObjectFetcher fetcher$1;

            public final void apply(URI prefetchUri) {
                this.$outer.logger().info((Function0)new Serializable(this, prefetchUri){
                    public static final long serialVersionUID = 0L;
                    private final URI prefetchUri$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Prefetching '").append((Object)this.prefetchUri$1).append((Object)"'").toString();
                    }
                    {
                        this.prefetchUri$1 = prefetchUri$1;
                    }
                });
                ValidationResult validationResult = ValidationResult.withLocation((URI)prefetchUri);
                this.fetcher$1.prefetch(prefetchUri, validationResult);
                this.$outer.logger().info((Function0)new Serializable(this, prefetchUri){
                    public static final long serialVersionUID = 0L;
                    private final URI prefetchUri$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Done prefetching for '").append((Object)this.prefetchUri$1).append((Object)"'").toString();
                    }
                    {
                        this.prefetchUri$1 = prefetchUri$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fetcher$1 = fetcher$1;
            }
        });
        TopDownWalker walker = new TopDownWalker(fetcher);
        walker.addTrustAnchor(certificate);
        walker.execute();
        return (Map)builder.result();
    }

    public void wipeRsyncDiskCache() {
        File diskCache = new File(this.RsyncDiskCacheBasePath());
        if (diskCache.isDirectory()) {
            FileUtils.cleanDirectory((File)diskCache);
        }
    }

    private CertificateRepositoryObjectFetcher createFetcher(Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> listeners) {
        ValidatingCertificateRepositoryObjectFetcher validatingFetcher = new ValidatingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)new RpkiRepositoryObjectFetcherAdapter((RpkiRepositoryObjectFetcher)this.consistentObjectFetcher()), this.options());
        NotifyingCertificateRepositoryObjectFetcher notifyingFetcher = new NotifyingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)validatingFetcher);
        CachingCertificateRepositoryObjectFetcher cachingFetcher = new CachingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)notifyingFetcher);
        validatingFetcher.setOuterMostDecorator((CertificateRepositoryObjectFetcher)cachingFetcher);
        listeners.foreach((Function1)new Serializable(this, notifyingFetcher){
            public static final long serialVersionUID = 0L;
            private final NotifyingCertificateRepositoryObjectFetcher notifyingFetcher$1;

            public final void apply(NotifyingCertificateRepositoryObjectFetcher.Listener x$1) {
                this.notifyingFetcher$1.addCallback(x$1);
            }
            {
                this.notifyingFetcher$1 = notifyingFetcher$1;
            }
        });
        return cachingFetcher;
    }

    private ConsistentObjectFetcher consistentObjectFetcher() {
        return this.bitmap$0 ? this.consistentObjectFetcher : this.consistentObjectFetcher$lzycompute();
    }

    public TrustAnchorValidationProcess(TrustAnchorLocator trustAnchorLocator, int maxStaleDays) {
        this.trustAnchorLocator = trustAnchorLocator;
        this.maxStaleDays = maxStaleDays;
        ValidationProcess$class.$init$(this);
        this.options = new ValidationOptions();
        this.RsyncDiskCacheBasePath = "tmp/cache/";
        this.options().setMaxStaleDays(maxStaleDays);
    }

    public class RoaCollector
    extends NotifyingCertificateRepositoryObjectFetcher.ListenerAdapter {
        private final Builder<Tuple2<URI, ValidatedObject>, ?> objects;
        public final /* synthetic */ TrustAnchorValidationProcess $outer;

        public void afterFetchFailure(URI uri, ValidationResult result) {
            this.objects.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)uri), (Object)new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet())));
        }

        public void afterFetchSuccess(URI uri, CertificateRepositoryObject obj, ValidationResult result) {
            this.objects.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)uri), (Object)new ValidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet(), obj)));
        }

        public /* synthetic */ TrustAnchorValidationProcess net$ripe$rpki$validator$models$TrustAnchorValidationProcess$RoaCollector$$$outer() {
            return this.$outer;
        }

        public RoaCollector(TrustAnchorValidationProcess $outer, TrustAnchorLocator trustAnchor, Builder<Tuple2<URI, ValidatedObject>, ?> objects) {
            this.objects = objects;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

