/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.statistics;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import net.ripe.rpki.validator.statistics.Metric;
import org.joda.time.DateTimeUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u001b\tQb*\u001a;x_J\\7i\u001c8oK\u000e$\u0018N^5us6+GO]5dg*\u00111\u0001B\u0001\u000bgR\fG/[:uS\u000e\u001c(BA\u0003\u0007\u0003%1\u0018\r\\5eCR|'O\u0003\u0002\b\u0011\u0005!!\u000f]6j\u0015\tI!\"\u0001\u0003sSB,'\"A\u0006\u0002\u00079,Go\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u00035\u0011X\r]8tSR|'/_+sSB\u0011qcG\u0007\u00021)\u00111\"\u0007\u0006\u00025\u0005!!.\u0019<b\u0013\ta\u0002DA\u0002V%&CQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtDC\u0001\u0011#!\t\t\u0003!D\u0001\u0003\u0011\u0015)R\u00041\u0001\u0017\u0011\u0019!\u0003\u0001)A\u0005K\u00051An\\4hKJ\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003)\n\u0001b\u001a:jujdW\rZ\u0005\u0003Y\u001d\u0012a\u0001T8hO\u0016\u0014\bB\u0002\u0018\u0001A\u0003%q&\u0001\nE\u000b\u001a\u000bU\u000b\u0014+`%NKfjQ0Q\u001fJ#\u0006CA\b1\u0013\t\t\u0004CA\u0002J]RDqa\r\u0001C\u0002\u0013\u0005A'\u0001\u0005i_N$h.Y7f+\u0005)\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u001a\u0003\u0011a\u0017M\\4\n\u0005i:$AB*ue&tw\r\u0003\u0004=\u0001\u0001\u0006I!N\u0001\nQ>\u001cHO\\1nK\u0002BqA\u0010\u0001C\u0002\u0013\u0005q(\u0001\u0003q_J$X#A\u0018\t\r\u0005\u0003\u0001\u0015!\u00030\u0003\u0015\u0001xN\u001d;!\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0003\u001diW\r\u001e:jGN,\u0012!\u0012\t\u0004\r:\u000bfBA$M\u001d\tA5*D\u0001J\u0015\tQE\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011Q\nE\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005KA\u0002TKFT!!\u0014\t\u0011\u0005\u0005\u0012\u0016BA*\u0003\u0005\u0019iU\r\u001e:jG\"1Q\u000b\u0001Q\u0005\nY\u000b!\u0002\u001a8t\u001b\u0016$(/[2t+\u00059\u0006c\u0001-\\#6\t\u0011L\u0003\u0002[!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=K\u0006BB/\u0001A\u0013%a,A\nd_:tWm\u0019;jm&$\u00180T3ue&\u001c7/F\u0001`!\ry\u0001-U\u0005\u0003CB\u0011Q!\u0011:sCfD\u0001b\u0019\u0001\t\u0006\u0004&I\u0001Z\u0001\nC\u0012$'/Z:tKN,\u0012!\u001a\t\u0004\u001f\u00014\u0007CA\fh\u0013\tA\u0007DA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\b\u0002\u00036\u0001\u0011\u0003\u0005\u000b\u0015B3\u0002\u0015\u0005$GM]3tg\u0016\u001c\b\u0005\u0003\u0004m\u0001\u0001&I!\\\u0001\u000biJL8i\u001c8oK\u000e$HCA\u001bo\u0011\u0015y7\u000e1\u0001g\u0003\u001d\tG\r\u001a:fgN\u0004")
public class NetworkConnectivityMetrics {
    public final URI net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$repositoryUri;
    private final Logger logger;
    private final int DEFAULT_RSYNC_PORT;
    private final String hostname;
    private final int port;
    private InetAddress[] addresses;
    private volatile boolean bitmap$0;

    private InetAddress[] addresses$lzycompute() {
        NetworkConnectivityMetrics networkConnectivityMetrics = this;
        synchronized (networkConnectivityMetrics) {
            if (!this.bitmap$0) {
                this.addresses = this.liftedTree1$1();
                this.bitmap$0 = true;
            }
            return this.addresses;
        }
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public Seq<Metric> metrics() {
        Seq seq;
        try {
            seq = (Seq)this.dnsMetrics().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.connectivityMetrics()), Seq$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            this.logger.debug((Function0)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NetworkConnectivityMetrics $outer;
                private final Exception e$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Error checking connectivity to %s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$repositoryUri, this.e$1}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.e$1 = e$1;
                }
            }, (Function0)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metric[]{new Metric(new StringOps(Predef$.MODULE$.augmentString("network.connectivity[%s].exception")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname()})), exception.toString(), DateTimeUtils.currentTimeMillis())}));
        }
        return seq;
    }

    private Seq<Metric> dnsMetrics() {
        long now = DateTimeUtils.currentTimeMillis();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metric[]{new Metric(new StringOps(Predef$.MODULE$.augmentString("network.connectivity[%s].ipv4.count")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname()})), ((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.addresses()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InetAddress x$1) {
                return x$1 instanceof Inet4Address;
            }
        }))).toString(), now), new Metric(new StringOps(Predef$.MODULE$.augmentString("network.connectivity[%s].ipv6.count")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname()})), ((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.addresses()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InetAddress x$2) {
                return x$2 instanceof Inet6Address;
            }
        }))).toString(), now)}));
    }

    private Metric[] connectivityMetrics() {
        return (Metric[])Predef$.MODULE$.refArrayOps((Object[])this.addresses()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NetworkConnectivityMetrics $outer;

            public final Seq<Metric> apply(InetAddress address) {
                long start = DateTimeUtils.currentTimeMillis();
                String status = this.$outer.net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$tryConnect(address);
                long stop = DateTimeUtils.currentTimeMillis();
                long elapsed = stop - start;
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metric[]{new Metric(new StringOps(Predef$.MODULE$.augmentString("network.connectivity[%s].status")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})), status, stop), new Metric(new StringOps(Predef$.MODULE$.augmentString("network.connectivity[%s].elapsed.ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})), ((Object)BoxesRunTime.boxToLong((long)elapsed)).toString(), stop)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Metric.class)));
    }

    private InetAddress[] addresses() {
        return this.bitmap$0 ? this.addresses : this.addresses$lzycompute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$tryConnect(InetAddress address) {
        String string;
        String string2;
        block11: {
            String string3;
            Socket s;
            block10: {
                s = new Socket();
                try {
                    s.setSoTimeout(300000);
                    s.connect(new InetSocketAddress(address, this.port()));
                    string2 = "OK";
                }
                catch (IOException iOException) {
                    try {
                        string3 = iOException.toString();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            s.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
                try {
                    s.close();
                    break block11;
                }
                catch (IOException iOException) {}
            }
            String string4 = string3;
            try {
                s.close();
            }
            catch (IOException iOException) {}
            string = string4;
            return string;
        }
        string = string2;
        return string;
    }

    private final InetAddress[] liftedTree1$1() {
        InetAddress[] inetAddressArray;
        try {
            inetAddressArray = InetAddress.getAllByName(this.hostname());
        }
        catch (UnknownHostException unknownHostException) {
            inetAddressArray = (InetAddress[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InetAddress.class));
        }
        return inetAddressArray;
    }

    public NetworkConnectivityMetrics(URI repositoryUri) {
        this.net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$repositoryUri = repositoryUri;
        this.logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(NetworkConnectivityMetrics.class));
        this.DEFAULT_RSYNC_PORT = 873;
        this.hostname = repositoryUri.getHost();
        this.port = repositoryUri.getPort() == -1 ? this.DEFAULT_RSYNC_PORT : repositoryUri.getPort();
    }
}

