/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.testing;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsObjectMother;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.IgnoreFilter;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObjects;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class TestingObjectMother$ {
    public static final TestingObjectMother$ MODULE$;
    private final Asn ASN1;
    private final Asn ASN2;
    private final Asn ASN3;
    private final RoaPrefix ROA_PREFIX_V4_1;
    private final RoaPrefix ROA_PREFIX_V4_2;
    private final RoaPrefix ROA_PREFIX_V6_1;
    private final IpRange WHITELIST_PREFIX_1;
    private final IpRange UNUSED_PREFIX_FOR_FILTER;
    private final TrustAnchorLocator TAL;
    private final RtrPrefix ASN1_TO_ROA_PREFIX_V4_1;
    private final RtrPrefix ASN1_TO_ROA_PREFIX_V4_2;
    private final RtrPrefix ASN1_TO_ROA_PREFIX_V6_1;
    private final RtrPrefix ASN2_TO_ROA_PREFIX_V4_1;
    private final RtrPrefix ASN3_TO_WHITELIST1;

    static {
        new TestingObjectMother$();
    }

    public Asn ASN1() {
        return this.ASN1;
    }

    public Asn ASN2() {
        return this.ASN2;
    }

    public Asn ASN3() {
        return this.ASN3;
    }

    public RoaPrefix ROA_PREFIX_V4_1() {
        return this.ROA_PREFIX_V4_1;
    }

    public RoaPrefix ROA_PREFIX_V4_2() {
        return this.ROA_PREFIX_V4_2;
    }

    public RoaPrefix ROA_PREFIX_V6_1() {
        return this.ROA_PREFIX_V6_1;
    }

    public IpRange WHITELIST_PREFIX_1() {
        return this.WHITELIST_PREFIX_1;
    }

    public IpRange UNUSED_PREFIX_FOR_FILTER() {
        return this.UNUSED_PREFIX_FOR_FILTER;
    }

    public TrustAnchorLocator TAL() {
        return this.TAL;
    }

    public RtrPrefix ASN1_TO_ROA_PREFIX_V4_1() {
        return this.ASN1_TO_ROA_PREFIX_V4_1;
    }

    public RtrPrefix ASN1_TO_ROA_PREFIX_V4_2() {
        return this.ASN1_TO_ROA_PREFIX_V4_2;
    }

    public RtrPrefix ASN1_TO_ROA_PREFIX_V6_1() {
        return this.ASN1_TO_ROA_PREFIX_V6_1;
    }

    public RtrPrefix ASN2_TO_ROA_PREFIX_V4_1() {
        return this.ASN2_TO_ROA_PREFIX_V4_1;
    }

    public RtrPrefix ASN3_TO_WHITELIST1() {
        return this.ASN3_TO_WHITELIST1;
    }

    public ValidatedObjects ROAS() {
        List prefixes1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RoaPrefix[]{this.ROA_PREFIX_V4_1(), this.ROA_PREFIX_V6_1(), this.ROA_PREFIX_V6_1()}));
        List prefixes2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RoaPrefix[]{this.ROA_PREFIX_V4_1()}));
        List prefixes3 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RoaPrefix[]{this.ROA_PREFIX_V4_1(), this.ROA_PREFIX_V4_2()}));
        ValidityPeriod validityPeriod = new ValidityPeriod((ReadableInstant)new DateTime(), (ReadableInstant)new DateTime().plusYears(1));
        RoaCms roa1 = RoaCmsObjectMother.getRoaCms((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)prefixes1).asJava()), (ValidityPeriod)validityPeriod, (Asn)this.ASN1());
        URI roa1Uri = URI.create("rsync://example.com/roa1.roa");
        ValidObject validatedRoa1 = new ValidObject(roa1Uri, Predef$.MODULE$.Set().empty(), (CertificateRepositoryObject)roa1);
        RoaCms roa2 = RoaCmsObjectMother.getRoaCms((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)prefixes2).asJava()), (ValidityPeriod)validityPeriod, (Asn)this.ASN2());
        URI roa2Uri = URI.create("rsync://example.com/roa2.roa");
        ValidObject validatedRoa2 = new ValidObject(roa2Uri, Predef$.MODULE$.Set().empty(), (CertificateRepositoryObject)roa2);
        RoaCms roa3 = RoaCmsObjectMother.getRoaCms((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)prefixes3).asJava()), (ValidityPeriod)validityPeriod, (Asn)this.ASN1());
        URI roa3Uri = URI.create("rsync://example.com/roa3.roa");
        ValidObject validatedRoa3 = new ValidObject(roa3Uri, Predef$.MODULE$.Set().empty(), (CertificateRepositoryObject)roa3);
        Seq roas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidObject[]{validatedRoa1, validatedRoa2, validatedRoa3}));
        return new ValidatedObjects((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.TAL()), (Object)roas)})));
    }

    public Filters FILTERS() {
        return new Filters((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IgnoreFilter[]{new IgnoreFilter(this.ROA_PREFIX_V6_1().getPrefix())})));
    }

    public Whitelist WHITELIST() {
        return new Whitelist((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.ASN3_TO_WHITELIST1()})));
    }

    private TestingObjectMother$() {
        MODULE$ = this;
        this.ASN1 = new Asn(65000L);
        this.ASN2 = new Asn(65001L);
        this.ASN3 = new Asn(65003L);
        this.ROA_PREFIX_V4_1 = new RoaPrefix(IpRange.parse((String)"10.64.0.0/12"), Predef$.MODULE$.int2Integer(24));
        this.ROA_PREFIX_V4_2 = new RoaPrefix(IpRange.parse((String)"10.32.0.0/12"), null);
        this.ROA_PREFIX_V6_1 = new RoaPrefix(IpRange.parse((String)"2001:0:200::/39"), null);
        this.WHITELIST_PREFIX_1 = IpRange.parse((String)"10.0.0.0/8");
        this.UNUSED_PREFIX_FOR_FILTER = IpRange.parse((String)"192.168.1.0/24");
        File file = new File("/tmp");
        String caName = "test ca";
        URI location = URI.create("rsync://example.com/");
        String publicKeyInfo = "info";
        ArrayList prefetchUris = new ArrayList();
        this.TAL = new TrustAnchorLocator(file, caName, location, publicKeyInfo, prefetchUris);
        this.ASN1_TO_ROA_PREFIX_V4_1 = new RtrPrefix(this.ASN1(), this.ROA_PREFIX_V4_1().getPrefix(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.ROA_PREFIX_V4_1().getMaximumLength()))), (Option)new Some((Object)this.TAL()));
        this.ASN1_TO_ROA_PREFIX_V4_2 = new RtrPrefix(this.ASN1(), this.ROA_PREFIX_V4_2().getPrefix(), (Option)None$.MODULE$, (Option)new Some((Object)this.TAL()));
        this.ASN1_TO_ROA_PREFIX_V6_1 = new RtrPrefix(this.ASN1(), this.ROA_PREFIX_V6_1().getPrefix(), (Option)None$.MODULE$, (Option)new Some((Object)this.TAL()));
        this.ASN2_TO_ROA_PREFIX_V4_1 = new RtrPrefix(this.ASN2(), this.ROA_PREFIX_V4_1().getPrefix(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.ROA_PREFIX_V4_1().getMaximumLength()))), (Option)new Some((Object)this.TAL()));
        this.ASN3_TO_WHITELIST1 = new RtrPrefix(this.ASN3(), this.WHITELIST_PREFIX_1(), (Option)None$.MODULE$, (Option)new Some((Object)this.TAL()));
    }
}

