/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.store;

import akka.util.ByteString$;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.Timestamp;
import javax.sql.DataSource;
import net.ripe.rpki.validator.models.StoredRepositoryObject;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u00015\u0011QCU3q_NLGo\u001c:z\u001f\nTWm\u0019;Ti>\u0014XM\u0003\u0002\u0004\t\u0005)1\u000f^8sK*\u0011QAB\u0001\nm\u0006d\u0017\u000eZ1u_JT!a\u0002\u0005\u0002\tI\u00048.\u001b\u0006\u0003\u0013)\tAA]5qK*\t1\"A\u0002oKR\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u000bI\u0006$\u0018m]8ve\u000e,\u0007CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u00027\u0005)!.\u0019<bq&\u0011Q\u0004\u0007\u0002\u000b\t\u0006$\u0018mU8ve\u000e,\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"GA\u0011!\u0005A\u0007\u0002\u0005!)QC\ba\u0001-!9Q\u0005\u0001b\u0001\n\u00031\u0013\u0001\u0003;f[Bd\u0017\r^3\u0016\u0003\u001d\u0002\"\u0001K\u0019\u000e\u0003%R!AK\u0016\u0002\t\r|'/\u001a\u0006\u0003Y5\nAA\u001b3cG*\u0011afL\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001'A\u0002pe\u001eL!AM\u0015\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\t\rQ\u0002\u0001\u0015!\u0003(\u0003%!X-\u001c9mCR,\u0007\u0005C\u00037\u0001\u0011\u0005q'A\u0002qkR$\"\u0001O\u001e\u0011\u0005=I\u0014B\u0001\u001e\u0011\u0005\u0011)f.\u001b;\t\u000bq*\u0004\u0019A\u001f\u0002\u001fI,GO]5fm\u0016$wJ\u00196fGR\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u0003\u0002\r5|G-\u001a7t\u0013\t\u0011uH\u0001\fTi>\u0014X\r\u001a*fa>\u001c\u0018\u000e^8ss>\u0013'.Z2u\u0011\u00151\u0004\u0001\"\u0001E)\tAT\tC\u0003G\u0007\u0002\u0007q)\u0001\tsKR\u0014\u0018.\u001a<fI>\u0013'.Z2ugB\u0019\u0001\nU\u001f\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'\r\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002P!\u00059\u0001/Y2lC\u001e,\u0017BA)S\u0005\r\u0019V-\u001d\u0006\u0003\u001fBAQ\u0001\u0016\u0001\u0005\u0002U\u000bA\u0002];sO\u0016,\u0005\u0010]5sK\u0012$\"\u0001\u000f,\t\u000f]\u001b\u0006\u0013!a\u00011\u0006aQ.\u0019=Ti\u0006dW\rR1zgB\u0011q\"W\u0005\u00035B\u00111!\u00138u\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u0015\u0019G.Z1s)\u0005A\u0004\"B0\u0001\t\u0003\u0001\u0017AD4fi2\u000bG/Z:u\u0005f,&\u000f\u001c\u000b\u0003C\u0012\u00042a\u00042>\u0013\t\u0019\u0007C\u0001\u0004PaRLwN\u001c\u0005\u0006Kz\u0003\rAZ\u0001\u0004kJd\u0007CA4l\u001b\u0005A'BA\u0006j\u0015\u0005Q\u0017\u0001\u00026bm\u0006L!\u0001\u001c5\u0003\u0007U\u0013\u0016\nC\u0003o\u0001\u0011\u0005q.A\u0005hKR\u0014\u0015\u0010S1tQR\u0011\u0011\r\u001d\u0005\u0006c6\u0004\rA]\u0001\u0005Q\u0006\u001c\b\u000eE\u0002\u0010gVL!\u0001\u001e\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=1\u0018BA<\u0011\u0005\u0011\u0011\u0015\u0010^3\t\u000be\u0004A\u0011\u0002>\u0002#\u001d,Go\u00149uS>t\u0017\r\u001c*fgVdG\u000f\u0006\u0003bw\u0006%\u0001\"\u0002?y\u0001\u0004i\u0018\u0001D:fY\u0016\u001cGo\u0015;sS:<\u0007c\u0001@\u0002\u00049\u0011qb`\u0005\u0004\u0003\u0003\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0005\u001d!AB*ue&twMC\u0002\u0002\u0002AAq!a\u0003y\u0001\u0004\ti!\u0001\u0006tK2,7\r^!sON\u0004BaD:\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016%\fA\u0001\\1oO&!\u0011\u0011DA\n\u0005\u0019y%M[3di\u001a1\u0011Q\u0004\u0001\u0005\u0003?\u0011!c\u0015;pe\u0016$wJ\u00196fGRl\u0015\r\u001d9feN1\u00111DA\b\u0003C\u0001B\u0001KA\u0012{%\u0019\u0011QE\u0015\u0003\u0013I{w/T1qa\u0016\u0014\bbB\u0010\u0002\u001c\u0011\u0005\u0011\u0011\u0006\u000b\u0003\u0003W\u0001B!!\f\u0002\u001c5\t\u0001\u0001\u0003\u0005\u00022\u0005mA\u0011IA\u001a\u0003\u0019i\u0017\r\u001d*poR)Q(!\u000e\u0002D!A\u0011qGA\u0018\u0001\u0004\tI$\u0001\u0002sgB!\u00111HA \u001b\t\tiD\u0003\u0002\u001aS&!\u0011\u0011IA\u001f\u0005%\u0011Vm];miN+G\u000fC\u0004\u0002F\u0005=\u0002\u0019\u0001-\u0002\rI|wOT;n\u0011%\tI\u0005AI\u0001\n\u0003\tY%\u0001\fqkJ<W-\u0012=qSJ,G\r\n3fM\u0006,H\u000e\u001e\u00132+\t\tiEK\u0002Y\u0003\u001fZ#!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037\u0002\u0012AC1o]>$\u0018\r^5p]&!\u0011qLA+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RepositoryObjectStore {
    private final JdbcTemplate template;

    public JdbcTemplate template() {
        return this.template;
    }

    public void put(StoredRepositoryObject retrievedObject) {
        Long updateOrder = Predef$.MODULE$.long2Long(this.template().queryForLong("SELECT NEXTVAL('update_order_seq')"));
        try {
            this.template().update("insert into retrieved_objects (hash, uri, encoded_object, expires, update_order) values (?, ?, ?, ?, ?)", new Object[]{Base64.encodeBase64String((byte[])((byte[])retrievedObject.hash().toArray(ClassTag$.MODULE$.Byte()))), retrievedObject.uri().toString(), Base64.encodeBase64String((byte[])((byte[])retrievedObject.binaryObject().toArray(ClassTag$.MODULE$.Byte()))), new Timestamp(retrievedObject.expires().getMillis()), updateOrder});
        }
        catch (DuplicateKeyException duplicateKeyException) {
            this.template().update("update retrieved_objects set update_order = ? where hash = ?", new Object[]{updateOrder, Base64.encodeBase64String((byte[])((byte[])retrievedObject.hash().toArray(ClassTag$.MODULE$.Byte())))});
        }
    }

    public void put(Seq<StoredRepositoryObject> retrievedObjects) {
        retrievedObjects.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoryObjectStore $outer;

            public final void apply(StoredRepositoryObject x$1) {
                this.$outer.put(x$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void purgeExpired(int maxStaleDays) {
        DateTime mustBeValidAfter = new DateTime().minusDays(maxStaleDays);
        this.template().update("delete from retrieved_objects where expires < ?", new Object[]{new Timestamp(mustBeValidAfter.getMillis())});
    }

    public int purgeExpired$default$1() {
        return 0;
    }

    public void clear() {
        this.template().update("truncate table retrieved_objects");
    }

    public Option<StoredRepositoryObject> getLatestByUrl(URI url) {
        String selectString = "select * from retrieved_objects where uri = ? order by update_order desc limit 1";
        Object[] selectArgs = new Object[]{url.toString()};
        return this.getOptionalResult(selectString, selectArgs);
    }

    public Option<StoredRepositoryObject> getByHash(byte[] hash) {
        String encodedHash = Base64.encodeBase64String((byte[])hash);
        String selectString = "select * from retrieved_objects where hash = ?";
        Object[] selectArgs = new Object[]{encodedHash};
        return this.getOptionalResult(selectString, selectArgs);
    }

    private Option<StoredRepositoryObject> getOptionalResult(String selectString, Object[] selectArgs) {
        Some some;
        try {
            some = new Some(this.template().queryForObject(selectString, selectArgs, (RowMapper)new StoredObjectMapper()));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public RepositoryObjectStore(DataSource datasource) {
        this.template = new JdbcTemplate(datasource);
    }

    public class StoredObjectMapper
    implements RowMapper<StoredRepositoryObject> {
        public StoredRepositoryObject mapRow(ResultSet rs, int rowNum) {
            return new StoredRepositoryObject(ByteString$.MODULE$.apply(Base64.decodeBase64((String)rs.getString("hash"))), URI.create(rs.getString("uri")), ByteString$.MODULE$.apply(Base64.decodeBase64((String)rs.getString("encoded_object"))), new DateTime((Object)rs.getTimestamp("expires")).withZone(DateTimeZone.UTC));
        }

        public /* synthetic */ RepositoryObjectStore net$ripe$rpki$validator$store$RepositoryObjectStore$StoredObjectMapper$$$outer() {
            return RepositoryObjectStore.this;
        }

        public StoredObjectMapper() {
            if (RepositoryObjectStore.this == null) {
                throw new NullPointerException();
            }
        }
    }
}

