/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.GhostbustersRecord;
import net.ripe.rpki.commons.crypto.UnknownCertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator.models.StoredRepositoryObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;

public final class StoredRepositoryObject$
implements Serializable {
    public static final StoredRepositoryObject$ MODULE$;

    static {
        new StoredRepositoryObject$();
    }

    public StoredRepositoryObject apply(URI uri, CertificateRepositoryObject repositoryObject) {
        CertificateRepositoryObject certificateRepositoryObject;
        block7: {
            DateTime dateTime;
            ByteString hash;
            ByteString binaryObject;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                binaryObject = ByteString$.MODULE$.apply(repositoryObject.getEncoded());
                                hash = ByteString$.MODULE$.apply(ManifestCms.hashContents((byte[])repositoryObject.getEncoded()));
                                certificateRepositoryObject = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])repositoryObject.getEncoded(), (ValidationResult)ValidationResult.withLocation((URI)uri));
                                if (!(certificateRepositoryObject instanceof X509ResourceCertificate)) break block2;
                                X509ResourceCertificate x509ResourceCertificate = (X509ResourceCertificate)certificateRepositoryObject;
                                dateTime = x509ResourceCertificate.getValidityPeriod().getNotValidAfter();
                                break block3;
                            }
                            if (!(certificateRepositoryObject instanceof ManifestCms)) break block4;
                            ManifestCms manifestCms = (ManifestCms)certificateRepositoryObject;
                            dateTime = manifestCms.getNotValidAfter();
                            break block3;
                        }
                        if (!(certificateRepositoryObject instanceof RoaCms)) break block5;
                        RoaCms roaCms = (RoaCms)certificateRepositoryObject;
                        dateTime = roaCms.getValidityPeriod().getNotValidAfter();
                        break block3;
                    }
                    if (!(certificateRepositoryObject instanceof X509Crl)) break block6;
                    X509Crl x509Crl = (X509Crl)certificateRepositoryObject;
                    dateTime = x509Crl.getNextUpdateTime();
                    break block3;
                }
                boolean bl = certificateRepositoryObject instanceof GhostbustersRecord ? true : certificateRepositoryObject instanceof UnknownCertificateRepositoryObject;
                if (!bl) break block7;
                dateTime = new DateTime(DateTimeZone.UTC).plusDays(1);
            }
            DateTime expires = dateTime;
            return new StoredRepositoryObject(hash, uri, binaryObject, expires);
        }
        throw new MatchError((Object)certificateRepositoryObject);
    }

    public StoredRepositoryObject apply(ByteString hash, URI uri, ByteString binaryObject, DateTime expires) {
        return new StoredRepositoryObject(hash, uri, binaryObject, expires);
    }

    public Option<Tuple4<ByteString, URI, ByteString, DateTime>> unapply(StoredRepositoryObject x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.hash(), (Object)x$0.uri(), (Object)x$0.binaryObject(), (Object)x$0.expires()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StoredRepositoryObject$() {
        MODULE$ = this;
    }
}

