/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.util;

import java.io.File;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.cli.CommandLineOptions;
import net.ripe.rpki.validator.runtimeproblems.ValidatorIOException;
import net.ripe.rpki.validator.util.CertificateRepositoryObjectLocalFileHelper;
import net.ripe.rpki.validator.util.TrustAnchorExtractorException;
import net.ripe.rpki.validator.util.TrustAnchorLocator;

public class TrustAnchorExtractor {
    private final Rsync rsync;

    public TrustAnchorExtractor() {
        this(new Rsync());
    }

    public TrustAnchorExtractor(Rsync rsync) {
        this.rsync = rsync;
    }

    public List<CertificateRepositoryObjectValidationContext> extractTAS(CommandLineOptions options) {
        return this.extractTAS(options.getTrustAnchorFiles(), options.getOutputDir().getAbsolutePath());
    }

    public List<CertificateRepositoryObjectValidationContext> extractTAS(List<TrustAnchorLocator> list, String rootCertificateOutputDir) {
        ArrayList<CertificateRepositoryObjectValidationContext> tas = new ArrayList<CertificateRepositoryObjectValidationContext>();
        for (TrustAnchorLocator tal : list) {
            tas.add(this.extractTA(tal, rootCertificateOutputDir));
        }
        return tas;
    }

    public CertificateRepositoryObjectValidationContext extractTA(TrustAnchorLocator tal, String rootCertificateOutputDir) {
        X509ResourceCertificate cert = this.getRemoteCertificate(tal, rootCertificateOutputDir);
        this.verifyTrustAnchor(tal, cert);
        return new CertificateRepositoryObjectValidationContext(tal.getCertificateLocation(), cert);
    }

    private void verifyTrustAnchor(TrustAnchorLocator tal, X509ResourceCertificate resourceCertificate) {
        String encodedSubjectPublicKeyInfo;
        try {
            encodedSubjectPublicKeyInfo = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)resourceCertificate.getCertificate());
        }
        catch (Exception e) {
            throw new TrustAnchorExtractorException("Problem parsing remote Trust Anchor certificate", e);
        }
        if (!encodedSubjectPublicKeyInfo.equals(tal.getPublicKeyInfo())) {
            throw new TrustAnchorExtractorException("Remote Trust Anchor does not match public key mentioned in TAL");
        }
    }

    private X509ResourceCertificate getRemoteCertificate(TrustAnchorLocator tal, String rootCertificateOutputDir) {
        this.rsync.reset();
        this.rsync.setSource(tal.getCertificateLocation().toString());
        String targetDirectoryPath = rootCertificateOutputDir;
        File targetDirectory = new File(targetDirectoryPath);
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        String dest = targetDirectoryPath + "/" + tal.getFile().getName() + ".cer";
        this.rsync.setDestination(dest);
        int exitStatus = this.rsync.execute();
        switch (exitStatus) {
            case 0: {
                return CertificateRepositoryObjectLocalFileHelper.readCertificate(new File(dest));
            }
        }
        throw new ValidatorIOException("rsync failed while retrieving remote certificate from '" + tal.getCertificateLocation() + "': exit status: " + exitStatus);
    }
}

