/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.commands;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.commands.SingleObjectWalker;
import net.ripe.rpki.validator.fetchers.CachingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcherAdapter;
import net.ripe.rpki.validator.fetchers.RsyncRpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ValidatingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.output.ObjectFetcherResultLogger;
import net.ripe.rpki.validator.runtimeproblems.ValidatorIOException;
import net.ripe.rpki.validator.util.UriToFileMapper;
import org.apache.commons.io.FileUtils;

public class BottomUpCertificateRepositoryObjectValidator {
    private CertificateRepositoryObjectFetcher chainBuildFetcher;
    private CertificateRepositoryObjectFetcher validationFetcher;
    private CachingCertificateRepositoryObjectFetcher cachingFetcher;
    private SingleObjectWalker singleObjectWalker;
    private ObjectFetcherResultLogger chainBuildResultLogger = new ObjectFetcherResultLogger(false);
    private File tempDir = this.getUniqueTempDir();
    private List<CertificateRepositoryObjectValidationContext> trustAnchors;

    public BottomUpCertificateRepositoryObjectValidator(List<CertificateRepositoryObjectValidationContext> trustAnchors, CertificateRepositoryObject startingPoint, URI startingPointUri) {
        this.wireUpFetcherForChainBuilding();
        this.wireUpFetcherForValidation();
        this.cachingFetcher.updateCache(startingPointUri, startingPoint);
        this.singleObjectWalker = new SingleObjectWalker(startingPoint, startingPointUri, this.chainBuildFetcher, this.chainBuildResultLogger, this.validationFetcher);
        this.trustAnchors = trustAnchors;
    }

    File getTempDirectory() {
        return this.tempDir;
    }

    public ValidationResult validate() {
        ValidationResult result = this.singleObjectWalker.execute(this.trustAnchors);
        try {
            FileUtils.deleteDirectory((File)this.tempDir);
            return result;
        }
        catch (IOException e) {
            throw new ValidatorIOException("Could not delete temp directory: " + this.tempDir, e);
        }
    }

    private void wireUpFetcherForValidation() {
        ValidatingCertificateRepositoryObjectFetcher validatingCertificateRepositoryObjectFetcher = new ValidatingCertificateRepositoryObjectFetcher(this.cachingFetcher);
        NotifyingCertificateRepositoryObjectFetcher notifyingCertificateRepositoryObjectFetcher = new NotifyingCertificateRepositoryObjectFetcher(validatingCertificateRepositoryObjectFetcher);
        notifyingCertificateRepositoryObjectFetcher.addCallback(new ObjectFetcherResultLogger());
        CachingCertificateRepositoryObjectFetcher cachingCertificateRepositoryObjectFetcher = new CachingCertificateRepositoryObjectFetcher(notifyingCertificateRepositoryObjectFetcher);
        validatingCertificateRepositoryObjectFetcher.setOuterMostDecorator(cachingCertificateRepositoryObjectFetcher);
        this.validationFetcher = cachingCertificateRepositoryObjectFetcher;
    }

    private void wireUpFetcherForChainBuilding() {
        RpkiRepositoryObjectFetcherAdapter rsyncCertificateRepositoryObjectFetcher = new RpkiRepositoryObjectFetcherAdapter(new RsyncRpkiRepositoryObjectFetcher(new Rsync(), new UriToFileMapper(this.tempDir)));
        CachingCertificateRepositoryObjectFetcher cachingCertificateRepositoryObjectFetcher = new CachingCertificateRepositoryObjectFetcher(rsyncCertificateRepositoryObjectFetcher);
        NotifyingCertificateRepositoryObjectFetcher notifyingCertificateRepositoryObjectFetcher = new NotifyingCertificateRepositoryObjectFetcher(cachingCertificateRepositoryObjectFetcher);
        notifyingCertificateRepositoryObjectFetcher.addCallback(this.chainBuildResultLogger);
        this.cachingFetcher = cachingCertificateRepositoryObjectFetcher;
        this.chainBuildFetcher = notifyingCertificateRepositoryObjectFetcher;
    }

    private File getUniqueTempDir() {
        File tmpDirBase = new File(System.getProperty("java.io.tmpdir"));
        File uniqueDir = null;
        try {
            File createTempFile = File.createTempFile("val", null);
            String randomDirName = createTempFile.getName();
            createTempFile.delete();
            uniqueDir = new File(tmpDirBase + File.separator + randomDirName);
            uniqueDir.mkdir();
            return uniqueDir;
        }
        catch (IOException e) {
            throw new ValidatorIOException("Could not create temp directory", e);
        }
    }

    void setSingleObjectWalker(SingleObjectWalker singleObjectWalker) {
        this.singleObjectWalker = singleObjectWalker;
    }
}

