/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource.etree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ripe.ipresource.etree.ChildNodeMap;
import net.ripe.ipresource.etree.ChildNodeTreeMap;
import net.ripe.ipresource.etree.InternalNode;
import net.ripe.ipresource.etree.IntervalMap;
import net.ripe.ipresource.etree.IntervalStrategy;
import org.apache.commons.lang.Validate;

public final class NestedIntervalMap<K, V>
implements IntervalMap<K, V> {
    private final ChildNodeMap<K, V> children;
    private final IntervalStrategy<K> strategy;

    public NestedIntervalMap(IntervalStrategy<K> strategy) {
        this.strategy = strategy;
        this.children = new ChildNodeTreeMap(strategy);
    }

    public NestedIntervalMap(NestedIntervalMap<K, V> source, IntervalStrategy<K> strategy) {
        this.strategy = strategy;
        this.children = new ChildNodeTreeMap<K, V>(source.children, strategy);
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public void put(K key, V value) {
        Validate.notNull(key);
        Validate.notNull(value);
        this.children.addChild(new InternalNode<K, V>(key, value), this.strategy);
    }

    @Override
    public void remove(K key) {
        Validate.notNull(key);
        this.children.removeChild(key, this.strategy);
    }

    @Override
    public void remove(K key, V value) {
        Validate.notNull(key);
        Validate.notNull(value);
        if (value.equals(this.findExact(key))) {
            this.remove(key);
        }
    }

    @Override
    public V findFirstLessSpecific(K key) {
        Validate.notNull(key);
        InternalNode<K, V> node = this.internalFindFirstLessSpecific(key);
        return this.mapToValue(node);
    }

    @Override
    public List<V> findAllLessSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindAllLessSpecific(key));
    }

    @Override
    public List<V> findExactAndAllLessSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindExactAndAllLessSpecific(key));
    }

    @Override
    public V findExact(K key) {
        Validate.notNull(key);
        InternalNode<K, V> node = this.internalFindExact(key);
        return node == null ? null : (V)node.getValue();
    }

    @Override
    public V findExactOrFirstLessSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValue(this.internalFindExactOrFirstLessSpecific(key));
    }

    @Override
    public List<V> findFirstMoreSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindFirstMoreSpecific(key));
    }

    @Override
    public List<V> findAllMoreSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindAllMoreSpecific(key));
    }

    @Override
    public List<V> findExactAndAllMoreSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindExactAndAllMoreSpecific(key));
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.children.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedIntervalMap that = (NestedIntervalMap)obj;
        return this.children.equals(that.children);
    }

    public String toString() {
        return this.children.toString();
    }

    private V mapToValue(InternalNode<K, V> node) {
        return node == null ? null : (V)node.getValue();
    }

    private List<V> mapToValues(Collection<InternalNode<K, V>> nodes) {
        ArrayList<V> result = new ArrayList<V>(nodes.size());
        for (InternalNode<K, V> node : nodes) {
            result.add(node.getValue());
        }
        return result;
    }

    private InternalNode<K, V> internalFindExactOrFirstLessSpecific(K range) {
        List<InternalNode<K, V>> list = this.internalFindExactAndAllLessSpecific(range);
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private InternalNode<K, V> internalFindFirstLessSpecific(K range) {
        List<InternalNode<K, V>> list = this.internalFindAllLessSpecific(range);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private List<InternalNode<K, V>> internalFindAllLessSpecific(K range) {
        List<InternalNode<K, V>> result = this.internalFindExactAndAllLessSpecific(range);
        if (result.isEmpty()) {
            return result;
        }
        InternalNode<K, V> last = result.get(result.size() - 1);
        if (last.getKey().equals(range)) {
            return result.subList(0, result.size() - 1);
        }
        return result;
    }

    private List<InternalNode<K, V>> internalFindExactAndAllLessSpecific(K range) {
        ArrayList result = new ArrayList();
        this.children.findExactAndAllLessSpecific(result, range, this.strategy);
        return result;
    }

    private InternalNode<K, V> internalFindExact(K range) {
        List<InternalNode<K, V>> exactAndAllLessSpecific = this.internalFindExactAndAllLessSpecific(range);
        if (exactAndAllLessSpecific.isEmpty()) {
            return null;
        }
        InternalNode<K, V> last = exactAndAllLessSpecific.get(exactAndAllLessSpecific.size() - 1);
        if (last.getKey().equals(range)) {
            return last;
        }
        return null;
    }

    private List<InternalNode<K, V>> internalFindFirstMoreSpecific(K range) {
        ArrayList result = new ArrayList();
        InternalNode<K, V> container = this.internalFindExactOrFirstLessSpecific(range);
        if (container == null) {
            this.children.findFirstMoreSpecific(result, range, this.strategy);
        } else {
            container.getChildren().findFirstMoreSpecific(result, range, this.strategy);
        }
        return result;
    }

    private List<InternalNode<K, V>> internalFindAllMoreSpecific(K range) {
        List<InternalNode<K, V>> result = this.internalFindExactAndAllMoreSpecific(range);
        if (!result.isEmpty() && result.get(0).getKey().equals(range)) {
            return result.subList(1, result.size());
        }
        return result;
    }

    private List<InternalNode<K, V>> internalFindExactAndAllMoreSpecific(K range) {
        ArrayList result = new ArrayList();
        InternalNode<K, V> containing = this.internalFindExactOrFirstLessSpecific(range);
        if (containing == null) {
            this.children.findExactAndAllMoreSpecific(result, range, this.strategy);
        } else {
            if (containing.getKey().equals(range)) {
                result.add(containing);
            }
            containing.getChildren().findExactAndAllMoreSpecific(result, range, this.strategy);
        }
        return result;
    }

    public static abstract class Key<K extends IntervalStrategy<K>> {
        private final K key;

        public Key(K key) {
            Validate.notNull(key);
            this.key = key;
        }

        public K getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key that = (Key)obj;
            return this.key.equals(that.key);
        }

        public String toString() {
            return "IpResource(" + this.key + ")";
        }
    }
}

