/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.postgresql;

import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.StringUtils;

public class PostgreSQLSqlScript
extends SqlScript {
    public PostgreSQLSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        super(sqlScriptSource, placeholderReplacer);
    }

    protected String changeDelimiterIfNecessary(String statement, String line, String delimiter) {
        String upperCaseStatement = statement.toUpperCase();
        if (upperCaseStatement.startsWith("CREATE") && upperCaseStatement.contains("FUNCTION") && upperCaseStatement.matches(".* AS \\$[A-Z0-9_]*\\$.*")) {
            if (upperCaseStatement.matches(".* AS \\$[A-Z0-9_]*\\$.*\\$[A-Z0-9_]*\\$.*")) {
                return ";";
            }
            return null;
        }
        return delimiter;
    }

    protected boolean endsWithOpenMultilineStringLiteral(String statement) {
        int numQuotes = StringUtils.countOccurrencesOf(statement, "'");
        return numQuotes % 2 != 0;
    }
}

