/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.rtr;

import java.net.InetSocketAddress;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.rtr.BadData;
import net.ripe.rpki.validator.rtr.CacheResetPdu;
import net.ripe.rpki.validator.rtr.CacheResponsePdu;
import net.ripe.rpki.validator.rtr.EndOfDataPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu$;
import net.ripe.rpki.validator.rtr.IPv4PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.IPv6PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.Pdu;
import net.ripe.rpki.validator.rtr.ResetQueryPdu;
import net.ripe.rpki.validator.rtr.RtrSessionData;
import net.ripe.rpki.validator.rtr.SerialQueryPdu;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u00015\u0011\u0011C\u0015;s'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0002siJT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\u000b\u0003\u001de\u0019\"\u0001A\b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g\u0011!1\u0002A!A!\u0002\u00139\u0012!\u0004:f[>$X-\u00113ee\u0016\u001c8\u000f\u0005\u0002\u001931\u0001A!\u0002\u000e\u0001\u0005\u0004Y\"!\u0001+\u0012\u0005qy\u0002C\u0001\t\u001e\u0013\tq\u0012CA\u0004O_RD\u0017N\\4\u0011\u0005A\u0001\u0013BA\u0011\u0012\u0005\r\te.\u001f\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005)r-\u001a;DkJ\u0014XM\u001c;DC\u000eDWmU3sS\u0006d\u0007c\u0001\t&O%\u0011a%\u0005\u0002\n\rVt7\r^5p]B\u0002\"\u0001\u0005\u0015\n\u0005%\n\"aA%oi\"A1\u0006\u0001B\u0001B\u0003%A&A\u000bhKR\u001cUO\u001d:f]R\u0014FO\u001d)sK\u001aL\u00070Z:\u0011\u0007A)S\u0006E\u0002/cQr!\u0001E\u0018\n\u0005A\n\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t\u00191+\u001a;\u000b\u0005A\n\u0002CA\u001b9\u001b\u00051$BA\u001c\u0005\u0003\u0019iw\u000eZ3mg&\u0011\u0011H\u000e\u0002\n%R\u0014\bK]3gSbD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\u0014O\u0016$8)\u001e:sK:$8+Z:tS>t\u0017\n\u001a\t\u0004!\u0015j\u0004C\u0001 C\u001d\ty\u0004)D\u0001\u0003\u0013\t\t%!A\u0002QIVL!a\u0011#\u0003\u0013M+7o]5p]&#'BA!\u0003\u0011\u00151\u0005\u0001\"\u0001H\u0003\u0019a\u0014N\\5u}Q)\u0001*\u0013&L\u0019B\u0019q\bA\f\t\u000bY)\u0005\u0019A\f\t\u000b\r*\u0005\u0019\u0001\u0013\t\u000b-*\u0005\u0019\u0001\u0017\t\u000bm*\u0005\u0019\u0001\u001f\t\u000f9\u0003!\u0019!C\u0001\u001f\u0006Y1/Z:tS>tG)\u0019;b+\u0005\u0001\u0006CA R\u0013\t\u0011&A\u0001\bSiJ\u001cVm]:j_:$\u0015\r^1\t\rQ\u0003\u0001\u0015!\u0003Q\u00031\u0019Xm]:j_:$\u0015\r^1!\u0011\u00151\u0006\u0001\"\u0001X\u0003\u001d\u0019wN\u001c8fGR$\u0012\u0001\u0017\t\u0003!eK!AW\t\u0003\tUs\u0017\u000e\u001e\u0005\u00069\u0002!\taV\u0001\u000bI&\u001c8m\u001c8oK\u000e$\b\"\u00020\u0001\t\u0003y\u0016\u0001D:fe&\fGNT8uS\u001aLHC\u0001-a\u0011\u0015\tW\f1\u0001c\u0003\r\u0001H-\u001e\t\u0003\u007f\rL!\u0001\u001a\u0002\u0003\u0007A#W\u000fC\u0003g\u0001\u0011\u0005q-\u0001\bqe>\u001cWm]:SKF,Xm\u001d;\u0015\u0005!$\bcA5rE:\u0011!n\u001c\b\u0003W:l\u0011\u0001\u001c\u0006\u0003[2\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005A\f\u0012a\u00029bG.\fw-Z\u0005\u0003eN\u00141aU3r\u0015\t\u0001\u0018\u0003C\u0003vK\u0002\u0007a/A\u0004sKF,Xm\u001d;\u0011\t%<\u0018PY\u0005\u0003qN\u0014a!R5uQ\u0016\u0014\bCA {\u0013\tY(AA\u0004CC\u0012$\u0015\r^1\t\u000bu\u0004A\u0011\u0001@\u0002#\u0011,G/\u001a:nS:,WI\u001d:peB#W\u000fF\u0002\u0000\u0003\u000b\u00012aPA\u0001\u0013\r\t\u0019A\u0001\u0002\t\u000bJ\u0014xN\u001d)ek\"9\u0011q\u0001?A\u0002\u0005%\u0011!B2bkN,\u0007cA5\u0002\f%\u0019\u0011QB:\u0003\u0013QC'o\\<bE2,\u0007bBA\t\u0001\u0011%\u00111C\u0001\u000eQ\u0006tG\r\\3CC\u0012$\u0015\r^1\u0015\r\u0005U\u00111DA\u0010!\u0011I\u0017q\u00032\n\u0007\u0005e1O\u0001\u0003MSN$\bbBA\u000f\u0003\u001f\u0001\raJ\u0001\nKJ\u0014xN]\"pI\u0016D\u0001\"!\t\u0002\u0010\u0001\u0007\u00111E\u0001\bG>tG/\u001a8u!\u0015\u0001\u0012QEA\u0015\u0013\r\t9#\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004!\u0005-\u0012bAA\u0017#\t!!)\u001f;f\u0011\u001d\t\t\u0004\u0001C\u0005\u0003g\t\u0011\u0003\u001d:pG\u0016\u001c8OU3rk\u0016\u001cH\u000f\u00153v)\rA\u0017Q\u0007\u0005\u0007C\u0006=\u0002\u0019\u00012\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005\t\u0002O]8dKN\u001c(+Z:fiF+XM]=\u0016\u0003!Dq!a\u0010\u0001\t\u0013\t\t%\u0001\nqe>\u001cWm]:TKJL\u0017\r\\)vKJLHCBA\"\u0003G\ni\u0007\u0005\u0004\u0002F\u0005=\u0013\u0011K\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001b\n\u0012AC2pY2,7\r^5p]&!\u0011\u0011DA$%\u001d\t\u0019&a\u0016\u0002^\t4a!!\u0016\u0001\u0001\u0005E#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u0001\t\u0002Z%\u0019\u00111L\t\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0001#a\u0018\n\u0007\u0005\u0005\u0014C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0002f\u0005u\u0002\u0019AA4\u0003%\u0019Xm]:j_:LE\rE\u0002\u0011\u0003SJ1!a\u001b\u0012\u0005\u0015\u0019\u0006n\u001c:u\u0011!\ty'!\u0010A\u0002\u0005E\u0014AB:fe&\fG\u000eE\u0002\u0011\u0003gJ1!!\u001e\u0012\u0005\u0011auN\\4")
public class RtrSessionHandler<T> {
    private final Function0<Object> getCurrentCacheSerial;
    private final Function0<Set<RtrPrefix>> getCurrentRtrPrefixes;
    private final Function0<Object> getCurrentSessionId;
    private final RtrSessionData sessionData;

    public RtrSessionData sessionData() {
        return this.sessionData;
    }

    public void connect() {
        this.sessionData().connected().apply(BoxesRunTime.boxToBoolean((boolean)true));
    }

    public void disconnect() {
        this.sessionData().connected().apply(BoxesRunTime.boxToBoolean((boolean)false));
    }

    public void serialNotify(Pdu pdu) {
        this.sessionData().lastPduSent_$eq(pdu);
    }

    public Seq<Pdu> processRequest(Either<BadData, Pdu> request) {
        Either<BadData, Pdu> either;
        block4: {
            List<Pdu> list;
            block3: {
                block2: {
                    Left left;
                    BadData badData;
                    either = request;
                    if (!(either instanceof Left) || (badData = (BadData)(left = (Left)either).a()) == null) break block2;
                    int errorCode = badData.errorCode();
                    byte[] content = badData.content();
                    list = this.handleBadData(errorCode, content);
                    break block3;
                }
                if (!(either instanceof Right)) break block4;
                Right right = (Right)either;
                Pdu pdu = (Pdu)right.b();
                Seq<Pdu> result = this.processRequestPdu(pdu);
                this.sessionData().lastPduSent_$eq((Pdu)result.last());
                list = result;
            }
            return list;
        }
        throw new MatchError(either);
    }

    /*
     * WARNING - void declaration
     */
    public ErrorPdu determineErrorPdu(Throwable cause) {
        void var2_6;
        ErrorPdu errorPdu;
        this.sessionData().lastPduReceived_$eq(cause.getMessage());
        Throwable throwable = cause;
        if (throwable instanceof CorruptedFrameException) {
            CorruptedFrameException corruptedFrameException = (CorruptedFrameException)throwable;
            errorPdu = new ErrorPdu(ErrorPdu$.MODULE$.CorruptData(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), corruptedFrameException.toString());
        } else if (throwable instanceof TooLongFrameException) {
            TooLongFrameException tooLongFrameException = (TooLongFrameException)throwable;
            errorPdu = new ErrorPdu(ErrorPdu$.MODULE$.CorruptData(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), tooLongFrameException.toString());
        } else {
            errorPdu = throwable instanceof ReadTimeoutException ? new ErrorPdu(ErrorPdu$.MODULE$.InternalError(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), "Connection timed out") : new ErrorPdu(ErrorPdu$.MODULE$.InternalError(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), throwable.toString());
        }
        ErrorPdu result = errorPdu;
        this.sessionData().lastPduSent_$eq(result);
        return var2_6;
    }

    private List<Pdu> handleBadData(int errorCode, byte[] content) {
        this.sessionData().lastPduReceived_$eq(new StringOps(Predef$.MODULE$.augmentString("Bad data (error code: %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorCode)})));
        ErrorPdu pdu = new ErrorPdu(errorCode, content, "");
        this.sessionData().lastPduSent_$eq(pdu);
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{pdu}));
    }

    private Seq<Pdu> processRequestPdu(Pdu pdu) {
        List list;
        Pdu pdu2 = pdu;
        if (pdu2 instanceof ResetQueryPdu) {
            this.sessionData().lastPduReceived_$eq("ResetQuery");
            list = this.processResetQuery();
        } else if (pdu2 instanceof SerialQueryPdu) {
            SerialQueryPdu serialQueryPdu = (SerialQueryPdu)pdu2;
            short sessionId = serialQueryPdu.sessionId();
            long serial = serialQueryPdu.serial();
            this.sessionData().lastPduReceived_$eq("SerialQuery");
            list = this.processSerialQuery(sessionId, serial);
        } else {
            this.sessionData().lastPduReceived_$eq("Invalid Request");
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{new ErrorPdu(ErrorPdu$.MODULE$.InvalidRequest(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), "")}));
        }
        return list;
    }

    private Seq<Pdu> processResetQuery() {
        List list;
        int n = this.getCurrentCacheSerial.apply$mcI$sp();
        switch (n) {
            default: {
                ObjectRef responsePdus = new ObjectRef((Object)package$.MODULE$.Vector().empty());
                responsePdus.elem = (Vector)((Vector)responsePdus.elem).$colon$plus((Object)new CacheResponsePdu(this.getCurrentSessionId.apply$mcS$sp()), Vector$.MODULE$.canBuildFrom());
                ((IterableLike)this.getCurrentRtrPrefixes.apply()).foreach((Function1)new Serializable(this, responsePdus){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef responsePdus$1;

                    public final void apply(RtrPrefix rtrPrefix) {
                        IpRange prefix = rtrPrefix.prefix();
                        int prefixLength = prefix.getPrefixLength();
                        int maxLength = BoxesRunTime.unboxToInt((Object)rtrPrefix.maxPrefixLength().getOrElse((Function0)new Serializable(this, prefixLength){
                            public static final long serialVersionUID = 0L;
                            private final int prefixLength$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.prefixLength$1;
                            }
                            {
                                this.prefixLength$1 = prefixLength$1;
                            }
                        }));
                        Asn asn = rtrPrefix.asn();
                        UniqueIpResource uniqueIpResource = prefix.getStart();
                        if (uniqueIpResource instanceof Ipv4Address) {
                            Ipv4Address ipv4Address = (Ipv4Address)uniqueIpResource;
                            this.responsePdus$1.elem = (Vector)((Vector)this.responsePdus$1.elem).$colon$plus((Object)new IPv4PrefixAnnouncePdu(ipv4Address, (byte)prefixLength, (byte)maxLength, asn), Vector$.MODULE$.canBuildFrom());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (uniqueIpResource instanceof Ipv6Address) {
                            Ipv6Address ipv6Address = (Ipv6Address)uniqueIpResource;
                            this.responsePdus$1.elem = (Vector)((Vector)this.responsePdus$1.elem).$colon$plus((Object)new IPv6PrefixAnnouncePdu(ipv6Address, (byte)prefixLength, (byte)maxLength, asn), Vector$.MODULE$.canBuildFrom());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Predef$.MODULE$.assert(false);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        this.responsePdus$1 = responsePdus$1;
                    }
                });
                list = (Seq)((Vector)responsePdus.elem).$colon$plus((Object)new EndOfDataPdu(this.getCurrentSessionId.apply$mcS$sp(), this.getCurrentCacheSerial.apply$mcI$sp()), Vector$.MODULE$.canBuildFrom());
                break;
            }
            case 0: {
                list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{new ErrorPdu(ErrorPdu$.MODULE$.NoDataAvailable(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), "")}));
            }
        }
        return list;
    }

    private List<Product> processSerialQuery(short sessionId, long serial) {
        return sessionId == this.getCurrentSessionId.apply$mcS$sp() && serial == (long)this.getCurrentCacheSerial.apply$mcI$sp() ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new CacheResponsePdu(sessionId), new EndOfDataPdu(sessionId, serial)})) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CacheResetPdu[]{new CacheResetPdu()}));
    }

    public RtrSessionHandler(T remoteAddress, Function0<Object> getCurrentCacheSerial, Function0<Set<RtrPrefix>> getCurrentRtrPrefixes, Function0<Object> getCurrentSessionId) {
        this.getCurrentCacheSerial = getCurrentCacheSerial;
        this.getCurrentRtrPrefixes = getCurrentRtrPrefixes;
        this.getCurrentSessionId = getCurrentSessionId;
        this.sessionData = new RtrSessionData((InetSocketAddress)remoteAddress);
    }
}

