--
-- Copyright (C) 2010-2012 the original author or authors.
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--         http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--

CREATE TABLE ${schema}.${table} (
    version VARCHAR2(20) NOT NULL PRIMARY KEY,
    description VARCHAR2(100),
    type VARCHAR2(10) NOT NULL,
    script VARCHAR2(200) NOT NULL UNIQUE,
    checksum INT,
    installed_by VARCHAR2(30) NOT NULL,
    installed_on TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    execution_time INT,
    state VARCHAR2(15) NOT NULL,
    current_version NUMBER(1) NOT NULL
);
CREATE INDEX ${schema}.${table}_cv_idx ON ${schema}.${table} (current_version);