/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.commands;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.apache.commons.lang.Validate;

public class TopDownWalkerWorkQueue {
    private final Set<X509ResourceCertificate> added = new HashSet<X509ResourceCertificate>();
    private final Queue<CertificateRepositoryObjectValidationContext> queue;

    public TopDownWalkerWorkQueue() {
        this(new LinkedList<CertificateRepositoryObjectValidationContext>());
    }

    public TopDownWalkerWorkQueue(Queue<CertificateRepositoryObjectValidationContext> queue) {
        this.queue = queue;
    }

    public void add(CertificateRepositoryObjectValidationContext context) {
        Validate.isTrue((boolean)(context.getCertificate() instanceof X509ResourceCertificate), (String)"Top down walker can only handle resource certs");
        if (this.added.add(context.getCertificate())) {
            this.queue.add(context);
        }
    }

    public CertificateRepositoryObjectValidationContext remove() {
        return this.queue.remove();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }
}

