/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    private ClassUtils() {
    }

    public static <T> T instantiate(String className) throws Exception {
        return (T)Class.forName(className, true, ClassUtils.getClassLoader()).newInstance();
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static boolean isPresent(String className) {
        try {
            ClassUtils.getClassLoader().loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static String getShortName(Class<?> aClass) {
        String name = aClass.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }
}

