/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationException;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.googlecode.flyway.core.util.StopWatch;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.util.jdbc.JdbcTemplate;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionException;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMigrator {
    private static final Log LOG = LogFactory.getLog(DbMigrator.class);
    private final SchemaVersion target;
    private final DbSupport dbSupport;
    private final MetaDataTable metaDataTable;
    private final Connection connection;
    private final Connection connectionForMigrations;
    private final boolean ignoreFailedFutureMigration;

    public DbMigrator(Connection connection, Connection connectionForMigrations, DbSupport dbSupport, MetaDataTable metaDataTable, SchemaVersion target, boolean ignoreFailedFutureMigration) {
        this.connection = connection;
        this.connectionForMigrations = connectionForMigrations;
        this.dbSupport = dbSupport;
        this.metaDataTable = metaDataTable;
        this.target = target;
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
    }

    public int migrate(List<Migration> migrations) throws FlywayException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int migrationSuccessCount = 0;
        try {
            boolean firstRun;
            MetaDataTableRow metaDataTableRow;
            while ((metaDataTableRow = new TransactionTemplate(this.connection).execute(new TransactionCallback<MetaDataTableRow>(firstRun = migrationSuccessCount == 0, migrations){
                final /* synthetic */ boolean val$firstRun;
                final /* synthetic */ List val$migrations;
                {
                    this.val$firstRun = bl;
                    this.val$migrations = list;
                }

                @Override
                public MetaDataTableRow doInTransaction() {
                    MigrationState currentSchemaState;
                    SchemaVersion latestAvailableMigrationVersion;
                    boolean isFutureMigration;
                    DbMigrator.this.metaDataTable.lock();
                    SchemaVersion currentSchemaVersion = DbMigrator.this.metaDataTable.getCurrentSchemaVersion();
                    if (this.val$firstRun) {
                        LOG.info((Object)("Current schema version: " + currentSchemaVersion));
                    }
                    boolean bl = isFutureMigration = (latestAvailableMigrationVersion = ((Migration)this.val$migrations.get(0)).getVersion()).compareTo(currentSchemaVersion) < 0;
                    if (isFutureMigration) {
                        LOG.warn((Object)("Database version (" + currentSchemaVersion + ") is newer than the latest available migration (" + latestAvailableMigrationVersion + ") !"));
                    }
                    if ((currentSchemaState = DbMigrator.this.metaDataTable.getCurrentSchemaState()) == MigrationState.FAILED) {
                        if (isFutureMigration && DbMigrator.this.ignoreFailedFutureMigration) {
                            LOG.warn((Object)("Detected failed migration to version " + currentSchemaVersion + " !"));
                        } else {
                            throw new MigrationException(currentSchemaVersion, false);
                        }
                    }
                    if (isFutureMigration) {
                        return null;
                    }
                    Migration migration = DbMigrator.this.getNextMigration(this.val$migrations, currentSchemaVersion);
                    if (migration == null) {
                        return null;
                    }
                    return DbMigrator.this.applyMigration(migration);
                }
            })) != null) {
                if (MigrationState.FAILED == metaDataTableRow.getState()) {
                    throw new MigrationException(metaDataTableRow.getVersion(), false);
                }
                ++migrationSuccessCount;
            }
        }
        catch (TransactionException e) {
            throw new FlywayException("Migration failed !", e);
        }
        stopWatch.stop();
        this.logSummary(migrationSuccessCount, stopWatch.getTotalTimeMillis());
        return migrationSuccessCount;
    }

    private void logSummary(int migrationSuccessCount, long executionTime) {
        if (migrationSuccessCount == 0) {
            LOG.info((Object)"Schema is up to date. No migration necessary.");
            return;
        }
        String executionTimeStr = "(execution time " + TimeFormat.format(executionTime) + ").";
        if (migrationSuccessCount == 1) {
            LOG.info((Object)("Successfully applied 1 migration " + executionTimeStr));
        } else {
            LOG.info((Object)("Successfully applied " + migrationSuccessCount + " migrations " + executionTimeStr));
        }
    }

    private MetaDataTableRow applyMigration(final Migration migration) throws MigrationException {
        MigrationState state;
        MetaDataTableRow metaDataTableRow = new MetaDataTableRow(migration);
        LOG.info((Object)("Migrating to version " + migration.getVersion()));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            final JdbcTemplate jdbcTemplate = new JdbcTemplate(this.connectionForMigrations){

                protected void setNull(PreparedStatement preparedStatement, int parameterIndex) throws SQLException {
                }
            };
            new TransactionTemplate(this.connectionForMigrations).execute(new TransactionCallback<Void>(){

                @Override
                public Void doInTransaction() {
                    try {
                        migration.migrate(jdbcTemplate, DbMigrator.this.dbSupport);
                    }
                    catch (SQLException e) {
                        throw new FlywayException("Migration failed!", e);
                    }
                    return null;
                }
            });
            LOG.debug((Object)("Successfully completed and committed DB migration to version " + migration.getVersion().toString()));
            state = MigrationState.SUCCESS;
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            Throwable rootCause = ExceptionUtils.getRootCause(e);
            if (rootCause != null) {
                LOG.error((Object)("Caused by " + rootCause.toString()));
            }
            state = MigrationState.FAILED;
        }
        stopWatch.stop();
        int executionTime = (int)stopWatch.getTotalTimeMillis();
        if (MigrationState.FAILED.equals((Object)state) && this.dbSupport.supportsDdlTransactions()) {
            throw new MigrationException(migration.getVersion(), true);
        }
        LOG.debug((Object)String.format("Finished migrating to version %s (execution time %s)", migration.getVersion(), TimeFormat.format(executionTime)));
        metaDataTableRow.update(executionTime, state);
        this.metaDataTable.insert(metaDataTableRow);
        LOG.debug((Object)"MetaData table successfully updated to reflect changes");
        return metaDataTableRow;
    }

    private Migration getNextMigration(List<Migration> allMigrations, SchemaVersion currentVersion) {
        if (this.target.compareTo(currentVersion) < 0) {
            LOG.warn((Object)("Database version (" + currentVersion + ") is newer than the target version (" + this.target + ") !"));
            return null;
        }
        Migration nextMigration = null;
        for (Migration migration : allMigrations) {
            if (migration.getVersion().compareTo(currentVersion) <= 0) break;
            nextMigration = migration;
        }
        if (nextMigration == null) {
            return null;
        }
        if (this.target.compareTo(nextMigration.getVersion()) < 0) {
            return null;
        }
        return nextMigration;
    }
}

