/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.statistics;

import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxesRunTime;

public final class InconsistentRepositoryChecker$ {
    public static final InconsistentRepositoryChecker$ MODULE$;

    static {
        new InconsistentRepositoryChecker$();
    }

    public Map<URI, Object> check(Map<URI, ValidatedObject> objectMap) {
        Seq objects = objectMap.values().toSeq();
        return ((TraversableOnce)this.validCaCertificates((Seq<ValidatedObject>)objects).map((Function1)new Serializable(objectMap, objects){
            public static final long serialVersionUID = 0L;
            private final Map objectMap$1;
            private final Seq objects$1;

            public final Tuple2<URI, Object> apply(X509ResourceCertificate cert) {
                List inconsistencyKeys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validator.read.file", "validator.file.content"}));
                Option<ManifestCms> mft = InconsistentRepositoryChecker$.MODULE$.findValidManifest((Seq<ValidatedObject>)this.objects$1, cert.getManifestUri());
                Seq<ValidatedObject> validatedObjects = InconsistentRepositoryChecker$.MODULE$.findObjectsForUris((Map<URI, ValidatedObject>)this.objectMap$1, InconsistentRepositoryChecker$.MODULE$.getManifestEntryUris(cert.getRepositoryUri(), mft));
                Seq checks = (Seq)validatedObjects.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<ValidationCheck> apply(ValidatedObject vo) {
                        return vo.checks();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                boolean problems = checks.exists((Function1)new Serializable(this, inconsistencyKeys){
                    public static final long serialVersionUID = 0L;
                    private final List inconsistencyKeys$1;

                    public final boolean apply(ValidationCheck check2) {
                        ValidationStatus validationStatus = check2.getStatus();
                        ValidationStatus validationStatus2 = ValidationStatus.ERROR;
                        return !(validationStatus != null ? !validationStatus.equals(validationStatus2) : validationStatus2 != null) && this.inconsistencyKeys$1.contains((Object)check2.getKey());
                    }
                    {
                        this.inconsistencyKeys$1 = inconsistencyKeys$1;
                    }
                });
                return new Tuple2((Object)cert.getManifestUri(), (Object)BoxesRunTime.boxToBoolean((boolean)problems));
            }
            {
                this.objectMap$1 = objectMap$1;
                this.objects$1 = objects$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<X509ResourceCertificate> validCaCertificates(Seq<ValidatedObject> objects) {
        return (Seq)objects.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ValidatedObject, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                X509ResourceCertificate x509ResourceCertificate;
                ValidObject validObject;
                CertificateRepositoryObject cert;
                A1 A1 = x1;
                Object object = A1 instanceof ValidObject && (cert = (validObject = (ValidObject)A1).repositoryObject()) instanceof X509ResourceCertificate && (x509ResourceCertificate = (X509ResourceCertificate)cert).isCa() ? x509ResourceCertificate : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ValidatedObject x1) {
                X509ResourceCertificate x509ResourceCertificate;
                ValidObject validObject;
                CertificateRepositoryObject cert;
                ValidatedObject validatedObject = x1;
                boolean bl = validatedObject instanceof ValidObject && (cert = (validObject = (ValidObject)validatedObject).repositoryObject()) instanceof X509ResourceCertificate && (x509ResourceCertificate = (X509ResourceCertificate)cert).isCa();
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<ManifestCms> findValidManifest(Seq<ValidatedObject> objects, URI manifestUri) {
        return ((TraversableLike)objects.collect((PartialFunction)new Serializable(manifestUri){
            public static final long serialVersionUID = 0L;
            private final URI manifestUri$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends ValidatedObject, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof ValidObject) {
                    ValidObject validObject = (ValidObject)A1;
                    URI uri = validObject.uri();
                    CertificateRepositoryObject mft = validObject.repositoryObject();
                    if (mft instanceof ManifestCms) {
                        ManifestCms manifestCms = (ManifestCms)mft;
                        URI uRI = uri;
                        URI uRI2 = this.manifestUri$1;
                        if (!(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null)) {
                            object = manifestCms;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(ValidatedObject x2) {
                ValidatedObject validatedObject = x2;
                if (!(validatedObject instanceof ValidObject)) return false;
                ValidObject validObject = (ValidObject)validatedObject;
                URI uri = validObject.uri();
                CertificateRepositoryObject mft = validObject.repositoryObject();
                if (!(mft instanceof ManifestCms)) return false;
                URI uRI = uri;
                URI uRI2 = this.manifestUri$1;
                if (uRI != null) {
                    if (!((Object)uRI).equals(uRI2)) return false;
                    return true;
                }
                if (uRI2 == null) return true;
                return false;
            }
            {
                this.manifestUri$1 = manifestUri$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption();
    }

    public Seq<URI> getManifestEntryUris(URI certificateRepositoryUri, Option<ManifestCms> manifestOption) {
        Option<ManifestCms> option;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    option = manifestOption;
                    None$ none$ = None$.MODULE$;
                    Option<ManifestCms> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    seq = (Seq)Seq$.MODULE$.empty();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                ManifestCms mft = (ManifestCms)some.x();
                seq = ((SetLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(mft.getFileNames()).asScala()).map((Function1)new Serializable(certificateRepositoryUri){
                    public static final long serialVersionUID = 0L;
                    private final URI certificateRepositoryUri$1;

                    public final URI apply(String filename) {
                        return this.certificateRepositoryUri$1.resolve(filename);
                    }
                    {
                        this.certificateRepositoryUri$1 = certificateRepositoryUri$1;
                    }
                }, Set$.MODULE$.canBuildFrom())).toSeq();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public Seq<ValidatedObject> findObjectsForUris(Map<URI, ValidatedObject> objectMap, Seq<URI> uris) {
        return (Seq)uris.map((Function1)new Serializable(objectMap){
            public static final long serialVersionUID = 0L;
            private final Map objectMap$2;

            public final ValidatedObject apply(URI uri) {
                return (ValidatedObject)this.objectMap$2.getOrElse((Object)uri, (Function0)new Serializable(this, uri){
                    public static final long serialVersionUID = 0L;
                    private final URI uri$1;

                    public final InvalidObject apply() {
                        return new InvalidObject(this.uri$1, (Set<ValidationCheck>)Predef$.MODULE$.Set().empty());
                    }
                    {
                        this.uri$1 = uri$1;
                    }
                });
            }
            {
                this.objectMap$2 = objectMap$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private InconsistentRepositoryChecker$() {
        MODULE$ = this;
    }
}

