/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.identity;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.ripe.rpki.commons.provisioning.identity.IdentitySerializer;
import net.ripe.rpki.commons.provisioning.identity.RepositoryResponse;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.util.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RepositoryResponseSerializer
extends IdentitySerializer<RepositoryResponse> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RepositoryResponse deserialize(String xml) {
        try (StringReader characterStream = new StringReader(xml);){
            Document doc = XML.newNamespaceAwareDocumentBuilder().parse(new InputSource(characterStream));
            Element root = this.getElement(doc, "repository_response").orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("repository_response element not found"));
            this.getAttributeValue(root, "version").filter(v -> "1".equals(v)).orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("version is not supported"));
            Optional<String> tag = this.getAttributeValue(root, "tag");
            URI serviceUri = URI.create(this.getRequiredAttributeValue(root, "service_uri"));
            String publisherHandle = this.getRequiredAttributeValue(root, "publisher_handle");
            URI siaBase = URI.create(this.getRequiredAttributeValue(root, "sia_base"));
            Optional<URI> rrdpNotificationUri = this.getAttributeValue(root, "rrdp_notification_uri").map(URI::create);
            ProvisioningIdentityCertificate repositoryBpkiTa = this.getBpkiElementContent(doc, "repository_bpki_ta").map(bpkiTa -> this.getProvisioningIdentityCertificate((String)bpkiTa)).orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("repository_bpki_ta element not found"));
            RepositoryResponse repositoryResponse = new RepositoryResponse(tag, serviceUri, publisherHandle, siaBase, rrdpNotificationUri, repositoryBpkiTa);
            return repositoryResponse;
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | SAXException e) {
            throw new IdentitySerializer.IdentitySerializerException("Failed to parse repository response", e);
        }
    }

    @Override
    public String serialize(RepositoryResponse repositoryResponse) {
        try {
            Document document = XML.newNamespaceAwareDocumentBuilder().newDocument();
            Element requestElement = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "repository_response");
            requestElement.setAttribute("version", Integer.toString(repositoryResponse.getVersion()));
            repositoryResponse.getTag().ifPresent(tag -> requestElement.setAttribute("tag", (String)tag));
            requestElement.setAttribute("service_uri", repositoryResponse.getServiceUri().toASCIIString());
            requestElement.setAttribute("publisher_handle", repositoryResponse.getPublisherHandle());
            requestElement.setAttribute("sia_base", repositoryResponse.getSiaBase().toASCIIString());
            repositoryResponse.getRrdpNotificationUri().ifPresent(uri -> requestElement.setAttribute("rrdp_notification_uri", uri.toASCIIString()));
            Element bpkiTaElement = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "repository_bpki_ta");
            bpkiTaElement.setTextContent(repositoryResponse.getRepositoryBpkiTa().getBase64String());
            requestElement.appendChild(bpkiTaElement);
            document.appendChild(requestElement);
            return this.serialize(document);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IdentitySerializer.IdentitySerializerException(e);
        }
    }
}

