/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.aspa;

import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpResource;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;

public final class ProviderAS
implements Comparable<ProviderAS> {
    @NonNull
    private final Asn providerAsn;
    @NonNull
    private final Optional<AddressFamily> afiLimit;

    @Override
    public int compareTo(ProviderAS that) {
        int rc = this.providerAsn.compareTo((IpResource)that.providerAsn);
        if (rc != 0) {
            return rc;
        }
        if (Objects.equals(this.afiLimit, that.afiLimit)) {
            return 0;
        }
        if (!this.afiLimit.isPresent()) {
            return -1;
        }
        if (!that.afiLimit.isPresent()) {
            return 1;
        }
        return this.afiLimit.get().compareTo(that.afiLimit.get());
    }

    public ProviderAS(@NonNull Asn providerAsn, @NonNull Optional<AddressFamily> afiLimit) {
        if (providerAsn == null) {
            throw new NullPointerException("providerAsn is marked non-null but is null");
        }
        if (afiLimit == null) {
            throw new NullPointerException("afiLimit is marked non-null but is null");
        }
        this.providerAsn = providerAsn;
        this.afiLimit = afiLimit;
    }

    @NonNull
    public Asn getProviderAsn() {
        return this.providerAsn;
    }

    @NonNull
    public Optional<AddressFamily> getAfiLimit() {
        return this.afiLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProviderAS)) {
            return false;
        }
        ProviderAS other = (ProviderAS)o;
        Asn this$providerAsn = this.getProviderAsn();
        Asn other$providerAsn = other.getProviderAsn();
        if (this$providerAsn == null ? other$providerAsn != null : !this$providerAsn.equals(other$providerAsn)) {
            return false;
        }
        Optional<AddressFamily> this$afiLimit = this.getAfiLimit();
        Optional<AddressFamily> other$afiLimit = other.getAfiLimit();
        return !(this$afiLimit == null ? other$afiLimit != null : !((Object)this$afiLimit).equals(other$afiLimit));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Asn $providerAsn = this.getProviderAsn();
        result = result * 59 + ($providerAsn == null ? 43 : $providerAsn.hashCode());
        Optional<AddressFamily> $afiLimit = this.getAfiLimit();
        result = result * 59 + ($afiLimit == null ? 43 : ((Object)$afiLimit).hashCode());
        return result;
    }

    public String toString() {
        return "ProviderAS(providerAsn=" + this.getProviderAsn() + ", afiLimit=" + this.getAfiLimit() + ")";
    }
}

