/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml.converters;

import net.ripe.rpki.commons.xml.converters.DateTimeConverter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DateTimeConverterTest {
    private static final DateTime START_EPOCH_DATE_TIME = new DateTime(0L).withZone(DateTimeZone.UTC);
    private static final String START_EPOCH_DATE_WITH_MILLIS_AND_ZONE = "1970-01-01T00:00:00.000Z";
    private static final String START_EPOCH_DATE_NO_MILLIS_AND_ZONE = "1970-01-01T00:00:00Z";
    private DateTimeConverter converter;

    @Before
    public void setUp() {
        this.converter = new DateTimeConverter();
    }

    @Test
    public void shouldConvertDateToStringWithoutMillisByDefault() {
        String dateStringFound = this.converter.toString((Object)START_EPOCH_DATE_TIME);
        Assert.assertEquals((Object)START_EPOCH_DATE_NO_MILLIS_AND_ZONE, (Object)dateStringFound);
    }

    @Test
    public void shouldConvertDateToStringWithMillisIfAsked() {
        this.converter = new DateTimeConverter(true);
        String dateStringFound = this.converter.toString((Object)START_EPOCH_DATE_TIME);
        Assert.assertEquals((Object)START_EPOCH_DATE_WITH_MILLIS_AND_ZONE, (Object)dateStringFound);
    }

    @Test
    public void shouldUnderstandDateStringWithMillis() {
        DateTime dateFound = (DateTime)this.converter.fromString(START_EPOCH_DATE_WITH_MILLIS_AND_ZONE);
        Assert.assertEquals((Object)START_EPOCH_DATE_TIME, (Object)dateFound);
    }

    @Test
    public void shouldUnderstandIscDateFormat() {
        String iscDate = START_EPOCH_DATE_NO_MILLIS_AND_ZONE;
        DateTime dateFound = (DateTime)this.converter.fromString(iscDate);
        Assert.assertEquals((Object)START_EPOCH_DATE_TIME, (Object)dateFound);
    }
}

