/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import java.util.Arrays;
import java.util.Collections;
import net.ripe.rpki.commons.FixedDateRule;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationMetric;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ValidationResultTest {
    private static final ValidationLocation SECOND_LOCATION = new ValidationLocation("secondValidatedObject");
    private static final ValidationLocation FIRST_LOCATION = new ValidationLocation("firstValidatedObject");
    private static final DateTime NOW = new DateTime(2008, 4, 5, 0, 0, 0, 0, DateTimeZone.UTC);
    @Rule
    public FixedDateRule fixedDateRule = new FixedDateRule(NOW);
    private ValidationResult result;

    @Test
    public void shouldValidateWithoutFailures() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        Assert.assertTrue((boolean)this.result.rejectIfFalse(true, "A"));
        Assert.assertTrue((boolean)this.result.rejectIfTrue(false, "B"));
        Assert.assertTrue((boolean)this.result.rejectIfNull((Object)"", "C"));
        Assert.assertFalse((boolean)this.result.hasFailures());
        Assert.assertFalse((boolean)this.result.hasFailureForLocation(FIRST_LOCATION));
        Assert.assertFalse((boolean)this.result.hasFailureForLocation(new ValidationLocation("invalid object")));
        Assert.assertTrue((this.result.getValidatedLocations().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.result.getValidatedLocations().contains(FIRST_LOCATION));
        Assert.assertNotNull((Object)this.result.getAllValidationChecksForLocation(FIRST_LOCATION));
        Assert.assertEquals((long)3L, (long)this.result.getAllValidationChecksForLocation(FIRST_LOCATION).size());
        Assert.assertNotNull((Object)this.result.getFailures(FIRST_LOCATION));
        Assert.assertTrue((this.result.getFailures(FIRST_LOCATION).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldValidateWithFailures() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        Assert.assertTrue((boolean)this.result.rejectIfFalse(true, "A"));
        Assert.assertTrue((boolean)this.result.rejectIfTrue(false, "B"));
        this.result.setLocation(SECOND_LOCATION);
        Assert.assertFalse((boolean)this.result.rejectIfFalse(false, "A"));
        Assert.assertFalse((boolean)this.result.rejectIfTrue(true, "B"));
        this.result.setLocation(FIRST_LOCATION);
        Assert.assertTrue((boolean)this.result.rejectIfNull((Object)"", "C"));
        this.result.setLocation(SECOND_LOCATION);
        Assert.assertFalse((boolean)this.result.rejectIfNull(null, "C"));
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertFalse((boolean)this.result.hasFailureForLocation(FIRST_LOCATION));
        Assert.assertTrue((boolean)this.result.hasFailureForLocation(SECOND_LOCATION));
        Assert.assertTrue((this.result.getValidatedLocations().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.result.getValidatedLocations().contains(FIRST_LOCATION));
        Assert.assertTrue((boolean)this.result.getValidatedLocations().contains(SECOND_LOCATION));
        Assert.assertNotNull((Object)this.result.getAllValidationChecksForLocation(FIRST_LOCATION));
        Assert.assertTrue((this.result.getAllValidationChecksForLocation(FIRST_LOCATION).size() == 3 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.result.getAllValidationChecksForLocation(SECOND_LOCATION));
        Assert.assertTrue((this.result.getAllValidationChecksForLocation(SECOND_LOCATION).size() == 3 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.result.getFailures(FIRST_LOCATION));
        Assert.assertTrue((this.result.getFailures(FIRST_LOCATION).size() == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.result.getFailures(SECOND_LOCATION));
        Assert.assertTrue((this.result.getFailures(SECOND_LOCATION).size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void shouldHaveNoMetricsInitially() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        Assert.assertEquals(Collections.emptyList(), (Object)this.result.getMetrics(FIRST_LOCATION));
    }

    @Test
    public void shouldTrackValidationMetrics() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        this.result.addMetric("name", "value");
        Assert.assertEquals(Arrays.asList(new ValidationMetric("name", "value", NOW.getMillis())), (Object)this.result.getMetrics(FIRST_LOCATION));
        Assert.assertEquals(Collections.emptyList(), (Object)this.result.getMetrics(SECOND_LOCATION));
    }

    @Test
    public void should_keep_checks_from_target_result() {
        ValidationResult source = ValidationResult.withLocation((String)"n/a");
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        this.result.rejectForLocation(FIRST_LOCATION, "existing", new String[]{"param"});
        this.result.addAll(source);
        Assert.assertEquals((long)1L, (long)this.result.getFailures(FIRST_LOCATION).size());
        Assert.assertEquals((Object)"existing", (Object)((ValidationCheck)this.result.getFailures(FIRST_LOCATION).get(0)).getKey());
    }

    @Test
    public void should_copy_checks_from_source_result() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        ValidationResult source = ValidationResult.withLocation((String)"n/a");
        source.rejectForLocation(FIRST_LOCATION, "added", new String[]{"param"});
        this.result.addAll(source);
        Assert.assertEquals((long)1L, (long)this.result.getFailures(FIRST_LOCATION).size());
        Assert.assertEquals((Object)"added", (Object)((ValidationCheck)this.result.getFailures(FIRST_LOCATION).get(0)).getKey());
    }

    @Test
    public void should_add_all_checks_from_both_results() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        ValidationResult source = ValidationResult.withLocation((String)"n/a");
        source.rejectForLocation(FIRST_LOCATION, "added", new String[]{"param"});
        this.result.rejectForLocation(FIRST_LOCATION, "existing", new String[]{"param"});
        this.result.addAll(source);
        Assert.assertEquals((long)2L, (long)this.result.getFailures(FIRST_LOCATION).size());
        Assert.assertEquals((Object)"existing", (Object)((ValidationCheck)this.result.getFailures(FIRST_LOCATION).get(0)).getKey());
        Assert.assertEquals((Object)"added", (Object)((ValidationCheck)this.result.getFailures(FIRST_LOCATION).get(1)).getKey());
    }

    @Test
    public void should_track_if_there_are_any_warnings() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        this.result.error("an.error");
        this.result.setLocation(SECOND_LOCATION);
        Assert.assertFalse((String)"no warnings yet", (boolean)this.result.hasWarnings());
        this.result.warn("a.warning");
        Assert.assertTrue((String)"warning correctly found", (boolean)this.result.hasWarnings());
    }

    @Test
    public void should_track_if_there_are_any_errors() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        this.result.warn("a.warning");
        this.result.setLocation(SECOND_LOCATION);
        Assert.assertFalse((String)"no failures yet", (boolean)this.result.hasFailures());
        this.result.error("an.error");
        Assert.assertTrue((String)"warning correctly found", (boolean)this.result.hasFailures());
    }

    @Test
    public void should_not_store_passing_checks_when_requested() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION).withoutStoringPassingChecks();
        this.result.pass("passed1");
        this.result.pass("passed2", new String[]{"with", "params"});
        this.result.rejectIfFalse(true, "passed3");
        this.result.warnIfNotNull(null, "passed4");
        Assert.assertEquals((long)0L, (long)this.result.getAllValidationChecksForCurrentLocation().size());
    }

    @Test
    public void should_still_store_warnings_when_not_storing_passing_checks() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION).withoutStoringPassingChecks();
        this.result.warn("warning");
        Assert.assertEquals((long)1L, (long)this.result.getAllValidationChecksForCurrentLocation().size());
    }

    @Test
    public void should_still_store_errors_when_not_storing_passing_checks() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION).withoutStoringPassingChecks();
        this.result.error("error");
        Assert.assertEquals((long)1L, (long)this.result.getAllValidationChecksForCurrentLocation().size());
    }

    @Test
    public void should_not_add_passed_checks_from_other_validation_result_when_not_storing_passing_checks() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION).withoutStoringPassingChecks();
        ValidationResult that = ValidationResult.withLocation((ValidationLocation)SECOND_LOCATION);
        that.pass("passed");
        that.warn("warning");
        that.error("error");
        this.result.addAll(that);
        Assert.assertEquals((long)2L, (long)this.result.getAllValidationChecksForLocation(SECOND_LOCATION).size());
    }

    @Test
    public void should_remove_passed_checks_when_invoking_withoutPassingChecks() {
        this.result = ValidationResult.withLocation((ValidationLocation)FIRST_LOCATION);
        Assert.assertTrue((boolean)this.result.isStoringPassingChecks());
        this.result.pass("passed");
        Assert.assertEquals((long)1L, (long)this.result.getAllValidationChecksForCurrentLocation().size());
        this.result.withoutStoringPassingChecks();
        Assert.assertFalse((boolean)this.result.isStoringPassingChecks());
        Assert.assertEquals((long)0L, (long)this.result.getAllValidationChecksForCurrentLocation().size());
    }
}

