/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import java.util.Locale;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationMessage;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.junit.Assert;
import org.junit.Test;

public class ValidationMessageTest {
    @Test
    public void shouldResolveMessage() {
        ValidationCheck validationCheck = new ValidationCheck(ValidationStatus.PASSED, "cert.parsed", new String[0]);
        Assert.assertEquals((Object)"Certificate can be parsed", (Object)ValidationMessage.getMessage((ValidationCheck)validationCheck));
    }

    @Test
    public void shouldFormatMessageArguments() {
        ValidationCheck validationCheck = new ValidationCheck(ValidationStatus.PASSED, "validator.uri.host", new String[]{"rsync://localhost/path/"});
        Assert.assertEquals((Object)"URI 'rsync://localhost/path/' contains a host", (Object)ValidationMessage.getMessage((ValidationCheck)validationCheck));
    }

    @Test
    public void shouldUseSpecifiedLocale() {
        ValidationCheck validationCheck = new ValidationCheck(ValidationStatus.PASSED, "cert.parsed", new String[0]);
        Assert.assertEquals((Object)"Het certificaat kon ingelezen worden", (Object)ValidationMessage.getMessage((ValidationCheck)validationCheck, (Locale)Locale.forLanguageTag("test")));
        Assert.assertEquals((Object)"Certificate can be parsed", (Object)ValidationMessage.getMessage((ValidationCheck)validationCheck, (Locale)Locale.US));
    }

    @Test
    public void shouldFallbackToDefaultLocale() {
        ValidationCheck validationCheck = new ValidationCheck(ValidationStatus.PASSED, "cert.parsed", new String[0]);
        Assert.assertEquals((Object)"Certificate can be parsed", (Object)ValidationMessage.getMessage((ValidationCheck)validationCheck, (Locale)Locale.FRENCH));
    }

    @Test
    public void shouldFallbackToLanguageFromFullLocale() {
        ValidationCheck validationCheck = new ValidationCheck(ValidationStatus.PASSED, "cert.parsed", new String[0]);
        Assert.assertEquals((Object)"Certificate can be parsed", (Object)ValidationMessage.getMessage((ValidationCheck)validationCheck, (Locale)Locale.US));
    }
}

