/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.ripe.rpki.commons.util.CsvFormatter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsvFormatterTest {
    private CsvFormatter subject;
    private List<CsvFormatter.CsvColumn> columns;

    @Before
    public void setUp() {
        this.subject = new CsvFormatter();
        this.columns = new ArrayList<CsvFormatter.CsvColumn>();
        this.subject.setColumnList(this.columns);
    }

    @Test
    public void shouldAllowAddingAColumn() {
        String heading = "heading1";
        this.subject.addColumn(heading);
        Assert.assertEquals((long)1L, (long)this.columns.size());
    }

    @Test
    public void shouldAcceptLinesHappyFlow() {
        String heading = "heading1";
        this.subject.addColumn(heading);
        String val1 = "some text";
        this.subject.addLine(new String[]{val1});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectLinesWithWrongNumberOfElements() {
        String heading = "heading1";
        this.subject.addColumn(heading);
        String val1 = "some text";
        this.subject.addLine(new String[]{val1, val1});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectLinesWhenSeparatorIsUsedInUnquotedField() {
        this.subject.addColumn("heading1");
        String val = "offending , in text";
        this.subject.addLine(new String[]{val});
    }

    @Test
    public void shouldPrintLinesAndQuoteProperly() throws IOException {
        this.subject.addColumn("heading1");
        this.subject.addQuotedColumn("heading2");
        String val1 = "some text";
        String val2 = "more stuff";
        this.subject.addLine(new String[]{val1, val2});
        StringWriter writer = new StringWriter();
        this.subject.printWithoutHeaders((Writer)writer);
        Assert.assertEquals((Object)"some text,\"more stuff\"\n", (Object)writer.toString());
    }

    @Test
    public void shouldChangeSeparator() throws IOException {
        this.subject = new CsvFormatter(";");
        this.subject.addColumn("heading1");
        this.subject.addColumn("heading2");
        String val1 = "text";
        String val2 = "stuff";
        this.subject.addLine(new String[]{val1, val2});
        StringWriter writer = new StringWriter();
        this.subject.printWithoutHeaders((Writer)writer);
        Assert.assertEquals((Object)"text;stuff\n", (Object)writer.toString());
    }

    @Test
    public void shouldUseEmptyStringForNullValues() throws IOException {
        this.subject.addColumn("heading1");
        this.subject.addColumn("heading2");
        Object val1 = null;
        this.subject.addLine(new String[]{val1, val1});
        StringWriter writer = new StringWriter();
        this.subject.printWithoutHeaders((Writer)writer);
        Assert.assertEquals((Object)",\n", (Object)writer.toString());
    }

    @Test
    public void shouldPrintHeader() throws IOException {
        this.subject.addColumn("heading1");
        this.subject.addQuotedColumn("heading2");
        String val1 = "some text";
        String val2 = "more stuff";
        this.subject.addLine(new String[]{val1, val2});
        StringWriter writer = new StringWriter();
        this.subject.printWithHeaders((Writer)writer);
        Assert.assertEquals((Object)"heading1,heading2\nsome text,\"more stuff\"\n", (Object)writer.toString());
    }
}

