/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.rsync;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import net.ripe.rpki.commons.rsync.ProcessReader;
import org.junit.Assert;
import org.junit.Test;

public class ProcessReaderTest {
    private final String firstLine = "first line";
    private final String secondLine = "second line";
    private final String text = "first line" + System.getProperty("line.separator") + "second line" + System.getProperty("line.separator");

    @Test
    public void shouldReadStreamAndCollectOutput() throws FileNotFoundException, InterruptedException {
        ProcessReader processReader = new ProcessReader((InputStream)new ByteArrayInputStream(this.text.getBytes()));
        processReader.start();
        processReader.join();
        Assert.assertNotNull((Object)processReader.getLines());
        Assert.assertTrue((processReader.getLines().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals(processReader.getLines().get(0), (Object)"first line");
        Assert.assertEquals(processReader.getLines().get(1), (Object)"second line");
    }

    @Test
    public void shouldReadStreamAndPrintOutput() throws InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ProcessReader processReader = new ProcessReader((InputStream)new ByteArrayInputStream(this.text.getBytes()), (OutputStream)out);
        processReader.start();
        processReader.join();
        Assert.assertNull((Object)processReader.getLines());
        Assert.assertEquals((Object)((Object)out).toString(), (Object)this.text);
    }
}

