/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509.pkcs10;

import java.net.URI;
import java.security.KeyPair;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.util.PregeneratedKeyPairFactory;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestBuilder;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestParser;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestParserException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.junit.Assert;
import org.junit.Test;

public class RpkiCaCertificateRequestBuilderParserTest {
    @Test
    public void shouldRoundTripBuildParseRpkiCaCertRequest() throws RpkiCaCertificateRequestParserException {
        RpkiCaCertificateRequestBuilder requestBuilder = new RpkiCaCertificateRequestBuilder();
        URI caRepositoryUri = URI.create("rsync://host/module/subdir/");
        URI manifestUri = URI.create("rsync://host/module/subdir/subject.mft");
        X500Principal subject = new X500Principal("CN=subject");
        KeyPair keyPair = PregeneratedKeyPairFactory.getInstance().generate();
        requestBuilder.withCaRepositoryUri(caRepositoryUri);
        requestBuilder.withManifestUri(manifestUri);
        requestBuilder.withSubject(subject);
        PKCS10CertificationRequest pkcs10Request = requestBuilder.build(keyPair);
        Assert.assertNotNull((Object)pkcs10Request);
        RpkiCaCertificateRequestParser requestParser = new RpkiCaCertificateRequestParser(pkcs10Request);
        Assert.assertEquals((Object)caRepositoryUri, (Object)requestParser.getCaRepositoryUri());
        Assert.assertEquals((Object)manifestUri, (Object)requestParser.getManifestUri());
        Assert.assertEquals((Object)keyPair.getPublic(), (Object)requestParser.getPublicKey());
    }

    @Test
    public void shouldBuildParseEncodedRpkiCaCertRequest() throws Exception {
        PKCS10CertificationRequest pkcs10Request = RpkiCaCertificateRequestBuilderParserTest.createRpkiCaCertificateRequest();
        Assert.assertNotNull((Object)pkcs10Request);
        PKCS10CertificationRequest decodedPkcs10Request = new PKCS10CertificationRequest(pkcs10Request.getEncoded());
        RpkiCaCertificateRequestParser requestParser = new RpkiCaCertificateRequestParser(decodedPkcs10Request);
        Assert.assertEquals((Object)ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_CA_REPO_URI, (Object)requestParser.getCaRepositoryUri());
        Assert.assertEquals((Object)ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_CA_MFT_URI, (Object)requestParser.getManifestUri());
        Assert.assertEquals((Object)ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_CA_NOTIFICATION_URI, (Object)requestParser.getNotificationUri());
        Assert.assertEquals((Object)ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_KEYPAIR.getPublic(), (Object)requestParser.getPublicKey());
    }

    public static PKCS10CertificationRequest createRpkiCaCertificateRequest() {
        RpkiCaCertificateRequestBuilder requestBuilder = new RpkiCaCertificateRequestBuilder();
        requestBuilder.withCaRepositoryUri(ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_CA_REPO_URI);
        requestBuilder.withManifestUri(ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_CA_MFT_URI);
        requestBuilder.withNotificationUri(ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_CA_NOTIFICATION_URI);
        requestBuilder.withSubject(ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_CA_SUBJECT);
        PKCS10CertificationRequest pkcs10Request = requestBuilder.build(ProvisioningObjectMother.RPKI_CA_CERT_REQUEST_KEYPAIR);
        return pkcs10Request;
    }
}

