/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.PregeneratedKeyPairFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificate;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificateBuilder;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateBuilderTest;
import net.ripe.rpki.commons.util.UTC;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningCmsCertificateBuilderTest {
    public static final KeyPair EE_KEYPAIR = PregeneratedKeyPairFactory.getInstance().generate();
    public static final ProvisioningCmsCertificate TEST_CMS_CERT = ProvisioningCmsCertificateBuilderTest.getTestProvisioningCmsCertificate();
    private ProvisioningCmsCertificateBuilder subject;

    private static ProvisioningCmsCertificate getTestProvisioningCmsCertificate() {
        ProvisioningCmsCertificateBuilder cmsCertificateBuilder = ProvisioningCmsCertificateBuilderTest.getTestBuilder();
        return cmsCertificateBuilder.build();
    }

    private static ProvisioningCmsCertificateBuilder getTestBuilder() {
        ProvisioningCmsCertificateBuilder builder = new ProvisioningCmsCertificateBuilder();
        builder.withIssuerDN(ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT.getSubject());
        builder.withSerial(BigInteger.TEN);
        builder.withPublicKey(EE_KEYPAIR.getPublic());
        builder.withSubjectDN(new X500Principal("CN=end-entity"));
        builder.withSigningKeyPair(ProvisioningObjectMother.TEST_KEY_PAIR);
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    @Before
    public void setUp() {
        this.subject = ProvisioningCmsCertificateBuilderTest.getTestBuilder();
    }

    @Test
    public void shouldBuild() {
        ProvisioningCmsCertificate cmsCertificate = this.subject.build();
        Assert.assertNotNull((Object)cmsCertificate);
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequirePublicKey() {
        this.subject.withPublicKey(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireIssuerDN() {
        this.subject.withIssuerDN(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireSubjectDN() {
        this.subject.withSubjectDN(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireSerial() {
        this.subject.withSerial(null);
        this.subject.build();
    }

    @Test
    public void shouldUseSHA256withRSA() {
        Assert.assertEquals((Object)"SHA256withRSA", (Object)TEST_CMS_CERT.getCertificate().getSigAlgName());
    }

    @Test
    public void shouldUseProvidedSubjectKey() {
        Assert.assertEquals((Object)EE_KEYPAIR.getPublic(), (Object)TEST_CMS_CERT.getCertificate().getPublicKey());
    }

    @Test
    public void shouldNotHaveRsyncCrlPointer() {
        Assert.assertNull((Object)TEST_CMS_CERT.findFirstRsyncCrlDistributionPoint());
    }

    @Test
    public void shouldNotHaveAiaPointer() {
        Assert.assertNull((Object)TEST_CMS_CERT.getAuthorityInformationAccess());
    }

    @Test
    public void shouldHaveNoSiaPointer() {
        X509CertificateInformationAccessDescriptor[] subjectInformationAccess = TEST_CMS_CERT.getSubjectInformationAccess();
        Assert.assertNull((Object)subjectInformationAccess);
    }

    @Test
    public void shouldSetDefaultValidityPeriod() {
        X509Certificate certificate = ProvisioningCmsCertificateBuilderTest.getTestProvisioningCmsCertificate().getCertificate();
        Duration validityDuration = Duration.between(certificate.getNotBefore().toInstant(), certificate.getNotAfter().toInstant());
        Assert.assertTrue((validityDuration.compareTo(Duration.ofDays(1L)) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void shouldSetValidityPeriod() {
        DateTime now = UTC.dateTime();
        ValidityPeriod yearInDays = new ValidityPeriod((ReadableInstant)now, (ReadableInstant)now.plusDays(365));
        X509Certificate certificate = this.subject.withValidityPeriod(yearInDays).build().getCertificate();
        Duration validityDuration = Duration.between(certificate.getNotBefore().toInstant(), certificate.getNotAfter().toInstant());
        Assert.assertTrue((validityDuration.compareTo(Duration.ofDays(365L)) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBeAnEECertificate() {
        Assert.assertFalse((boolean)TEST_CMS_CERT.isCa());
    }

    @Test
    public void shouldHaveKeyUsageExtensionDigitalSignature() {
        boolean[] keyUsage = TEST_CMS_CERT.getCertificate().getKeyUsage();
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, false, false, false, false, false, false, false}, keyUsage));
    }
}

