/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.list.request;

import java.io.IOException;
import net.ripe.rpki.commons.provisioning.payload.PayloadMessageType;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayload;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayloadSerializer;
import net.ripe.rpki.commons.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ResourceClassListQueryPayloadSerializerTest {
    private static final XmlSerializer<ResourceClassListQueryPayload> SERIALIZER = new ResourceClassListQueryPayloadSerializer();
    public static final ResourceClassListQueryPayload TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD = new ResourceClassListQueryPayload();
    public static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<message xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\"\n         recipient=\"recipient attribute\"\n         sender=\"sender attribute\"\n         type=\"list\"\n         version=\"1\"/>\n";

    @Test
    public void shouldCreateParsableProvisioningObject() throws IOException {
        Assert.assertEquals((Object)"sender", (Object)TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD.getSender());
        Assert.assertEquals((Object)"recipient", (Object)TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD.getRecipient());
    }

    @Test
    public void shouldParseXml() {
        ResourceClassListQueryPayload payload = (ResourceClassListQueryPayload)SERIALIZER.deserialize(XML);
        Assert.assertEquals((Object)1, (Object)payload.getVersion());
        Assert.assertEquals((Object)"sender attribute", (Object)payload.getSender());
        Assert.assertEquals((Object)"recipient attribute", (Object)payload.getRecipient());
        Assert.assertEquals((Object)PayloadMessageType.list, (Object)payload.getType());
    }

    @Test
    public void shouldCreateXmlConformDraft() {
        ResourceClassListQueryPayload payload = new ResourceClassListQueryPayload();
        payload.setSender("sender attribute");
        payload.setRecipient("recipient attribute");
        Assert.assertEquals((Object)XML, (Object)SERIALIZER.serialize((Object)payload));
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

