/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParser;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectValidator;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateParser;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ProvisioningCmsObjectValidatorTimeRelatedTest {
    private ProvisioningCmsObject ca1CmsObject;
    private ProvisioningIdentityCertificate ca1IdCert;
    private ProvisioningIdentityCertificate ca2IdCert;
    private ValidationResult validationResult;

    @BeforeEach
    public void setup() {
        this.validationResult = ValidationResult.withLocation((String)"n/a");
        this.ca1CmsObject = ProvisioningCmsObjectValidatorTimeRelatedTest.readProvisioningPDU("src/test/resources/interop/up-down/krill-ca1-list-pdu.der");
        this.ca1IdCert = ProvisioningCmsObjectValidatorTimeRelatedTest.readProvisioningIdentityCertificate("src/test/resources/interop/up-down/krill-ca1-id-cert.der");
        this.ca2IdCert = ProvisioningCmsObjectValidatorTimeRelatedTest.readProvisioningIdentityCertificate("src/test/resources/interop/up-down/krill-ca2-id-cert.der");
    }

    @AfterEach
    public void restoreClock() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    private static ProvisioningCmsObject readProvisioningPDU(String resourcePath) {
        ProvisioningCmsObjectParser cmsParser = new ProvisioningCmsObjectParser();
        cmsParser.parseCms("cms", Files.toByteArray((File)new File(resourcePath)));
        return cmsParser.getProvisioningCmsObject();
    }

    private static ProvisioningIdentityCertificate readProvisioningIdentityCertificate(String resourcePath) {
        ProvisioningIdentityCertificateParser certificateParser = new ProvisioningIdentityCertificateParser();
        certificateParser.parse("id-cert", Files.toByteArray((File)new File(resourcePath)));
        return certificateParser.getCertificate();
    }

    private static void validateObjects(ValidationResult validationResult, ProvisioningCmsObject cmsObject, ProvisioningIdentityCertificate idCert) {
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjectsWithLastSigningTime(validationResult, null, cmsObject, idCert);
    }

    private static void validateObjectsWithLastSigningTime(ValidationResult validationResult, DateTime lastSigningTime, ProvisioningCmsObject cmsObject, ProvisioningIdentityCertificate idCert) {
        ProvisioningCmsObjectValidator subject = new ProvisioningCmsObjectValidator(ValidationOptions.strictValidation(), Optional.ofNullable(lastSigningTime), cmsObject, idCert);
        subject.validate(validationResult);
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_cms_sig_not_from_id_cert() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2022-01-11T12:39:46.000Z").getMillis());
        Assertions.assertThat((Object)this.ca1IdCert.getPublicKey()).isNotEqualTo((Object)this.ca2IdCert.getPublicKey());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjects(this.validationResult, this.ca1CmsObject, this.ca2IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isTrue();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_cms_ee_not_valid_yet() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2022-01-11T10:00:00Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjects(this.validationResult, this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isTrue();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_both_certs_not_valid_yet() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2021-01-11T10:00:00Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjects(this.validationResult, this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isTrue();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_current_certs() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2022-01-11T12:39:46.000Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjects(this.validationResult, this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isFalse();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_cms_ee_expired() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2022-01-13T12:39:46.000Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjects(this.validationResult, this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isTrue();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_two_expired_certs() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2040-01-11T10:00:00Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjects(this.validationResult, this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isTrue();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_signing_time_no_last() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2022-01-11T12:39:46.000Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjectsWithLastSigningTime(this.validationResult, null, this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isFalse();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_signing_time_after_last() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2022-01-11T12:39:46.000Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjectsWithLastSigningTime(this.validationResult, DateTime.parse((String)"2022-01-11T11:00:00.000Z"), this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isFalse();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_signing_time_at_last() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2022-01-11T12:39:46.000Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjectsWithLastSigningTime(this.validationResult, this.ca1CmsObject.getSigningTime(), this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isFalse();
    }

    @Test
    public void testValidateProvisioningCmsAndIdentityCertificate_signing_time_before_last() throws IOException {
        DateTimeUtils.setCurrentMillisFixed((long)DateTime.parse((String)"2022-01-11T12:39:46.000Z").getMillis());
        ProvisioningCmsObjectValidatorTimeRelatedTest.validateObjectsWithLastSigningTime(this.validationResult, DateTime.parse((String)"2022-01-11T13:00:00.000Z"), this.ca1CmsObject, this.ca1IdCert);
        Assertions.assertThat((boolean)this.validationResult.hasFailures()).isTrue();
    }
}

