/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.interop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.junit.Assert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class BBNCertificateConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Disabled(value="Early ripe ncc ta certificates have crldp set")
    @Test
    public void shouldRejectSelfSignedCertificateWithCRLDP() throws IOException {
        boolean hasFailure = this.parseCertificate("badRootBadCRLDP.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldRejectCertificateWithCRLDPWithReasonFieldNotOmitted() throws IOException {
        boolean hasFailure = this.parseCertificate("root/badCertCRLDPReasons.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldRejectCertificateWithCRLDPWithCrlIssuer() throws IOException {
        boolean hasFailure = this.parseCertificate("root/badCertCRLDPCrlIssuer.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldRejectCertificateWithoutKeyUsageBit() throws IOException {
        Assert.assertTrue((boolean)this.parseCertificate("root/badCertNoKeyUsage.cer"));
    }

    @Test
    public void shouldRejectCertificateWithTwoKeyUsageBits() throws IOException {
        Assert.assertTrue((boolean)this.parseCertificate("root/badCert2KeyUsage.cer"));
    }

    @CsvSource(value={"127, KUsageExtra,          has disallowed key usage bit (nonRepudiation) 6487#4.8.4", "217, KUsageDigitalSig,     has disallowed key usage bit (digitalSignature) 6487#4.8.4", "128, KUsageNoCertSign,     lacks bit for signing certificates 6487#4.8.4", "129, KUsageNoCrit,         key usage extension not critical 6487#4.8.4", "131, KUsageNoCRLSign,      lacks bit for signing CRLs 6487#4.8.4"})
    @ParameterizedTest(name="{displayName} - {0} {1} {2}")
    public void shouldRejectCertificateWithIncorrectKeyUsageBits(String testCasenumber, String testCaseFile, String testCaseDescription) throws IOException {
        String fileName = String.format("root/badCert%s.cer", testCaseFile);
        Assert.assertTrue((String)("Should reject certificate with " + testCaseDescription + " from " + fileName), (boolean)this.parseCertificate(fileName));
    }

    private boolean certificateHasWarningOrFailure(String certificate) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, certificate);
        byte[] encoded = Files.toByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        new X509ResourceCertificateParser().parse(result, encoded);
        return result.hasFailures() || result.hasWarnings();
    }

    private boolean parseCertificate(String certificate) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, certificate);
        byte[] encoded = Files.toByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        new X509ResourceCertificateParser().parse(result, encoded);
        return result.hasFailures();
    }
}

