/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.net.URI;
import java.security.cert.CertificateParsingException;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoder;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionParser;
import net.ripe.rpki.commons.crypto.rfc8209.RouterExtensionEncoder;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilderException;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificateBuilder;
import net.ripe.rpki.commons.util.UTC;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X509RouterCertificateBuilderTest {
    private X509RouterCertificateBuilder subject;

    @Before
    public void setUp() {
        this.subject = new X509RouterCertificateBuilder();
        this.subject.withSubjectDN(new X500Principal("CN=zz.subject")).withIssuerDN(new X500Principal("CN=zz.issuer"));
        this.subject.withSerial(BigInteger.ONE);
        this.subject.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        this.subject.withSigningKeyPair(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR);
        DateTime now = UTC.dateTime();
        this.subject.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)new DateTime(now.getYear() + 1, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.subject.withAsns(new int[]{1, 2, 3, 4, 5});
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireResourcesForResourceCertificates() {
        this.subject.withAsns(null);
        this.subject.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireNonEmptyResourceSetForResourceCertificates() {
        this.subject.withAsns(new int[0]);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireIssuer() {
        this.subject.withIssuerDN(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireSubject() {
        this.subject.withSubjectDN(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireSerial() {
        this.subject.withSerial(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequirePublicKey() {
        this.subject.withPublicKey(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireSigningKeyPair() {
        this.subject.withSigningKeyPair(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireValidityPeriod() {
        this.subject.withValidityPeriod(null);
        this.subject.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowKeyCertSignForNonCAs() {
        this.subject.withCa(false);
        this.subject.withKeyUsage(4);
        this.subject.build();
    }

    @Test
    public void shouldHaveExtendedKeyUsage() throws CertificateParsingException {
        X509RouterCertificate x509RouterCertificate = this.subject.build();
        List<String> extendedKeyUsage = x509RouterCertificate.getCertificate().getExtendedKeyUsage();
        Assert.assertEquals((long)1L, (long)extendedKeyUsage.size());
        Assert.assertEquals((Object)RouterExtensionEncoder.OID_KP_BGPSEC_ROUTER.toString(), (Object)extendedKeyUsage.get(0));
    }

    @Test
    public void shouldIgnoreBasicConstraintsForCAs() {
        this.subject.withCa(true);
        X509RouterCertificate certificate = this.subject.build();
        Assert.assertEquals((long)-1L, (long)certificate.getCertificate().getBasicConstraints());
    }

    @Test
    public void shouldNotSetBasicConstraintsForNonCAs() {
        this.subject.withCa(false);
        X509RouterCertificate certificate = this.subject.build();
        Assert.assertEquals((long)-1L, (long)certificate.getCertificate().getBasicConstraints());
    }

    @Test
    public void shouldHaveCrlDistributionPoints() {
        URI crlURI = URI.create("rsync://foo/bar.crl");
        this.subject.withCrlDistributionPoints(new URI[]{crlURI});
        X509RouterCertificate certificate = this.subject.build();
        Assert.assertEquals((Object)crlURI, (Object)certificate.getCrlDistributionPoints()[0]);
    }

    @Test
    public void shouldHaveAsnExtension() {
        this.subject.withAsns(new int[]{1, 22, 333});
        X509RouterCertificate certificate = this.subject.build();
        byte[] asnExtension = certificate.getCertificate().getExtensionValue(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS.getId());
        IpResourceSet asResources = new ResourceExtensionParser().parseAsIdentifiers(asnExtension);
        Assert.assertEquals((Object)IpResourceSet.parse((String)"AS1, AS22, AS333"), (Object)asResources);
    }

    @Test
    public void shouldHaveBgpExtension() {
        this.subject.withAsns(new int[]{1, 22, 333});
        X509RouterCertificate certificate = this.subject.build();
        Assert.assertTrue((boolean)certificate.isRouter());
    }

    @Test(expected=X509ResourceCertificateBuilderException.class)
    public void shouldFailOnIncorrectProvider() {
        this.subject.withSignatureProvider("foo");
        this.subject.build();
    }
}

