/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import com.google.common.io.Files;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelper;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelperTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderTestUtils;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509GenericCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificateTest;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.properties.URIGen;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class X509ResourceCertificateParserTest {
    private X509ResourceCertificateParser subject = new X509ResourceCertificateParser();

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireResourceCertificatePolicy() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509CertificateBuilderTestUtils.setPoliciesOnBuilderHelperAttribute(builder, new PolicyInformation[0]);
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        this.subject.getCertificate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenOtherCertificatePolicyIsPresent() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509CertificateBuilderTestUtils.setPoliciesOnBuilderHelperAttribute(builder, X509CertificateBuilderHelperTest.CAB_BASELINE_REQUIREMENTS_POLICY);
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        this.subject.getCertificate();
    }

    @Test
    public void shouldParseResourceCertificateWhenResourceExtensionsArePresent() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        X509ResourceCertificate parsed = this.subject.getCertificate();
        Assert.assertEquals((Object)certificate, (Object)parsed);
    }

    @Test
    public void shouldAcceptCertificateWithIdCtCps() throws IOException {
        byte[] encoded = Files.toByteArray((File)new File("src/test/resources/resourcecertificate/apnic-rpki-root-iana-origin-includes-policy-with-cps.cer"));
        this.subject.parse("certificate", encoded);
        Assert.assertTrue((boolean)this.subject.getValidationResult().hasNoFailuresOrWarnings());
    }

    @Test
    public void shouldFailOnInvalidInput() {
        byte[] badlyEncoded = new byte[]{1, 3, 35};
        this.subject.parse("badly", badlyEncoded);
        Assert.assertTrue((boolean)this.subject.getValidationResult().getFailures(new ValidationLocation("badly")).contains(new ValidationCheck(ValidationStatus.ERROR, "cert.parsed", new String[0])));
    }

    @Test
    public void shouldFailOnInvalidSignatureAlgorithm() throws CertificateEncodingException {
        X509CertificateBuilderHelper builder = new X509CertificateBuilderHelper();
        builder.withSubjectDN(new X500Principal("CN=zz.subject")).withIssuerDN(new X500Principal("CN=zz.issuer"));
        builder.withSerial(BigInteger.ONE);
        builder.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR);
        DateTime now = UTC.dateTime();
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)new DateTime(now.getYear() + 1, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC)));
        builder.withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES);
        builder.withSignatureAlgorithm("MD5withRSA");
        X509Certificate certificate = builder.generateCertificate();
        this.subject.parse("certificate", certificate.getEncoded());
        Assert.assertTrue((boolean)this.subject.getValidationResult().hasFailures());
        Assert.assertFalse((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.signature.algorithm").isOk());
    }

    @Test
    public void should_validate_issuer_dn() {
        Assert.assertTrue((String)"serialNumber optional", (boolean)this.validateIssuerDn("CN=test"));
        Assert.assertFalse((String)"mulitple serialNumbers not allowed", (boolean)this.validateIssuerDn("CN=test, serialNumber=1, serialNumber=2"));
        Assert.assertFalse((String)"single CN required", (boolean)this.validateIssuerDn("serialNumber=1"));
        Assert.assertFalse((String)"multiple CNs not allowed", (boolean)this.validateIssuerDn("CN=foo, CN=bar, serialNumber=1"));
        Assert.assertFalse((String)"only printable characters allowed for CN", (boolean)this.validateIssuerDn("CN=test$, serialNumber=1"));
        Assert.assertFalse((String)"only printable characters allowed for serialNumber", (boolean)this.validateIssuerDn("CN=test, serialNumber=$"));
    }

    @Test
    public void should_validate_subject_dn() {
        Assert.assertTrue((String)"serialNumber optional", (boolean)this.validateSubjectDn("CN=test"));
        Assert.assertFalse((String)"mulitple serialNumbers not allowed", (boolean)this.validateSubjectDn("CN=test, serialNumber=1, serialNumber=2"));
        Assert.assertFalse((String)"single CN required", (boolean)this.validateSubjectDn("serialNumber=1"));
        Assert.assertFalse((String)"multiple CNs not allowed", (boolean)this.validateSubjectDn("CN=foo, CN=bar, serialNumber=1"));
        Assert.assertFalse((String)"only printable characters allowed for CN", (boolean)this.validateSubjectDn("CN=test$, serialNumber=1"));
        Assert.assertFalse((String)"only printable characters allowed for serialNumber", (boolean)this.validateSubjectDn("CN=test, serialNumber=$"));
    }

    @Test
    public void should_require_rsync_repository_uri() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, URI.create("rsync://example.com/repository/manifest.mft")), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, URI.create("https://example.com/repository/notify.xml"))});
        X509ResourceCertificate certificate = builder.build();
        ValidationResult result = ValidationResult.withLocation((String)"test");
        X509GenericCertificate certificateWrapper = X509ResourceCertificateParser.parseCertificate((ValidationResult)result, (byte[])certificate.getEncoded());
        Assert.assertNull((Object)certificateWrapper);
        Assert.assertEquals((long)1L, (long)result.getFailuresForCurrentLocation().size());
        Assert.assertEquals((Object)ValidationStatus.PASSED, (Object)result.getResult(new ValidationLocation("test"), "cert.sia.present").getStatus());
        Assert.assertEquals((Object)ValidationStatus.PASSED, (Object)result.getResult(new ValidationLocation("test"), "cert.sia.ca.repository.uri.present").getStatus());
        Assert.assertEquals((Object)ValidationStatus.ERROR, (Object)result.getResult(new ValidationLocation("test"), "cert.sia.ca.repository.rsync.uri.present").getStatus());
    }

    @Property
    public void validURI(@From(value=URIGen.class) @URIGen.URIControls(schemas={"rsync"}) @From(value=URIGen.class) @URIGen.URIControls(schemas={"rsync"}) URI manifestURI, @From(value=URIGen.class) @URIGen.URIControls(schemas={"https"}) @From(value=URIGen.class) @URIGen.URIControls(schemas={"https"}) URI repoURI, @Size(min=0, max=100) @Size(min=0, max=100) List<@From(value=URIGen.class) @URIGen.URIControls(schemas={"https"}) URI> crlURIs) {
        String name = "test";
        Object[] arrayURIs = new URI[crlURIs.size()];
        arrayURIs = crlURIs.toArray(arrayURIs);
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, manifestURI), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, repoURI)}).withCrlDistributionPoints((URI[])arrayURIs);
        X509ResourceCertificate certificate = builder.build();
        Assert.assertEquals((Object)manifestURI, (Object)Arrays.stream(certificate.getSubjectInformationAccess()).filter(f -> f.getMethod().equals((ASN1Primitive)X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST)).map(X509CertificateInformationAccessDescriptor::getLocation).findFirst().get());
        Assert.assertEquals((Object)repoURI, (Object)Arrays.stream(certificate.getSubjectInformationAccess()).filter(f -> f.getMethod().equals((ASN1Primitive)X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY)).map(X509CertificateInformationAccessDescriptor::getLocation).findFirst().get());
        Assert.assertArrayEquals((Object[])arrayURIs, (Object[])certificate.getCrlDistributionPoints());
        ValidationResult result = ValidationResult.withLocation((String)name);
        X509GenericCertificate certificateWrapper = X509ResourceCertificateParser.parseCertificate((ValidationResult)result, (byte[])certificate.getEncoded());
        Assert.assertNull((Object)certificateWrapper);
        Assert.assertEquals((long)1L, (long)result.getFailuresForCurrentLocation().size());
        Assert.assertEquals((Object)ValidationStatus.PASSED, (Object)result.getResult(new ValidationLocation(name), "cert.sia.present").getStatus());
        Assert.assertEquals((Object)ValidationStatus.PASSED, (Object)result.getResult(new ValidationLocation(name), "cert.sia.ca.repository.uri.present").getStatus());
        Assert.assertEquals((Object)ValidationStatus.ERROR, (Object)result.getResult(new ValidationLocation(name), "cert.sia.ca.repository.rsync.uri.present").getStatus());
    }

    @Test
    public void should_validate_key_algorithm_and_size() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        Assert.assertTrue((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.public.key.algorithm").isOk());
        Assert.assertTrue((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.public.key.size").isOk());
    }

    @Test
    public void should_parse_resource_certificate_when_its_unknown() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509ResourceCertificate certificate = builder.build();
        ValidationResult result = ValidationResult.withLocation((String)"test");
        X509GenericCertificate certificateWrapper = X509ResourceCertificateParser.parseCertificate((ValidationResult)result, (byte[])certificate.getEncoded());
        Assert.assertTrue((boolean)(certificateWrapper instanceof X509ResourceCertificate));
        X509ResourceCertificate parsed = (X509ResourceCertificate)certificateWrapper;
        Assert.assertEquals((Object)parsed.getPublicKey(), (Object)certificate.getPublicKey());
        Assert.assertEquals((Object)parsed.getResources(), (Object)certificate.getResources());
    }

    @Test
    public void should_parse_router_certificate_when_its_unknown() {
        X509RouterCertificateBuilder builder = X509RouterCertificateTest.createSelfSignedRouterCertificateBuilder().withAsns(new int[]{1, 2, 3});
        X509RouterCertificate certificate = builder.build();
        ValidationResult result = ValidationResult.withLocation((String)"test");
        X509GenericCertificate certificateWrapper = X509ResourceCertificateParser.parseCertificate((ValidationResult)result, (byte[])certificate.getEncoded());
        Assert.assertTrue((boolean)(certificateWrapper instanceof X509RouterCertificate));
        X509RouterCertificate parsed = (X509RouterCertificate)certificateWrapper;
        Assert.assertEquals((Object)parsed.getPublicKey(), (Object)certificate.getPublicKey());
    }

    private boolean validateIssuerDn(String name) {
        X509ResourceCertificate certificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withCrlDistributionPoints(new URI[]{URI.create("rsync://rpki.example.com/crl.crl")}).withIssuerDN(new X500Principal(name)).build();
        this.subject.parse("certificate", certificate.getEncoded());
        return this.subject.getValidationResult().getFailuresForCurrentLocation().isEmpty();
    }

    private boolean validateSubjectDn(String name) {
        X509ResourceCertificate certificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withCrlDistributionPoints(new URI[]{URI.create("rsync://rpki.example.com/crl.crl")}).withSubjectDN(new X500Principal(name)).build();
        this.subject.parse("certificate", certificate.getEncoded());
        return this.subject.getValidationResult().getFailuresForCurrentLocation().isEmpty();
    }
}

