/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.net.URI;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoder;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilderException;
import net.ripe.rpki.commons.util.UTC;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X509ResourceCertificateBuilderTest {
    private X509ResourceCertificateBuilder subject;

    @Before
    public void setUp() {
        this.subject = new X509ResourceCertificateBuilder();
        this.subject.withSubjectDN(new X500Principal("CN=zz.subject")).withIssuerDN(new X500Principal("CN=zz.issuer"));
        this.subject.withSerial(BigInteger.ONE);
        this.subject.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        this.subject.withSigningKeyPair(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR);
        DateTime now = UTC.dateTime();
        this.subject.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)new DateTime(now.getYear() + 1, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.subject.withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES);
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireResourcesForResourceCertificates() {
        this.subject.withResources(null);
        this.subject.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireNonEmptyResourceSetForResourceCertificates() {
        this.subject.withResources(IpResourceSet.parse((String)""));
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireIssuer() {
        this.subject.withIssuerDN(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireSubject() {
        this.subject.withSubjectDN(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireSerial() {
        this.subject.withSerial(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequirePublicKey() {
        this.subject.withPublicKey(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireSigningKeyPair() {
        this.subject.withSigningKeyPair(null);
        this.subject.build();
    }

    @Test(expected=NullPointerException.class)
    public void shouldRequireValidityPeriod() {
        this.subject.withValidityPeriod(null);
        this.subject.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowKeyCertSignForNonCAs() {
        this.subject.withCa(false);
        this.subject.withKeyUsage(4);
        this.subject.build();
    }

    @Test
    public void shouldSetBasicConstraintsForCAs() {
        this.subject.withCa(true);
        X509ResourceCertificate certificate = this.subject.build();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)certificate.getCertificate().getBasicConstraints());
    }

    @Test
    public void shouldNotSetBasicConstraintsForNonCAs() {
        this.subject.withCa(false);
        X509ResourceCertificate certificate = this.subject.build();
        Assert.assertEquals((long)-1L, (long)certificate.getCertificate().getBasicConstraints());
    }

    @Test
    public void shouldHaveSubjectKeyIdentifierForResourceCertificates() {
        this.subject.withResources(IpResourceSet.parse((String)"10/8"));
        X509ResourceCertificate certificate = this.subject.build();
        Assert.assertNotNull((Object)certificate.getSubjectKeyIdentifier());
    }

    @Test
    public void shouldHaveAuthorityKeyIdentifierForResourceCertificates() {
        this.subject.withResources(IpResourceSet.parse((String)"10/8"));
        this.subject.withAuthorityKeyIdentifier(true);
        X509ResourceCertificate certificate = this.subject.build();
        Assert.assertNotNull((Object)certificate.getAuthorityKeyIdentifier());
    }

    @Test
    public void shouldHaveResourceExtensionForResourceCertificates() {
        this.subject.withResources(IpResourceSet.parse((String)"10/8, AS123"));
        X509ResourceCertificate certificate = this.subject.build();
        Assert.assertNotNull((Object)certificate.getCertificate().getExtensionValue(ResourceExtensionEncoder.OID_IP_ADDRESS_BLOCKS.getId()));
        Assert.assertNotNull((Object)certificate.getCertificate().getExtensionValue(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS.getId()));
    }

    @Test
    public void shouldHaveKeyUsageIfSet() {
        this.subject.withCa(true);
        this.subject.withKeyUsage(6);
        this.subject.withResources(IpResourceSet.parse((String)"10/8"));
        X509ResourceCertificate certificate = this.subject.build();
        Assert.assertNotNull((Object)certificate.getCertificate().getKeyUsage());
    }

    @Test
    public void shouldHaveCrlDistributionPoints() {
        URI crlURI = URI.create("rsync://foo/bar.crl");
        this.subject.withCrlDistributionPoints(new URI[]{crlURI});
        X509ResourceCertificate certificate = this.subject.build();
        Assert.assertEquals((Object)crlURI, (Object)certificate.getCrlDistributionPoints()[0]);
    }

    @Test(expected=X509ResourceCertificateBuilderException.class)
    public void shouldFailOnIncorrectProvider() {
        this.subject.withSignatureProvider("foo");
        this.subject.build();
    }
}

