/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelper;
import net.ripe.rpki.commons.util.UTC;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X509CertificateBuilderHelperTest {
    public static final PolicyInformation CAB_BASELINE_REQUIREMENTS_POLICY = new PolicyInformation(new ASN1ObjectIdentifier("2.23.140.1.2.2"));
    private X509CertificateBuilderHelper subject;

    @Before
    public void setUp() {
        this.subject = new X509CertificateBuilderHelper();
        this.subject.withSubjectDN(new X500Principal("CN=zz.subject")).withIssuerDN(new X500Principal("CN=zz.issuer"));
        this.subject.withSerial(BigInteger.ONE);
        this.subject.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        this.subject.withSigningKeyPair(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR);
        DateTime now = UTC.dateTime();
        this.subject.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)new DateTime(now.getYear() + 1, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.subject.withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnIncorrectAlgorithm() {
        this.subject.withSignatureAlgorithm("foo");
        this.subject.generateCertificate();
    }

    @Test
    public void shouldMakeSureTheresNoExtendedKeyUsage() throws CertificateParsingException {
        X509Certificate x509Certificate = this.subject.generateCertificate();
        Assert.assertNull(x509Certificate.getExtendedKeyUsage());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnEmptyResources() {
        this.subject.withResources(new IpResourceSet());
        this.subject.generateCertificate();
    }

    @Test
    public void shouldNotFailOnOneInheritResourceType() {
        this.subject.withResources(new IpResourceSet());
        this.subject.withInheritedResourceTypes(EnumSet.of(IpResourceType.IPv4));
        this.subject.generateCertificate();
    }

    public void shouldAcceptArbitraryPolicyWhichShouldBeCritical() {
        this.subject.withPolicies(new PolicyInformation[]{CAB_BASELINE_REQUIREMENTS_POLICY});
        this.subject.generateCertificate().getCriticalExtensionOIDs().contains(CAB_BASELINE_REQUIREMENTS_POLICY.getPolicyIdentifier().toString());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldFailOnRepeatedPolicies() {
        this.subject.withPolicies(new PolicyInformation[]{AbstractX509CertificateWrapper.POLICY_INFORMATION});
        this.subject.withPolicies(new PolicyInformation[]{CAB_BASELINE_REQUIREMENTS_POLICY});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnNegativeSerial() {
        this.subject.withSerial(BigInteger.ONE.negate());
        this.subject.generateCertificate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnNeutralIntegerSerial() {
        this.subject.withSerial(BigInteger.ZERO);
        this.subject.generateCertificate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnTooLargeSerial() {
        this.subject.withSerial(BigInteger.ONE.shiftLeft(160));
        this.subject.generateCertificate();
    }
}

